/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1String
extends ASN1Object {
    protected byte[] value;

    protected ASN1String() {
        this.isStringType = true;
    }

    public Object clone() {
        ASN1String aSN1String = (ASN1String)super.clone();
        if (this.value != null) {
            aSN1String.value = (byte[])this.value.clone();
        }
        return aSN1String;
    }

    public void setIndefiniteLength(boolean bl) {
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.value);
    }

    protected void decode(int n2, InputStream inputStream) throws IOException {
        if (n2 == -1) {
            throw new IOException("Invalid indefinite length encoding for primitive encoded String type!");
        }
        try {
            this.value = new byte[n2];
            Util.fillArray(this.value, inputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 STRING value!");
        }
    }

    public byte[] getByteValue() {
        return this.value;
    }

    public String toString() {
        return super.toString() + "\"" + this.getValue() + "\"";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ASN1String)) {
            return false;
        }
        ASN1String aSN1String = (ASN1String)object;
        return CryptoUtils.equalsBlock(this.value, aSN1String.value);
    }

    public int hashCode() {
        return this.asnType.hashCode() ^ Util.calculateHashCode(this.value);
    }
}

