/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class INTEGER
extends ASN1Object {
    byte[] a = null;

    protected INTEGER() {
        this.asnType = ASN.INTEGER;
    }

    public INTEGER(BigInteger bigInteger) {
        this();
        if (bigInteger == null) {
            throw new NullPointerException("value must not be null!");
        }
        this.a = bigInteger.toByteArray();
    }

    public INTEGER(int n2) {
        this();
        this.a = BigInteger.valueOf(n2).toByteArray();
    }

    public Object getValue() {
        return new BigInteger(this.a);
    }

    public void setValue(Object object) {
        this.a = ((BigInteger)object).toByteArray();
    }

    public void setIndefiniteLength(boolean bl) {
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.a);
    }

    protected void decode(int n2, InputStream inputStream) throws IOException {
        if (n2 == -1) {
            throw new IOException("Invalid indefinite length encoding for primitive encoded INTEGER type!");
        }
        try {
            this.a = new byte[n2];
            Util.fillArray(this.a, inputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 INTEGER value!");
        }
    }

    public String toString() {
        return super.toString() + this.getValue().toString();
    }
}

