/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs5;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBKDF2;
import iaik.pkcs.pkcs5.PBKDF2ParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class PBKDF2Parameters
extends AlgorithmParametersSpi {
    private PBKDF2ParameterSpec b;
    static Class a;

    private static ASN1Object a(PBKDF2ParameterSpec pBKDF2ParameterSpec) {
        return PBKDF2Parameters.a(pBKDF2ParameterSpec.getSalt(), pBKDF2ParameterSpec.getIterationCount(), pBKDF2ParameterSpec.getDerivedKeyLength(), pBKDF2ParameterSpec.getPrf());
    }

    static ASN1Object a(byte[] byArray, int n2, int n3, AlgorithmID algorithmID) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(byArray));
        sEQUENCE.addComponent(new INTEGER(n2));
        if (n3 > 0) {
            sEQUENCE.addComponent(new INTEGER(n3));
        }
        if (algorithmID != null && !algorithmID.equals(PBKDF2.a)) {
            sEQUENCE.addComponent(algorithmID.toASN1Object());
        }
        return sEQUENCE;
    }

    static PBKDF2ParameterSpec a(ASN1Object aSN1Object) throws CodingException {
        ASN1Object aSN1Object2;
        if (aSN1Object == null) {
            throw new CodingException("PBKDF2 algorithm parameters must not be null!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("PBKDF2 parameters must be ASN.1 SEQUENCE!");
        }
        int n2 = 0;
        int n3 = aSN1Object.countComponents();
        if (n3 < 2 || n3 > 4) {
            throw new CodingException("Invalid number of PBKDF2 parameter components (" + n3 + "). Must be 2, 3 or 4!");
        }
        byte[] byArray = null;
        int n4 = 0;
        int n5 = 32;
        AlgorithmID algorithmID = null;
        if (!(aSN1Object2 = aSN1Object.getComponentAt(n2++)).isA(ASN.OCTET_STRING)) {
            throw new CodingException("Invalid PBKDF2 param salt component. Only OCTET STRING supported!");
        }
        byArray = (byte[])aSN1Object2.getValue();
        if (!(aSN1Object2 = aSN1Object.getComponentAt(n2++)).isA(ASN.INTEGER)) {
            throw new CodingException("Invalid PBKDF2 param iteration count component. Must be INTEGER!");
        }
        n4 = ((BigInteger)aSN1Object2.getValue()).intValue();
        while (n2 < n3) {
            if ((aSN1Object2 = aSN1Object.getComponentAt(n2++)).isA(ASN.INTEGER)) {
                n5 = ((BigInteger)aSN1Object2.getValue()).intValue();
                continue;
            }
            if (!aSN1Object2.isA(ASN.SEQUENCE)) continue;
            algorithmID = new AlgorithmID(aSN1Object2);
        }
        PBKDF2ParameterSpec pBKDF2ParameterSpec = new PBKDF2ParameterSpec(byArray, n4, n5);
        if (algorithmID != null) {
            pBKDF2ParameterSpec.setPrf(algorithmID);
        }
        return pBKDF2ParameterSpec;
    }

    protected byte[] engineGetEncoded() throws IOException {
        if (this.b == null) {
            throw new IllegalStateException("PBKDF2Parameters not initialized yet!");
        }
        ASN1Object aSN1Object = PBKDF2Parameters.a(this.b);
        return DerCoder.encode(aSN1Object);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (this.b == null) {
            throw new IllegalStateException("PBKDF2Parameters not initialized yet!");
        }
        if (!(a == null ? (a = PBKDF2Parameters.class$("iaik.pkcs.pkcs5.PBKDF2ParameterSpec")) : a).isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return this.b;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBKDF2ParameterSpec)) {
            throw new InvalidParameterSpecException("paramSpec must be PBKDF2ParameterSpec.");
        }
        this.b = (PBKDF2ParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            this.b = PBKDF2Parameters.a(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding PBKDF2 parameters: " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return this.b == null ? "" : this.b.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

