/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;

public class SignedData
extends SignedDataStream
implements Content {
    byte[] f;
    private ContentInfo a;
    static Class g;

    protected SignedData() {
        this.block_size = -1;
    }

    public SignedData(ObjectID objectID) {
        this();
        this.content_type = objectID;
    }

    public SignedData(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public SignedData(byte[] byArray, int n2) {
        this();
        this.f = byArray;
        this.mode = n2;
        this.content_type = ObjectID.pkcs7_data;
    }

    public SignedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray) throws NoSuchAlgorithmException {
        this();
        this.f = byArray;
        this.mode = 2;
        this.h.a(algorithmIDArray);
        this.setupMessageDigests();
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray, int n2) throws NoSuchAlgorithmException {
        this();
        this.f = byArray;
        this.mode = 2;
        if (n2 == 2) {
            this.version = 2;
        } else if (n2 != 1) {
            throw new IllegalArgumentException("Invalid version: " + n2);
        }
        this.h.a(algorithmIDArray);
        this.setupMessageDigests();
    }

    public void addSignerInfo(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        signerInfo.a = this;
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        if (!this.h.c(algorithmID)) {
            if (this.f != null) {
                MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
                byte[] byArray = null;
                byArray = this.version == 2 ? messageDigest.digest(DerCoder.encode(new OCTET_STRING(this.f))) : messageDigest.digest(this.f);
                this.h.a(algorithmID, byArray);
            } else {
                this.h.a(algorithmID);
            }
        }
        this.signer_infos.addElement(signerInfo);
    }

    protected void setupMessageDigests() throws NoSuchAlgorithmException {
        if (this.version == 2) {
            this.h.a(DerCoder.encode(new OCTET_STRING(this.f)));
        } else {
            this.h.a(this.f);
        }
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        this.i = false;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            this.h.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), g == null ? (g = SignedData.class$("iaik.asn1.structures.AlgorithmID")) : g));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms!");
        }
        this.a = new ContentInfo(this.this_object);
        this.content_type = this.a.getContentType();
        if (!this.a.hasContent()) {
            this.mode = 2;
            this.notifyEOF();
            return;
        }
        if (!this.content_type.equals(ObjectID.pkcs7_data)) {
            throw new PKCSParsingException("SignedData only for content type Data at this time!");
        }
        Data data = (Data)this.a.getContent();
        this.f = data.getData();
        try {
            this.setupMessageDigests();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSParsingException(noSuchAlgorithmException.getMessage());
        }
        this.notifyEOF();
    }

    public void setInputStream(InputStream inputStream) {
        this.input_stream = inputStream;
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Util.copyStream(this.input_stream, byteArrayOutputStream, null);
                this.f = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new InternalErrorException("Error reading from stream!", exception);
            }
        }
    }

    public void setVersion(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
        this.version = n2;
    }

    public InputStream getInputStream() {
        if (this.f == null) {
            return null;
        }
        return new ByteArrayInputStream(this.f);
    }

    public byte[] getContent() {
        return this.f;
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        this.a = this.mode == 1 && this.f != null ? new ContentInfo(new Data(this.f, n2)) : new ContentInfo(ObjectID.pkcs7_data);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent(new INTEGER(this.version));
            if (this.version == 2) {
                Object object;
                sEQUENCE.addComponent(ASN.createSequenceOf(this.h.a()));
                sEQUENCE.addComponent(this.a.toASN1Object());
                if (this.certificates != null) {
                    object = ASN.createSequenceOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(2, (ASN1Object)object, true));
                }
                if (this.crls != null) {
                    object = ASN.createSequenceOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object, true));
                }
                object = this.signer_infos.elements();
                while (object.hasMoreElements()) {
                    ((SignerInfo)object.nextElement()).b = 2;
                }
                sEQUENCE.addComponent(ASN.createSequenceOf(this.signer_infos));
            } else {
                ASN1Object aSN1Object;
                sEQUENCE.addComponent(ASN.createSetOf(this.h.a()));
                sEQUENCE.addComponent(this.a.toASN1Object());
                if (this.certificates != null) {
                    aSN1Object = ASN.createSetOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
                }
                if (this.crls != null) {
                    aSN1Object = ASN.createSetOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
                }
                sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
            }
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        AlgorithmID[] algorithmIDArray = this.h.a();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            for (n2 = 0; n2 < algorithmIDArray.length; ++n2) {
                stringBuffer.append(algorithmIDArray[n2].getName() + ",");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        if (this.a == null) {
            stringBuffer.append("ContentInfo: yet not set\n");
        } else {
            stringBuffer.append("ContentInfo: {\n" + this.a.toString(bl));
            stringBuffer.append("\n}\n");
        }
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(((SignerInfo)enumeration.nextElement()).toString(true) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

