/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.IvParameters;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class RC2Parameters
extends IvParameters {
    static final int[] b = new int[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
    static final int[] c = new int[256];
    int d;

    protected byte[] engineGetEncoded() throws IOException {
        try {
            ConstructedType constructedType;
            if (this.d > 0) {
                constructedType = new SEQUENCE();
                ((ASN1Object)constructedType).addComponent(new INTEGER(this.d));
                ((ASN1Object)constructedType).addComponent(new OCTET_STRING(this.a));
            } else {
                constructedType = new OCTET_STRING(this.a);
            }
            return DerCoder.encode(constructedType);
        }
        catch (CodingException codingException) {
            throw new IOException("Cannot encode RC2 parameters: " + codingException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        int n2 = RC2Parameters.b(this.d);
        RC2ParameterSpec rC2ParameterSpec = new RC2ParameterSpec(n2, this.a);
        if (!rC2ParameterSpec.getClass().isAssignableFrom(clazz)) {
            return super.engineGetParameterSpec(clazz);
        }
        return rC2ParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
            this.d = RC2Parameters.a(rC2ParameterSpec.getEffectiveKeyBits());
            this.a = rC2ParameterSpec.getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.a = ivParameterSpec.getIV();
            this.d = -1;
        } else {
            throw new InvalidParameterSpecException("Parameter must be IvParameterSpec or RC2ParameterSpec.");
        }
        if (this.a == null) {
            this.a = new byte[8];
        }
        if (this.a.length != 8) {
            throw new InvalidParameterSpecException("IV must be 8 octets long!");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            if (aSN1Object.isA(ASN.SEQUENCE)) {
                this.d = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
                this.a = (byte[])aSN1Object.getComponentAt(1).getValue();
            } else if (aSN1Object.isA(ASN.OCTET_STRING)) {
                this.d = -1;
                this.a = (byte[])aSN1Object.getValue();
            } else {
                throw new IOException("Cannot decode RC2 params. Invalid ASN.1 type!");
            }
            if (this.a == null || this.a.length != 8) {
                throw new IOException("Cannot init RC2 params. Invalid IV; must be 8 octets long.");
            }
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.d > 0) {
            stringBuffer.append("rc2ParameterVersion: " + this.d + "\n");
        }
        stringBuffer.append("IV: " + Util.toString(this.a) + "\n");
        return stringBuffer.toString();
    }

    static int a(int n2) {
        if (n2 >= 256) {
            return n2;
        }
        return b[n2];
    }

    static int b(int n2) {
        if (n2 <= 0) {
            return 128;
        }
        if (n2 >= 256) {
            return n2;
        }
        return c[n2];
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            RC2Parameters.c[RC2Parameters.b[i2]] = i2;
        }
    }
}

