/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHParameterGenerator;
import iaik.security.dh.DHPrivateKey;
import iaik.security.dh.DHPublicKey;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private static final byte[] c = new byte[]{2};
    private static final byte[] d = new byte[]{-1, -57, -123, 98, 127, -101, 46, 102, -36, 85, -49, -49, -107, -127, 82, -108, -56, -54, 76, 37, 121, -93, 107, -111, 34, 64, -92, -102, -118, -49, -103, 80, -27, -71, 101, -23, 12, 58, 67, 92, -128, 78, 45, 62, 124, 104, -3, -31, 24, -100, 69, 80, -37, -46, -97, -122, -123, 86, -90, 87, 29, 124, -122, -3};
    private static final byte[] e = new byte[]{-24, 8, -30, 27, -100, 77, 111, -54, 99, -28, -39, 119, 15, 85, -58, 20, 80, 110, 93, 103, -32, 27, 97, -78, 50, 43, 35, -127, -65, -79, 58, -5, 104, -66, -92, 20, -32, -91, 35, -85, 56, 18, -34, -71, 98, -14, -50, -72, 93, 91, -70, -110, 38, -43, -7, -113, 34, 72, 14, 32, 16, -20, 89, 77, 89, 125, -59, -48, -35, -25, -114, -32, -84, 94, 5, -48, -85, -28, 51, -6, 102, -99, 98, -21, -100, -114, 107, 29, 80, 122, -55, 28, 126, 7, -127, 119, -8, 17, -35, -16, 55, 112, 27, 11, -98, 30, -63, 74, 5, -48, -109, -27, 81, 97, -105, -16, 51, 71, 125, 16, 59, -98, 33, -125, -8, -29, 87, -93};
    private static final byte[] f = new byte[]{-7, -37, -32, -24, -78, 40, -124, -24, -1, 62, 25, -60, 114, -5, 12, 116, 80, 36, -37, 108, -34, 20, -56, -21, 91, 121, 49, 55, -96, -18, -2, -102, -73, -51, 11, -5, 54, 27, -127, 83, 111, -81, 116, -105, 119, -29, -104, 121, -92, -33, 14, -47, 71, 65, 110, -126, 111, 122, -94, 118, 111, -104, 1, -7, -15, 118, -48, -16, -69, -15, -38, -84, -77, -29, -111, 69, 2, 55, 32, 11, 44, 54, 63, -7, -16, -53, -28, -122, 59, -100, -10, -38, 11, -107, 61, 39, 23, -91, -101, 61, -115, -30, -122, -37, 47, -67, 47, 2, 109, 74, -124, -32, -14, 42, 112, 5, -42, 20, -65, 12, 127, -12, -27, 40, 21, -69, 101, 10, -122, -93, -53, -90, -83, -84, 78, -23, 24, 69, 44, 61, -101, 42, -86, -94, -44, -97, 98, 87, -48, -58, 48, 37, -118, 86, -45, -97, -7, 4, 116, 22, 31, -125, 47, 79, -127, 19, -86, -28, 5, -36, 43, 19, -49, -53, -100, -44, 81, -120, 93, -116, -8, -113, 79, 114, -36, -54, -52, -99, 126, 127, 71, 114, -122, 87, 66, 16, -111, -34, -12, 37, 9, 116, -90, -127, 123, -116, 75, -76, 78, -52, 76, 67, 77, -70, -101, 113, -109, -98, -9, 94, 68, 111, -113, -49, 120, -76, 89, -97, 4, -112, 101, 7, 12, 58, -42, -107, 23, -53, -92, -128, -13, -42, -99, 13, -14, -1, -21, 19, 57, -67, 77, -11, 0, -65, 122, 83};
    private SecureRandom g;
    private int h = -1;
    private int i = -1;
    BigInteger a;
    BigInteger b;

    public DHKeyPairGenerator() {
        super("DH");
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.g = secureRandom;
        this.h = n2;
        switch (this.h) {
            case 512: {
                this.a = new BigInteger(1, d);
                this.b = new BigInteger(c);
                break;
            }
            case 1024: {
                this.a = new BigInteger(1, e);
                this.b = new BigInteger(c);
                break;
            }
            case 2048: {
                this.a = new BigInteger(1, f);
                this.b = new BigInteger(c);
                break;
            }
            default: {
                this.a = null;
                this.b = null;
            }
        }
        this.i = -1;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.g = secureRandom;
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            this.a = ((DHParameterSpec)algorithmParameterSpec).getP();
            this.b = ((DHParameterSpec)algorithmParameterSpec).getG();
            this.h = this.a.bitLength();
            this.i = ((DHParameterSpec)algorithmParameterSpec).getL();
            if (this.i > this.h) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a DHParameterSpec.");
        }
    }

    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        if (this.g == null) {
            this.g = SecRandom.getDefault();
        }
        if (this.h < 0) {
            this.h = 1024;
        }
        if (this.i <= 0) {
            this.i = 300;
            if (this.h > 7680) {
                this.i = this.h > 15360 ? 512 : 384;
            }
        }
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.a, this.b);
        if (this.a == null || this.b == null) {
            try {
                object2 = new DHGenParameterSpec(this.h, this.i);
                object = new DHParameterGenerator();
                ((DHParameterGenerator)object).engineInit((AlgorithmParameterSpec)object2, this.g);
                AlgorithmParameters algorithmParameters = ((DHParameterGenerator)object).engineGenerateParameters();
                dHParameterSpec = (DHParameterSpec)algorithmParameters.getParameterSpec(dHParameterSpec.getClass());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.toString());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException(invalidParameterSpecException.toString());
            }
        }
        BigInteger bigInteger = new BigInteger(this.i, this.g).setBit(this.i - 1);
        object2 = new DHPrivateKey(bigInteger, dHParameterSpec);
        BigInteger bigInteger2 = dHParameterSpec.getG().modPow(bigInteger, dHParameterSpec.getP());
        object = new DHPublicKey(bigInteger2, dHParameterSpec);
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }
}

