/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.elgamal;

import iaik.asn1.ASN1;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.security.elgamal.ElGamalParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class ElGamalParameters
extends AlgorithmParametersSpi {
    BigInteger a;
    BigInteger b;
    private int c = -1;

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(new INTEGER(this.b));
        if (this.c > 0) {
            sEQUENCE.addComponent(new INTEGER(this.c));
        }
        try {
            return new ASN1(sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IOException("Encoding error. " + codingException.toString());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        ElGamalParameterSpec elGamalParameterSpec = new ElGamalParameterSpec(this.a, this.b, this.c);
        if (!elGamalParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return elGamalParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter must be ElGamalParameterSpec.");
        }
        this.a = ((ElGamalParameterSpec)algorithmParameterSpec).getP();
        this.b = ((ElGamalParameterSpec)algorithmParameterSpec).getG();
        this.c = ((ElGamalParameterSpec)algorithmParameterSpec).getL();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1 aSN1 = new ASN1(byArray);
            this.a = (BigInteger)aSN1.getComponentAt(0).getValue();
            this.b = (BigInteger)aSN1.getComponentAt(1).getValue();
            if (aSN1.countComponents() > 2) {
                this.c = ((BigInteger)aSN1.getComponentAt(0).getValue()).intValue();
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.c;
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p: " + this.a + "\n");
        stringBuffer.append("g: " + this.b + "\n");
        if (this.c <= 0) {
            stringBuffer.append("l: " + this.c + "\n");
        }
        return stringBuffer.toString();
    }
}

