/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.pbe;

import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.random.SecRandom;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class PBEParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom a;
    private int b = 8;
    private int c = 2000;

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.b = n2;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.a = secureRandom;
        if (!(algorithmParameterSpec instanceof PBEGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("param must be an instance of PBEGenParameterSpec.");
        }
        this.b = ((PBEGenParameterSpec)algorithmParameterSpec).getSaltLength();
        this.c = ((PBEGenParameterSpec)algorithmParameterSpec).getIterationCount();
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.a == null) {
            this.a = SecRandom.getDefault();
        }
        byte[] byArray = new byte[this.b];
        this.a.nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, this.c);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBE", "IAIK");
            algorithmParameters.init(pBEParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.toString());
        }
    }
}

