/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.security.random.SHA1SP80090Random;
import iaik.security.random.SHA256SP80090Random;
import iaik.security.random.SHA384SP80090Random;
import iaik.security.random.SHA512SP80090Random;
import iaik.security.random.SP80090Random;
import iaik.security.rsa.RSAKeyPairGenerator;
import iaik.utils.NumberTheory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.SecureRandom;

public class RSAKeyPairGeneratorFIPS
extends RSAKeyPairGenerator {
    private static final BigDecimal a = new BigDecimal(Math.sqrt(2.0));
    public static final int KEYLENGTH_1024 = 1024;
    public static final int KEYLENGTH_2048 = 2048;
    public static final int KEYLENGTH_3072 = 3072;
    public static final BigInteger LOWER_PUBLIC_EXPONENT_BOUND = NumberTheory.ZERO.setBit(16).setBit(0);
    public static final BigInteger UPPER_PUBLIC_EXPONENT_BOUND = NumberTheory.ZERO.setBit(256).subtract(NumberTheory.ONE);
    private int b = 0;
    private int c = 0;

    public RSAKeyPairGeneratorFIPS() {
        super("RSA-FIPS-186-3");
    }

    RSAKeyPairGeneratorFIPS(String string) {
        super(string);
    }

    void a(int n2, BigInteger bigInteger, SecureRandom secureRandom) {
        if (n2 != 1024 && n2 != 2048 && n2 != 3072) {
            throw new InvalidParameterException("Key size not supported!");
        }
        if (bigInteger != null && (bigInteger.compareTo(LOWER_PUBLIC_EXPONENT_BOUND) < 0 || bigInteger.compareTo(UPPER_PUBLIC_EXPONENT_BOUND) > 0)) {
            throw new InvalidParameterException("The public exponent must lie in the range between 2^16 + 1 and 2^256 - 1");
        }
        this.b();
        switch (n2) {
            case 1024: {
                this.b = 104;
                this.c = 80;
                break;
            }
            case 2048: {
                this.b = 144;
                this.c = 112;
                break;
            }
            case 3072: {
                this.b = 176;
                this.c = 128;
            }
        }
    }

    private boolean a(BigInteger bigInteger, int n2) {
        if (NumberTheory.hasSmallFactors(bigInteger)) {
            return false;
        }
        int n3 = 0;
        if (n2 == 512) {
            n3 = 7;
        } else if (n2 == 1024) {
            n3 = 4;
        } else if (n2 == 1536) {
            n3 = 3;
        } else if (n2 > 100) {
            n3 = n2 <= 140 ? 38 : (n2 <= 170 ? 32 : 27);
        }
        BigInteger bigInteger2 = bigInteger.subtract(NumberTheory.ONE);
        int n4 = bigInteger2.getLowestSetBit();
        BigInteger bigInteger3 = bigInteger2.shiftRight(n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            BigInteger bigInteger4;
            while ((bigInteger4 = new BigInteger(n2, this.random)).compareTo(bigInteger2) >= 0 || bigInteger4.compareTo(NumberTheory.ONE) <= 0) {
            }
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(NumberTheory.ONE) == 0 || bigInteger5.compareTo(bigInteger2) == 0) continue;
            boolean bl = true;
            for (int i3 = 1; i3 < n4; ++i3) {
                if ((bigInteger5 = bigInteger5.modPow(NumberTheory.TWO, bigInteger)).compareTo(bigInteger2) == 0) {
                    bl = false;
                    break;
                }
                if (bigInteger5.compareTo(NumberTheory.ONE) != 0) continue;
                return false;
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    private BigInteger a(int n2) {
        BigInteger bigInteger = new BigInteger(n2, this.random).setBit(0);
        while (!this.a(bigInteger, n2)) {
            bigInteger = bigInteger.add(NumberTheory.TWO);
        }
        return bigInteger;
    }

    /*
     * Unable to fully structure code
     */
    private BigInteger[] a(BigInteger var1_1, BigInteger var2_2, int var3_3) {
        var4_4 = var1_1.shiftLeft(1);
        if (var4_4.gcd(var2_2).compareTo(NumberTheory.ONE) != 0) {
            throw new RuntimeException("RSA keypair generation error!");
        }
        var5_5 = var2_2.modInverse(var4_4).multiply(var2_2).subtract(var4_4.modInverse(var2_2).multiply(var4_4));
        var6_6 = var3_3 >> 1;
        var7_7 = NumberTheory.ONE.shiftLeft(var6_6);
        var8_8 = new BigDecimal(var7_7.shiftRight(1)).multiply(RSAKeyPairGeneratorFIPS.a);
        var9_9 = var8_8.toBigInteger();
        var10_10 = var4_4.multiply(var2_2);
        var11_11 = 5 * var6_6;
        block0: while (true) {
            if (var9_9.compareTo(var12_12 = new BigInteger(var6_6, this.random)) > 0) {
                continue;
            }
            var13_13 = var5_5.subtract(var12_12).mod(var10_10).add(var12_12);
            var14_14 = 0;
            while (true) {
                if (var13_13.compareTo(var7_7) < 0) ** break;
                continue block0;
                var15_15 = var13_13.subtract(NumberTheory.ONE);
                if (var15_15.gcd(this.public_exponent).compareTo(NumberTheory.ONE) == 0 && this.a(var13_13, var6_6)) {
                    return new BigInteger[]{var12_12, var13_13};
                }
                if (++var14_14 >= var11_11) {
                    throw new RuntimeException("RSA keypair generation error!");
                }
                var13_13 = var13_13.add(var10_10);
            }
            break;
        }
    }

    BigInteger[] a() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = this.a(this.b);
        BigInteger bigInteger4 = this.a(this.b);
        BigInteger[] bigIntegerArray = this.a(bigInteger3, bigInteger4, this.keylen);
        BigInteger bigInteger5 = bigIntegerArray[0];
        BigInteger bigInteger6 = bigIntegerArray[1];
        int n2 = this.keylen >> -99;
        do {
            BigInteger bigInteger7 = this.a(this.b);
            BigInteger bigInteger8 = this.a(this.b);
            BigInteger[] bigIntegerArray2 = this.a(bigInteger7, bigInteger8, this.keylen);
            bigInteger2 = bigIntegerArray2[0];
            bigInteger = bigIntegerArray2[1];
        } while (bigInteger5.subtract(bigInteger2).abs().bitLength() <= n2 || bigInteger6.subtract(bigInteger).abs().bitLength() <= n2);
        return new BigInteger[]{bigInteger6, bigInteger};
    }

    void b() {
        SP80090Random sP80090Random = this.c < 112 ? new SHA1SP80090Random() : (this.c <= 128 ? new SHA256SP80090Random() : (this.c <= 192 ? new SHA384SP80090Random() : new SHA512SP80090Random()));
        this.a(sP80090Random);
    }
}

