/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectAltName;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class X509Certificate
extends java.security.cert.X509Certificate
implements ASN1Type {
    private transient ASN1 a;
    private int b;
    private BigInteger c;
    private AlgorithmID d;
    private Name e;
    private ChoiceOfTime f;
    private ChoiceOfTime g;
    private Name h;
    private PublicKey i;
    private BigInteger j;
    private BigInteger k;
    private byte[] l;
    private X509Extensions m;
    private boolean n;
    private byte[] o;

    public X509Certificate() {
        this.b = 1;
        this.a();
        this.a = new ASN1();
    }

    public X509Certificate(InputStream inputStream) throws IOException, CertificateException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        this.decode(inputStream);
    }

    public X509Certificate(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new NullPointerException("Cannot parse certificate from a null byte array!");
        }
        try {
            this.a = new ASN1(byArray);
            this.d();
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.toString());
        }
    }

    public X509Certificate(ASN1Object aSN1Object) throws CertificateException {
        try {
            this.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
    }

    private void a() {
        this.n = true;
        this.o = null;
        this.a = null;
    }

    private void b() {
        if (this.n) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    private void c() {
        this.n = false;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse certificate from a null object!");
        }
        this.a = new ASN1(aSN1Object);
        try {
            this.d();
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public void decode(InputStream inputStream) throws IOException, CertificateException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        try {
            this.a = new ASN1(inputStream);
            this.d();
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.toString());
        }
    }

    private void d() throws CertificateException, X509ExtensionException {
        int n2 = 0;
        ASN1Object aSN1Object = null;
        try {
            Object object;
            if (this.a.countComponents() != 3) {
                throw new CertificateException("Certificate SEQUENCE must have 3 components!");
            }
            ASN1Object aSN1Object2 = this.a.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.a.getComponentAt(1));
            ASN1Object aSN1Object3 = this.a.getComponentAt(2);
            this.l = (byte[])((BIT_STRING)aSN1Object3).getValue();
            ASN1Object aSN1Object4 = aSN1Object2.getComponentAt(0);
            if (aSN1Object4.isA(ASN.CON_SPEC)) {
                object = (BigInteger)((ASN1Object)aSN1Object4.getValue()).getValue();
                this.b = ((BigInteger)object).intValue() + 1;
                ++n2;
            } else {
                this.b = 1;
            }
            this.c = (BigInteger)aSN1Object2.getComponentAt(0 + n2).getValue();
            this.d = new AlgorithmID(aSN1Object2.getComponentAt(1 + n2));
            if (!algorithmID.equals(this.d)) {
                throw new CertificateException("Certificate signature algorithm mismatch");
            }
            this.e = new Name(aSN1Object2.getComponentAt(2 + n2));
            object = new ASN1(aSN1Object2.getComponentAt(3 + n2));
            this.f = new ChoiceOfTime(((ASN1)object).getComponentAt(0));
            this.g = new ChoiceOfTime(((ASN1)object).getComponentAt(1));
            this.h = new Name(aSN1Object2.getComponentAt(4 + n2));
            aSN1Object = aSN1Object2.getComponentAt(5 + n2);
            int n3 = 6 + n2;
            while (n3 < aSN1Object2.countComponents()) {
                CON_SPEC cON_SPEC;
                if ((cON_SPEC = (CON_SPEC)aSN1Object2.getComponentAt(n3++)).getAsnType().getTag() == 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    this.j = new BigInteger(1, (byte[])((ASN1Object)cON_SPEC.getValue()).getValue());
                    continue;
                }
                if (cON_SPEC.getAsnType().getTag() == 2) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    this.k = new BigInteger(1, (byte[])((ASN1Object)cON_SPEC.getValue()).getValue());
                    continue;
                }
                if (cON_SPEC.getAsnType().getTag() != 3) continue;
                this.m = new X509Extensions((ASN1Object)cON_SPEC.getValue());
            }
        }
        catch (RuntimeException runtimeException) {
            throw new CertificateException("Certificate format error: " + runtimeException.toString());
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        try {
            this.i = PublicKeyInfo.getPublicKey(aSN1Object);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertificateException(invalidKeyException.toString());
        }
        this.a.clearASN1Object();
        this.c();
    }

    private ASN1Object e() throws CertificateEncodingException {
        this.b = 1;
        SEQUENCE sEQUENCE = null;
        if (this.c == null) {
            throw new CertificateEncodingException("Serial number not set!");
        }
        if (this.d == null) {
            throw new CertificateEncodingException("Signature algorithm not set!");
        }
        if (this.e == null) {
            throw new CertificateEncodingException("Issuer not set!");
        }
        if (this.f == null) {
            throw new CertificateEncodingException("Valid not before not set!");
        }
        if (this.g == null) {
            throw new CertificateEncodingException("Valid not after not set!");
        }
        if (this.h == null) {
            throw new CertificateEncodingException("Subject not set!");
        }
        if (this.i == null) {
            throw new CertificateEncodingException("Public key not set!");
        }
        if (this.j != null || this.k != null) {
            this.b = 2;
        }
        if (this.m != null) {
            if (this.m.hasExtensions()) {
                this.b = 3;
            } else {
                this.m = null;
            }
        }
        try {
            BIT_STRING bIT_STRING;
            sEQUENCE = new SEQUENCE();
            if (this.b > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.b - 1)));
            }
            sEQUENCE.addComponent(new INTEGER(this.c));
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(this.e.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.f.toASN1Object());
            sEQUENCE2.addComponent(this.g.toASN1Object());
            sEQUENCE.addComponent(sEQUENCE2);
            sEQUENCE.addComponent(this.h.toASN1Object());
            sEQUENCE.addComponent(DerCoder.decode(this.i.getEncoded()));
            if (this.j != null) {
                bIT_STRING = new BIT_STRING(this.j.toByteArray());
                sEQUENCE.addComponent(new CON_SPEC(1, bIT_STRING, true));
            }
            if (this.k != null) {
                bIT_STRING = new BIT_STRING(this.k.toByteArray());
                sEQUENCE.addComponent(new CON_SPEC(2, bIT_STRING, true));
            }
            if (this.m != null && this.m.countExtensions() > 0) {
                sEQUENCE.addComponent(new CON_SPEC(3, this.m.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        this.sign(algorithmID, privateKey, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        Object object;
        if (algorithmID == null) {
            throw new CertificateException("Cannot sign certificate! No signature algorithm specified!");
        }
        this.d = algorithmID;
        Signature signature = this.d.getSignatureInstance(string);
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.d) && !this.d.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.d.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.e();
        this.a();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.l = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.l);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.a = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new CertificateException(signatureException.toString());
        }
        this.c();
    }

    public void setSignature(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Cannot sign certificate! No signature value specified!");
        }
        this.l = byArray;
        ASN1Object aSN1Object = this.e();
        this.a();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(byArray);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.a = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        this.c();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.f == null) {
            throw new CertificateNotYetValidException("ValidNotBefore date not set!");
        }
        if (date.before(this.f.getDate())) {
            throw new CertificateNotYetValidException();
        }
        if (this.g == null) {
            throw new CertificateExpiredException("ValidNotAfter date not set!");
        }
        if (date.after(this.g.getDate())) {
            throw new CertificateExpiredException();
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        this.b();
        return this.toByteArray();
    }

    public int getVersion() {
        return this.b;
    }

    public BigInteger getSerialNumber() {
        return this.c;
    }

    public Principal getIssuerDN() {
        return this.e;
    }

    public Principal getSubjectDN() {
        return this.h;
    }

    public Date getNotBefore() {
        return this.f == null ? null : this.f.getDate();
    }

    public Date getNotAfter() {
        return this.g == null ? null : this.g.getDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            if (this.a != null && this.a.toByteArray() != null) {
                return this.a.getFirstObject();
            }
            return DerCoder.encode(this.e());
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.toString());
        }
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.d = algorithmID;
        this.a();
    }

    public byte[] getSignature() {
        return this.l;
    }

    public String getSigAlgName() {
        String string = null;
        try {
            string = this.d == null ? null : this.d.getImplementationName();
        }
        catch (Exception exception) {
            string = this.d == null ? null : this.d.getName();
        }
        return string;
    }

    public String getSigAlgOID() {
        return this.d == null ? null : this.d.getAlgorithm().getID();
    }

    public byte[] getSigAlgParams() {
        if (this.d == null) {
            return null;
        }
        try {
            ASN1Object aSN1Object = this.d.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public boolean[] getIssuerUniqueID() {
        if (this.j == null) {
            return null;
        }
        String string = this.j.toString(2);
        return this.a(string);
    }

    public boolean[] getSubjectUniqueID() {
        if (this.k == null) {
            return null;
        }
        String string = this.k.toString(2);
        return this.a(string);
    }

    private boolean[] a(String string) {
        boolean[] blArray = new boolean[string.length()];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            blArray[i2] = string.charAt(i2) == '1';
        }
        return blArray;
    }

    public boolean[] getKeyUsage() {
        if (this.m == null) {
            return null;
        }
        try {
            KeyUsage keyUsage = (KeyUsage)this.m.getExtension(KeyUsage.oid);
            if (keyUsage != null) {
                return keyUsage.getBooleanArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getBasicConstraints() {
        int n2 = -1;
        if (this.m != null) {
            try {
                BasicConstraints basicConstraints = (BasicConstraints)this.m.getExtension(BasicConstraints.oid);
                if (basicConstraints != null && basicConstraints.ca() && (n2 = basicConstraints.getPathLenConstraint()) == -1) {
                    n2 = Integer.MAX_VALUE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public void verify() throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(this.i);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.b();
        Signature signature = null;
        signature = string == null ? this.d.getSignatureInstance() : this.d.getSignatureInstance(string);
        try {
            byte[] byArray = this.a.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.l)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, (String)null);
    }

    public void verify(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.b();
        Signature signature = this.d.getSignatureInstance("IAIK");
        try {
            byte[] byArray = this.a.getFirstObject();
            if (algorithmParameterSpec instanceof DSAParameterSpec) {
                signature.setParameter("DSAParameterSpec", algorithmParameterSpec);
            } else {
                signature.setParameter("AlgorithmParameterSpec", algorithmParameterSpec);
            }
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.l)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public ASN1Object toASN1Object() {
        this.b();
        return this.a.toASN1Object();
    }

    public byte[] toByteArray() {
        this.b();
        return this.a.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b();
        this.a.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.a = new ASN1(objectInputStream);
            this.d();
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.c = bigInteger;
        this.a();
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        try {
            this.e = (Name)principal;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Issuer is not an instance of Name.");
        }
        this.a();
    }

    public void setValidNotBefore(Date date) {
        this.f = new ChoiceOfTime(date, true, false);
        this.a();
    }

    public void setValidNotAfter(Date date) {
        this.g = new ChoiceOfTime(date, true, false);
        this.a();
    }

    public void setSubjectDN(Principal principal) throws IllegalArgumentException {
        try {
            this.h = (Name)principal;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Subject is not an instance of Name.");
        }
        this.a();
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.i = publicKey;
        this.a();
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.j = new BigInteger(this.a(blArray), 2);
        this.b = 2;
        this.a();
    }

    public void setSubjectUniqueID(boolean[] blArray) {
        this.k = new BigInteger(this.a(blArray), 2);
        this.b = 2;
        this.a();
    }

    private String a(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (blArray[i2]) {
                stringBuffer.append('1');
                continue;
            }
            stringBuffer.append('0');
        }
        return stringBuffer.toString();
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.d;
    }

    public PublicKey getPublicKey() {
        return this.i;
    }

    public byte[] getFingerprint() {
        this.b();
        return this.a.fingerprint();
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.b();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprintSHA() {
        if (this.o == null) {
            try {
                this.o = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.o;
    }

    public String toString() {
        return this.toString(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.m == null ? null : this.m.getCriticalExtensionOIDs();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.m == null ? null : this.m.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.m == null ? null : this.m.getExtensionValue(string);
    }

    public byte[] getRawExtensionValue(String string) {
        return this.m == null ? null : this.m.getRawExtensionValue(string);
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.m == null) {
            this.m = new X509Extensions();
        }
        this.m.addExtension(v3Extension);
        this.b = 3;
        this.a();
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.m == null ? false : this.m.removeExtension(objectID);
        if (bl) {
            this.a();
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.m != null) {
            this.m.removeAllExtensions();
            this.a();
        }
        this.m = null;
    }

    public Enumeration listExtensions() {
        return this.m == null ? null : this.m.listExtensions();
    }

    public boolean hasExtensions() {
        return this.m == null ? false : this.m.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.m == null ? false : this.m.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.m == null ? 0 : this.m.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.m == null ? null : this.m.getExtension(objectID);
    }

    public String[] getEmailAddresses() {
        Object object;
        Vector<String> vector = new Vector<String>();
        if (this.h != null && (object = this.h.getRDNs(ObjectID.emailAddress)) != null) {
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                vector.addElement(((String)object[i2]).toLowerCase());
            }
        }
        try {
            object = (SubjectAltName)this.getExtension(SubjectAltName.oid);
            if (object != null) {
                Enumeration enumeration = ((SubjectAltName)object).getGeneralNames().getNames();
                while (enumeration.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != 1) continue;
                    vector.addElement(((String)generalName.getName()).toLowerCase());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        if (this.c != null) {
            stringBuffer.append("Serial number: " + this.c + "\n");
        }
        if (this.d != null) {
            stringBuffer.append("Signature algorithm: " + this.d + "\n");
        }
        if (this.e != null) {
            stringBuffer.append("Issuer: " + this.e + "\n");
        }
        if (this.f != null) {
            stringBuffer.append("Valid not before: " + this.f + "\n");
        }
        if (this.g != null) {
            stringBuffer.append("      not after: " + this.g + "\n");
        }
        if (this.h != null) {
            stringBuffer.append("Subject: " + this.h + "\n");
        }
        if (this.i != null) {
            stringBuffer.append(this.i.toString());
        }
        if (this.j != null) {
            stringBuffer.append("Issuer Unique ID: " + this.j + "\n");
        }
        if (this.k != null) {
            stringBuffer.append("Subject Unique ID: " + this.k + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Certificate Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Certificate Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        stringBuffer.append("\n");
        if (this.m != null) {
            if (bl) {
                stringBuffer.append(this.m);
            } else {
                stringBuffer.append("Extensions: " + this.m.countExtensions() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    static {
        Util.toString(null, -1, 1);
    }
}

