/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class BasicAttConstraints
extends V3Extension {
    public static final ObjectID oid = ObjectID.attrCertExt_BasicAttConstraints;
    private boolean a = false;
    private int b = -1;

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new BOOLEAN(this.a));
        if (this.b >= 0) {
            sEQUENCE.addComponent(new INTEGER(this.b));
        }
        return sEQUENCE;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            this.a = (Boolean)aSN1Object.getComponentAt(0).getValue();
            if (aSN1Object.countComponents() == 2) {
                this.b = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                if (this.a && this.b < 0) {
                    throw new CodingException("Error: negative pathLengthConstraint! pathLen:" + this.b);
                }
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.toString());
        }
    }

    public boolean getAuthority() {
        return this.a;
    }

    public int getPathLenConstraint() {
        return this.b;
    }

    public void setPathlenConstraint(int n2) {
        this.b = n2;
    }

    public void setAutority(boolean bl) {
        this.a = bl;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Authority: " + this.a + "\n");
        stringBuffer.append("PathLenConsstrint: " + this.b + "\n");
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

