/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BiometricData
implements ASN1Type {
    private static boolean e = false;
    public static final int picture = 0;
    public static final int handwritten_signature = 1;
    ASN1Object a;
    AlgorithmID b;
    byte[] c;
    String d;

    public BiometricData() {
    }

    public BiometricData(int n2) throws IllegalArgumentException {
        if (n2 < 0 && n2 > 1) {
            throw new IllegalArgumentException("Unknown predefined biometric type: " + n2);
        }
        this.a = new INTEGER(n2);
    }

    public BiometricData(ObjectID objectID) {
        this.a = objectID;
    }

    public BiometricData(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2;
        this.a = aSN1Object.getComponentAt(0);
        if (this.a == null) {
            throw new CodingException("Inavlid BiometricData. No biometricData type!");
        }
        if (this.a.isA(ASN.INTEGER) && (n2 = ((BigInteger)this.a.getValue()).intValue()) < 0 && n2 > 1) {
            throw new CodingException("Unknown predefined biometric type: " + n2);
        }
        this.b = new AlgorithmID(aSN1Object.getComponentAt(1));
        this.c = (byte[])aSN1Object.getComponentAt(2).getValue();
        if (this.c == null) {
            throw new CodingException("Cannot initialize this BiometricData. Missing biometric data hash!");
        }
        if (aSN1Object.countComponents() == 4) {
            this.d = (String)aSN1Object.getComponentAt(3).getValue();
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null) {
            throw new CodingException("Cannot create ASN.1 object. Missing biometricDataOid!");
        }
        if (this.b == null) {
            throw new CodingException("Cannot create ASN.1 object. Missing hash algorithm!");
        }
        if (this.c == null) {
            throw new CodingException("Cannot create ASN.1 object. Missing biometric data hash!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        sEQUENCE.addComponent(this.b.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.c));
        if (this.d != null) {
            sEQUENCE.addComponent(new IA5String(this.d));
        }
        return sEQUENCE;
    }

    public void setSourceDataUri(String string) {
        this.d = string;
    }

    public void setBiometricDataHash(AlgorithmID algorithmID, byte[] byArray) {
        this.b = algorithmID;
        this.c = byArray;
    }

    public void setBiometricDataHash(AlgorithmID algorithmID, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        this.b = algorithmID;
        this.c = this.a(algorithmID, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBiometricDataHash(AlgorithmID algorithmID, String string) throws IOException, NoSuchAlgorithmException {
        this.d = string;
        InputStream inputStream = null;
        try {
            inputStream = this.a(string);
            this.setBiometricDataHash(algorithmID, inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyBiometricDataHash() throws IOException {
        if (this.d == null) {
            throw new IOException("Cannot obtain data. No source data uri included!");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.a(this.d);
            boolean bl = this.verifyBiometricDataHash(inputStream);
            return bl;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public boolean verifyBiometricDataHash(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = this.a(this.b, inputStream);
            if (CryptoUtils.equalsBlock(byArray, this.c)) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Cannot verify hash: " + noSuchAlgorithmException.getMessage());
        }
        return false;
    }

    private InputStream a(String string) throws IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.connect();
        int n2 = httpURLConnection.getResponseCode();
        if (e) {
            System.out.println("Response code: " + n2);
        }
        if (n2 / 100 != 2) {
            throw new IOException("Cannot access source data!");
        }
        int n3 = httpURLConnection.getContentLength();
        if (e) {
            System.out.println("Content length: " + n3);
        }
        if (httpURLConnection.getContentLength() != 0) {
            return httpURLConnection.getInputStream();
        }
        throw new IOException("Cannot access source data!");
    }

    private byte[] a(AlgorithmID algorithmID, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        byte[] byArray = new byte[2048];
        while (digestInputStream.read(byArray) > 0) {
        }
        return messageDigest.digest();
    }

    public ASN1Object getTypeOfBiometricData() {
        return this.a;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.b;
    }

    public byte[] getBiometricDataHash() {
        return this.c;
    }

    public String getBiometricDataHashAsString() {
        return Util.toString(this.c);
    }

    public String getSourceDataUri() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typeOfBiometricData: ");
        if (this.a.isA(ASN.INTEGER)) {
            switch (((BigInteger)this.a.getValue()).intValue()) {
                case 0: {
                    stringBuffer.append("picture");
                    break;
                }
                case 1: {
                    stringBuffer.append("handwritten-signature");
                }
            }
        } else {
            stringBuffer.append(this.a);
        }
        stringBuffer.append("\n");
        stringBuffer.append("hashAlgorithm: " + this.b.getName() + "\n");
        stringBuffer.append("biometricDataHash: " + this.getBiometricDataHashAsString() + "\n");
        if (this.d != null) {
            stringBuffer.append("sourceDataUri: " + this.d + "\n");
        }
        return stringBuffer.toString();
    }
}

