/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures.etsi;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;
import java.util.ArrayList;
import java.util.Iterator;

public class QcEuPDS
extends QCStatementInfo {
    public static final ObjectID statementID = ObjectID.qcEuPDS;
    private ArrayList a = new ArrayList(3);

    public QcEuPDS() {
    }

    public QcEuPDS(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public void addPdsLocation(PdsLocation pdsLocation) {
        if (pdsLocation == null) {
            throw new NullPointerException("pdsLocation must not be null!");
        }
        this.a.add(pdsLocation);
    }

    public PdsLocation[] getPdsLocations() {
        return this.a.toArray(new PdsLocation[0]);
    }

    public String getPdsUrl(String string) {
        String string2 = null;
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            PdsLocation pdsLocation = (PdsLocation)iterator.next();
            if (!pdsLocation.getLanguage().equals(string)) continue;
            string2 = pdsLocation.getUrl();
        }
        return string2;
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a.clear();
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType() + "). PdsLocations must be SEQUENCE OF!");
        }
        int n2 = aSN1Object.countComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            PdsLocation pdsLocation = new PdsLocation(aSN1Object.getComponentAt(i2));
            this.a.add(pdsLocation);
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            PdsLocation pdsLocation = (PdsLocation)iterator.next();
            sEQUENCE.addComponent(pdsLocation.toASN1Object());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public static final class PdsLocation
    implements ASN1Type {
        private IA5String a;
        private PrintableString b;

        public PdsLocation(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("url must not be null!");
            }
            if (string2 == null) {
                throw new NullPointerException("language code must not be null!");
            }
            if (string2.length() != 2) {
                throw new IllegalArgumentException("language code must not contain more than two characters!");
            }
            this.a = new IA5String(string);
            this.b = new PrintableString(string2);
        }

        public PdsLocation(ASN1Object aSN1Object) throws CodingException {
            this.decode(aSN1Object);
        }

        public String getUrl() {
            return (String)this.a.getValue();
        }

        public String getLanguage() {
            return (String)this.b.getValue();
        }

        public void decode(ASN1Object aSN1Object) throws CodingException {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType() + "). PdsLocation must be SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 != 2) {
                throw new CodingException("Invalid number of components (" + n2 + "). Expected 2!");
            }
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.IA5String)) {
                throw new CodingException("Invalid ASN.1 type (" + aSN1Object2.getAsnType() + "). url must be IA5String!");
            }
            this.a = (IA5String)aSN1Object2;
            aSN1Object2 = aSN1Object.getComponentAt(1);
            if (!aSN1Object2.isA(ASN.PrintableString)) {
                throw new CodingException("Invalid ASN.1 type (" + aSN1Object2.getAsnType() + "). language code must be PrintableString!");
            }
            this.b = (PrintableString)aSN1Object2;
        }

        public ASN1Object toASN1Object() {
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.a);
            sEQUENCE.addComponent(this.b);
            return sEQUENCE;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PDS ").append(this.getLanguage()).append(": ");
            stringBuffer.append(this.getUrl());
            return stringBuffer.toString();
        }
    }
}

