/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.apps.util.passphrase.NewPassphrasePrompt;
import iaik.apps.util.passphrase.PassphrasePrompt;
import iaik.apps.util.passphrase.Util;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationCanceledException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationException;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.SessionContainer;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class DefaultLoginManager
extends LoginManager {
    protected static String c = Constants.LINE_SEPARATOR;
    protected static Properties d;
    protected Properties e = new Properties(d);
    protected PassphrasePrompt f;
    protected NewPassphrasePrompt g;
    static Class h;
    static Class i;

    public DefaultLoginManager() {
        this(null);
    }

    public DefaultLoginManager(Properties properties) {
        this.addProperties(properties);
    }

    public PassphrasePrompt getPassphrasePrompt() {
        if (this.f == null) {
            String string = this.e.getProperty("DEFAULT_PROMPT_DIALOG", "iaik.apps.util.passphrase.PassphraseDialog");
            try {
                Class<?> clazz = Class.forName(string);
                this.f = (PassphrasePrompt)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace(IAIKPkcs11.errorStream_);
                string = "iaik.apps.util.passphrase.PassphraseConsoleDialog";
                try {
                    Class<?> clazz = Class.forName(string);
                    this.f = (PassphrasePrompt)clazz.newInstance();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace(IAIKPkcs11.errorStream_);
                }
            }
        }
        return this.f;
    }

    public void setPassphrasePrompt(PassphrasePrompt passphrasePrompt) {
        this.f = passphrasePrompt;
    }

    public NewPassphrasePrompt getPassphraseChangePrompt() {
        if (this.g == null) {
            String string = this.e.getProperty("DEFAULT_CHANGE_DIALOG", "iaik.apps.util.passphrase.NewPassphraseDialog");
            try {
                Class<?> clazz = Class.forName(string);
                this.g = (NewPassphrasePrompt)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace(IAIKPkcs11.errorStream_);
                string = "iaik.apps.util.passphrase.NewPassphraseConsoleDialog";
                try {
                    Class<?> clazz = Class.forName(string);
                    this.g = (NewPassphrasePrompt)clazz.newInstance();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace(IAIKPkcs11.errorStream_);
                }
            }
        }
        return this.g;
    }

    public void setPassphraseChangePrompt(NewPassphrasePrompt newPassphrasePrompt) {
        this.g = newPassphrasePrompt;
    }

    public int getNumberOfLoginRetries() {
        String string = this.e.getProperty("NUMBER_OF_USER_LOGIN_RETRIES", "3");
        int n = Integer.parseInt(string);
        n = Math.max(n, 1);
        return n;
    }

    public void setNumberOfLoginRetries(int n) {
        n = Math.max(n, 1);
        this.e.setProperty("NUMBER_OF_USER_LOGIN_RETRIES", String.valueOf(n));
    }

    public boolean isUseProtectedAuthenticationPath() {
        String string = this.e.getProperty("USE_PROTECTED_AUTHENTICATION_PATH", "true");
        return Boolean.valueOf(string);
    }

    public void setUseProtectedAuthenticationPath(boolean bl) {
        this.e.setProperty("USE_PROTECTED_AUTHENTICATION_PATH", String.valueOf(bl));
    }

    public boolean isForceProtectedAuthenticationPath() {
        String string = this.e.getProperty("FORCE_PROTECTED_AUTHENTICATION_PATH", "false");
        return Boolean.valueOf(string);
    }

    public void setForceProtectedAuthenticationPath(boolean bl) {
        this.e.setProperty("FORCE_PROTECTED_AUTHENTICATION_PATH", String.valueOf(bl));
    }

    public void loginUser(TokenManager tokenManager, Session session, char[] cArray) {
        this.login(tokenManager, session, false, cArray);
    }

    public void loginSO(TokenManager tokenManager, Session session, char[] cArray) {
        this.login(tokenManager, session, true, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(TokenManager tokenManager, Session session, boolean bl, char[] cArray) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        SessionContainer sessionContainer = new SessionContainer(tokenManager, session);
        session = sessionContainer.getSession();
        try {
            SessionInfo sessionInfo = session.getSessionInfo();
            State state = sessionInfo.getState();
            PKCS11Exception pKCS11Exception = null;
            if (bl || !state.equals((Object)State.RO_USER_FUNCTIONS) && !state.equals((Object)State.RW_USER_FUNCTIONS) || !bl || !state.equals((Object)State.RW_SO_FUNCTIONS)) {
                if (!state.equals((Object)State.RW_PUBLIC_SESSION) && !state.equals((Object)State.RO_PUBLIC_SESSION)) {
                    session.logout();
                }
                int n = this.getNumberOfLoginRetries();
                TokenInfo tokenInfo = session.getToken().getTokenInfo();
                if (this.a(tokenManager, session)) {
                    while (n-- > 0) {
                        try {
                            session.login(!bl, null);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception2) {
                            if (pKCS11Exception2.getErrorCode() == 160L) continue;
                            throw new IAIKPkcs11AuthenticationException("Failed to login: " + pKCS11Exception2.toString());
                        }
                    }
                } else {
                    if (cArray != null) {
                        try {
                            session.login(!bl, cArray);
                        }
                        catch (PKCS11Exception pKCS11Exception3) {
                            if (pKCS11Exception3.getErrorCode() == 160L) {
                                throw new IAIKPkcs11AuthenticationException("PIN Incorrect. Failed to login: " + pKCS11Exception3.toString());
                            }
                            throw pKCS11Exception3;
                        }
                    }
                    PassphrasePrompt passphrasePrompt = this.getPassphrasePrompt();
                    if (passphrasePrompt == null) {
                        throw new IAIKPkcs11AuthenticationException("Configured passphrase prompt (LoginManager properties) can't be created.");
                    }
                    passphrasePrompt.setCancelAllowed(true);
                    String string = this.e.getProperty("DEFAULT_PROMPT_MESSAGE_PREFIX", "Plaese enter " + (true == bl ? "SO" : "User") + "-PIN for this token") + c + c;
                    string = this.a(string, "$(ROLE)", bl ? "SO" : "User");
                    String string2 = Util.fixString(tokenInfo.getLabel());
                    string = this.a(string, "$(TOKEN_LABEL)", string2);
                    passphrasePrompt.setMessage(string);
                    passphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    while (n-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked() && !bl || tokenInfo.isSoPinLocked() && bl) {
                            throw new IAIKPkcs11AuthenticationException("Cannot login, the PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry() && !bl || tokenInfo.isSoPinFinalTry() && bl) {
                            object = this.e.getProperty("PIN_FINAL_TRY_WARNING", "Warning! The token reported that this will be the final try before the PIN gets blocked.") + c + string;
                            string2 = Util.fixString(tokenInfo.getLabel());
                            object = this.a((String)object, "$(TOKEN_LABEL)", string2);
                            passphrasePrompt.setMessage(object);
                        }
                        if ((object = passphrasePrompt.promptPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("PIN entry cancelled.");
                        }
                        try {
                            session.login(!bl, object);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception4) {
                            pKCS11Exception = pKCS11Exception4;
                            if (pKCS11Exception4.getErrorCode() == 160L) {
                                String string3 = this.e.getProperty("WRONG_PIN_WARNING", "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                string3 = this.a(string3, "$(TRIALS_LEFT)", String.valueOf(n));
                                String string4 = string3 + c + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                string4 = this.a(string4, "$(TOKEN_LABEL)", string2);
                                passphrasePrompt.setMessage(string4);
                                continue;
                            }
                            throw pKCS11Exception4;
                        }
                    }
                }
            }
            if (!((state = (sessionInfo = session.getSessionInfo()).getState()).equals((Object)State.RO_USER_FUNCTIONS) || state.equals((Object)State.RW_USER_FUNCTIONS) || state.equals((Object)State.RW_SO_FUNCTIONS))) {
                String string = pKCS11Exception != null ? "Failed to login: " + pKCS11Exception.toString() : "Failed to login.";
                throw new IAIKPkcs11AuthenticationException(string);
            }
        }
        finally {
            sessionContainer.disposeSessionIfDummy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPIN(TokenManager tokenManager, Session session, char[] cArray, char[] cArray2) {
        block49: {
            SessionContainer sessionContainer = new SessionContainer(tokenManager, session);
            session = sessionContainer.getSession();
            try {
                SessionInfo sessionInfo = session.getSessionInfo();
                State state = sessionInfo.getState();
                if (state.equals((Object)State.RW_SO_FUNCTIONS)) {
                    session.logout();
                }
                int n = this.getNumberOfLoginRetries();
                TokenInfo tokenInfo = session.getToken().getTokenInfo();
                if (this.a(tokenManager, session)) {
                    while (n-- > 0) {
                        try {
                            sessionInfo = session.getSessionInfo();
                            state = sessionInfo.getState();
                            if (!state.equals((Object)State.RO_USER_FUNCTIONS) && !state.equals((Object)State.RW_USER_FUNCTIONS)) {
                                session.login(true, null);
                            }
                            session.setPIN(null, null);
                            break block49;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            long l2 = pKCS11Exception.getErrorCode();
                            if (l2 == 160L || l2 == 161L || l2 == 162L) continue;
                            throw new IAIKPkcs11AuthenticationException(pKCS11Exception.toString());
                        }
                    }
                    break block49;
                }
                if (cArray != null && cArray2 != null) {
                    try {
                        sessionInfo = session.getSessionInfo();
                        state = sessionInfo.getState();
                        if (!state.equals((Object)State.RO_USER_FUNCTIONS) && !state.equals((Object)State.RW_USER_FUNCTIONS)) {
                            session.login(true, cArray);
                        }
                        session.setPIN(cArray, cArray2);
                        break block49;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        if (pKCS11Exception.getErrorCode() == 160L) {
                            throw new IAIKPkcs11AuthenticationException("Old PIN Incorrect. Failed to login the user: " + pKCS11Exception.toString());
                        }
                        throw pKCS11Exception;
                    }
                }
                if (cArray != null) {
                    NewPassphrasePrompt newPassphrasePrompt = this.getPassphraseChangePrompt();
                    if (newPassphrasePrompt == null) {
                        throw new IAIKPkcs11AuthenticationException("Configured passphrase prompt (LoginManager properties) can't be created.");
                    }
                    newPassphrasePrompt.setOldPassphraseRequired(false);
                    try {
                        sessionInfo = session.getSessionInfo();
                        state = sessionInfo.getState();
                        if (!state.equals((Object)State.RO_USER_FUNCTIONS) && !state.equals((Object)State.RW_USER_FUNCTIONS)) {
                            session.login(true, cArray);
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        long l3 = pKCS11Exception.getErrorCode();
                        if (l3 == 160L) {
                            throw new IAIKPkcs11AuthenticationException("The provided user PIN is invalid.");
                        }
                        throw pKCS11Exception;
                    }
                    String string = this.e.getProperty("DEFAULT_NEW_PROMPT_MESSAGE_PREFIX", "Please enter new User-PIN for this token") + c + c;
                    String string2 = Util.fixString(tokenInfo.getLabel());
                    string = this.a(string, "$(TOKEN_LABEL)", string2);
                    newPassphrasePrompt.setMessage(string);
                    newPassphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    while (n-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot set user PIN, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object = this.e.getProperty("PIN_FINAL_TRY_WARNING", "Warning! The token reported that this will be the final try before the PIN gets blocked.") + c + string;
                            string2 = Util.fixString(tokenInfo.getLabel());
                            object = this.a((String)object, "$(TOKEN_LABEL)", string2);
                            newPassphrasePrompt.setMessage(object);
                        }
                        if ((object = newPassphrasePrompt.promptNewPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled new PIN entry.");
                        }
                        try {
                            session.setPIN(cArray, object[1]);
                            break block49;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            String string3;
                            String string4;
                            long l4 = pKCS11Exception.getErrorCode();
                            if (l4 == 161L) {
                                string4 = this.e.getProperty("INVALID_NEW_PIN_WARNING", "The entered new PIN is invalid.");
                                string3 = string4 + c + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                string3 = this.a(string3, "$(TOKEN_LABEL)", string2);
                                newPassphrasePrompt.setMessage(string3);
                                continue;
                            }
                            if (l4 == 162L) {
                                string4 = this.e.getProperty("NEW_PIN_LENGTH_WARNING", "The length of the new PIN is invalid.");
                                string3 = string4 + c + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                string3 = this.a(string3, "$(TOKEN_LABEL)", string2);
                                newPassphrasePrompt.setMessage(string3);
                                continue;
                            }
                            throw pKCS11Exception;
                        }
                    }
                    break block49;
                }
                if (cArray2 != null) {
                    PassphrasePrompt passphrasePrompt = this.getPassphrasePrompt();
                    if (passphrasePrompt == null) {
                        throw new IAIKPkcs11AuthenticationException("Configured passphrase prompt (LoginManager properties) can't be created.");
                    }
                    String string = this.e.getProperty("DEFAULT_PROMPT_MESSAGE_PREFIX", "Plaese enter User-PIN for this token") + c + c;
                    String string5 = Util.fixString(tokenInfo.getLabel());
                    string = this.a(string, "$(TOKEN_LABEL)", string5);
                    passphrasePrompt.setMessage(string);
                    passphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    while (n-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot login user, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object = this.e.getProperty("PIN_FINAL_TRY_WARNING", "Warning! The token reported that this will be the final try before the PIN gets blocked.") + c + string;
                            string5 = Util.fixString(tokenInfo.getLabel());
                            object = this.a((String)object, "$(TOKEN_LABEL)", string5);
                            passphrasePrompt.setMessage(object);
                        }
                        if ((object = passphrasePrompt.promptPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled PIN entry.");
                        }
                        try {
                            sessionInfo = session.getSessionInfo();
                            state = sessionInfo.getState();
                            if (!state.equals((Object)State.RO_USER_FUNCTIONS) && !state.equals((Object)State.RW_USER_FUNCTIONS)) {
                                session.login(true, object);
                            }
                            session.setPIN(object, cArray2);
                            break block49;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            long l5 = pKCS11Exception.getErrorCode();
                            if (l5 == 160L) {
                                String string6 = this.e.getProperty("WRONG_PIN_WARNING", "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                string6 = this.a(string6, "$(TRIALS_LEFT)", String.valueOf(n));
                                String string7 = string6 + c + string;
                                string5 = Util.fixString(tokenInfo.getLabel());
                                string7 = this.a(string7, "$(TOKEN_LABEL)", string5);
                                passphrasePrompt.setMessage(string7);
                                continue;
                            }
                            throw pKCS11Exception;
                        }
                    }
                    break block49;
                }
                NewPassphrasePrompt newPassphrasePrompt = this.getPassphraseChangePrompt();
                newPassphrasePrompt.setOldPassphraseRequired(true);
                String string = this.e.getProperty("DEFAULT_NEW_PROMPT_MESSAGE_PREFIX", "Please enter new User-PIN for this token") + c + c;
                String string8 = Util.fixString(tokenInfo.getLabel());
                string = this.a(string, "$(TOKEN_LABEL)", string8);
                newPassphrasePrompt.setMessage(string);
                newPassphrasePrompt.setProtectedResourceInfo(tokenInfo);
                PKCS11Exception pKCS11Exception = null;
                while (n-- > 0) {
                    Object object;
                    tokenInfo = session.getToken().getTokenInfo();
                    if (tokenInfo.isUserPinLocked()) {
                        throw new IAIKPkcs11AuthenticationException("Cannot set user PIN, the user PIN is locked.");
                    }
                    if (tokenInfo.isUserPinFinalTry()) {
                        object = this.e.getProperty("PIN_FINAL_TRY_WARNING", "Warning! The token reported that this will be the final try before the PIN gets blocked.") + c + string;
                        string8 = Util.fixString(tokenInfo.getLabel());
                        object = this.a((String)object, "$(TOKEN_LABEL)", string8);
                        newPassphrasePrompt.setMessage(object);
                    }
                    if ((object = newPassphrasePrompt.promptNewPassphrase()) == null) {
                        throw new IAIKPkcs11AuthenticationCanceledException("User canceled new PIN entry.");
                    }
                    try {
                        sessionInfo = session.getSessionInfo();
                        state = sessionInfo.getState();
                        if (!state.equals((Object)State.RO_USER_FUNCTIONS) && !state.equals((Object)State.RW_USER_FUNCTIONS)) {
                            session.login(true, object[0]);
                            pKCS11Exception = null;
                        }
                        session.setPIN(object[0], object[1]);
                        break;
                    }
                    catch (PKCS11Exception pKCS11Exception2) {
                        String string9;
                        String string10;
                        long l6 = pKCS11Exception2.getErrorCode();
                        if (l6 == 160L) {
                            pKCS11Exception = pKCS11Exception2;
                            if (cArray != null) break;
                            string10 = this.e.getProperty("WRONG_PIN_WARNING", "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                            string10 = this.a(string10, "$(TRIALS_LEFT)", String.valueOf(n));
                            string9 = string10 + c + string;
                            string8 = Util.fixString(tokenInfo.getLabel());
                            string9 = this.a(string9, "$(TOKEN_LABEL)", string8);
                            newPassphrasePrompt.setMessage(string9);
                            continue;
                        }
                        if (l6 == 161L) {
                            string10 = this.e.getProperty("INVALID_NEW_PIN_WARNING", "The entered new PIN is invalid.");
                            string9 = string10 + c + string;
                            string8 = Util.fixString(tokenInfo.getLabel());
                            string9 = this.a(string9, "$(TOKEN_LABEL)", string8);
                            newPassphrasePrompt.setMessage(string9);
                            continue;
                        }
                        if (l6 == 162L) {
                            string10 = this.e.getProperty("NEW_PIN_LENGTH_WARNING", "The length of the new PIN is invalid.");
                            string9 = string10 + c + string;
                            string8 = Util.fixString(tokenInfo.getLabel());
                            string9 = this.a(string9, "$(TOKEN_LABEL)", string8);
                            newPassphrasePrompt.setMessage(string9);
                            continue;
                        }
                        throw pKCS11Exception2;
                    }
                }
                if (pKCS11Exception != null) {
                    throw new IAIKPkcs11AuthenticationException("The provided user PIN is invalid.");
                }
            }
            finally {
                sessionContainer.disposeSessionIfDummy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(TokenManager tokenManager, Session session) {
        SessionContainer sessionContainer = new SessionContainer(tokenManager, session);
        session = sessionContainer.getSession();
        try {
            session.logout();
        }
        finally {
            sessionContainer.disposeSessionIfDummy();
        }
    }

    protected boolean a(TokenManager tokenManager, Session session) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        return this.isForceProtectedAuthenticationPath() || this.isUseProtectedAuthenticationPath() && tokenManager.getToken().getTokenInfo().isProtectedAuthenticationPath();
    }

    protected String a(String string, String string2, String string3) {
        String string4 = string;
        int n = 0;
        while ((n = string4.indexOf(string2, n)) >= 0) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
        }
        return string4;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            URL uRL = (h == null ? (h = DefaultLoginManager.a("iaik.pkcs.pkcs11.provider.DefaultLoginManager")) : h).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/DefaultLoginManager.properties");
            InputStream inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            URL uRL2 = (i == null ? (i = DefaultLoginManager.a("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : i).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/DefaultLoginManager.properties");
            if (uRL2 != null) {
                InputStream inputStream2 = uRL2.openStream();
                Properties properties2 = new Properties(properties);
                properties2.load(inputStream2);
                inputStream2.close();
                d = properties2;
            } else {
                d = properties;
            }
        }
        catch (IOException iOException) {
            IAIKPkcs11.errorStream_.println("Could not load DefaultLoginManager configuration properties.");
            iOException.printStackTrace(IAIKPkcs11.errorStream_);
            d = null;
        }
    }
}

