/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class PKCS11Cipher
extends CipherSpi
implements PKCS11EngineClass {
    protected static final byte[] i = new byte[]{0};
    protected Session j;
    protected TokenManager k;
    protected IAIKPKCS11Key l;
    protected iaik.pkcs.pkcs11.objects.Key m;
    protected int n;
    protected Mechanism o = this.d();
    protected boolean p;
    protected boolean q;
    protected boolean r;
    protected boolean s;
    protected Cipher t;
    protected String u;
    protected String v;
    protected AlgorithmParameters w;
    protected boolean x;
    protected boolean y;
    protected Mechanism[] z;
    protected MechanismInfo[][] A;
    protected iaik.pkcs.pkcs11.objects.Key B;
    protected PKCS11Spec C;

    protected PKCS11Cipher() {
    }

    protected Mechanism[] a() {
        if (this.z == null) {
            Mechanism mechanism = (Mechanism)this.k().clone();
            mechanism.setParameters(null);
            this.z = new Mechanism[]{mechanism};
        }
        return this.z;
    }

    protected MechanismInfo[][] f() {
        if (this.A == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            MechanismInfo mechanismInfo3 = new MechanismInfo();
            mechanismInfo3.setWrap(true);
            MechanismInfo mechanismInfo4 = new MechanismInfo();
            mechanismInfo4.setUnwrap(true);
            this.A = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4}};
        }
        return this.A;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.a();
            MechanismInfo[][] mechanismInfoArray = this.f();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected abstract void a(iaik.pkcs.pkcs11.objects.Key var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.s) return this.a(byArray, n, n2, byArray2, n3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.doFinal(byArray, n, n2, byArray2, n3);
    }

    protected int a(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3;
        if (!this.p || this.l == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (!this.q) {
            try {
                this.p();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if ((byArray3 = this.a(byArray, n, n2)) != null && byArray2 != null) {
            if (byArray2.length - n3 < byArray3.length) {
                throw new ShortBufferException("Output is " + byArray3.length + "bytes long." + "The given buffer has only place for " + (byArray2.length - n3) + "bytes.");
            }
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        }
        if (null != byArray3) {
            return byArray3.length;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) {
        if (!this.s) return this.a(byArray, n, n2);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        if (byArray == null) return this.t.doFinal();
        return this.t.doFinal(byArray, n, n2);
    }

    protected byte[] a(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        if (!this.p || this.l == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray != null && n + n2 > byArray.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.q) {
            try {
                this.p();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (!this.r && byArray != null) {
            byte[] byArray3 = null;
            if (n == 0 && n2 == byArray.length) {
                byArray3 = byArray;
            } else {
                byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, n2);
            }
            try {
                if (this.n == 1) {
                    byArray2 = this.j.encrypt(byArray3);
                } else if (this.n == 2) {
                    byArray2 = this.j.decrypt(byArray3);
                } else {
                    throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
                }
                this.q = false;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error calculating cipher: " + (Object)((Object)tokenException));
            }
            finally {
                this.q();
            }
        }
        try {
            if (byArray != null) {
                this.b(byArray, n, n2);
            }
            if (this.n == 1) {
                byArray2 = this.j.encryptFinal();
            } else if (this.n == 2) {
                byArray2 = this.j.decryptFinal();
            } else {
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            this.q = false;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Error finalizing cipher: " + (Object)((Object)tokenException));
        }
        finally {
            this.q();
        }
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetBlockSize() {
        if (!this.s) return this.e();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.getBlockSize();
    }

    protected int e() {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineGetIV() {
        if (!this.s) return this.h();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.getIV();
    }

    protected byte[] h() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetKeySize(Key key) {
        if (key instanceof IAIKPKCS11Key) {
            return this.a(key);
        }
        if (!(key instanceof javax.crypto.SecretKey)) throw new InvalidKeyException("Cannot determine size of software key.");
        byte[] byArray = key.getEncoded();
        if (byArray == null) throw new InvalidKeyException("Cannot determine size of software secret key. Key encoding is null.");
        return byArray.length << 3;
    }

    protected int a(Key key) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetOutputSize(int n) {
        if (!this.s) return this.a(n);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.getOutputSize(n);
    }

    protected int a(int n) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AlgorithmParameters engineGetParameters() {
        if (!this.s) return this.g();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.getParameters();
    }

    protected AlgorithmParameters g() {
        return this.w;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleCipherKey(this.b(), n, key);
        if (key instanceof IAIKPKCS11Key) {
            this.a(n, key, secureRandom);
            this.s = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.t == null) {
                this.m();
            }
            this.t.init(n, key, secureRandom);
            this.s = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void a(int n, Key key, SecureRandom secureRandom) {
        try {
            this.a(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IAIKPkcs11Exception(invalidAlgorithmParameterException.toString());
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleCipherKey(this.b(), n, key);
        if (key instanceof IAIKPKCS11Key) {
            this.a(n, key, algorithmParameters, secureRandom);
            this.s = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.t == null) {
                this.m();
            }
            this.t.init(n, key, algorithmParameters, secureRandom);
            this.s = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void a(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) {
        this.a(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleCipherKey(this.b(), n, key);
        if (key instanceof IAIKPKCS11Key) {
            this.a(n, key, algorithmParameterSpec, secureRandom);
            this.s = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            this.s = true;
            if (this.t == null) {
                this.m();
            }
            this.t.init(n, key, algorithmParameterSpec, secureRandom);
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void a(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (n != 1 && n != 2 && n != 4 && n != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n);
        }
        this.o = this.k();
        if (this.o == null) {
            throw new IAIKPkcs11Exception("This cipher object has not been initialized corretly.");
        }
        this.n = n;
        this.l = (IAIKPKCS11Key)key;
        iaik.pkcs.pkcs11.objects.Key key2 = this.l.getKeyObject();
        this.a(key2);
        this.m = key2;
        this.r();
    }

    protected void m() {
        DelegateProvider delegateProvider = this.s();
        String string = this.n();
        this.t = delegateProvider.getCipher(string);
        if (this.t == null) {
            throw new IAIKPkcs11Exception("Could not get delegate cipher engine for " + string);
        }
    }

    protected abstract String b();

    protected String n() {
        String string;
        String string2 = this.b();
        if (this.u != null && this.v != null) {
            StringBuffer stringBuffer = new StringBuffer(string2.length() + this.u.length() + this.v.length() + 2);
            stringBuffer.append(string2);
            stringBuffer.append('/');
            stringBuffer.append(this.u);
            stringBuffer.append('/');
            stringBuffer.append(this.v);
            string = stringBuffer.toString();
        } else {
            string = string2;
        }
        return string;
    }

    protected void o() {
        try {
            this.k = this.l.getTokenManager();
            if (this.j == null) {
                this.j = this.k.getSession(this.n == 4);
            }
            this.k.makeAuthorizedSession(this.j, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void p() {
        block7: {
            this.o();
            try {
                if (this.n == 2) {
                    this.j.decryptInit(this.o, this.l.getKeyObject());
                    break block7;
                }
                if (this.n == 1) {
                    this.j.encryptInit(this.o, this.l.getKeyObject());
                    break block7;
                }
                if (this.n == 4) {
                    if (this.C != null && this.C.isUseUserRole()) {
                        this.k.loginUser(this.C.getPin());
                    }
                    break block7;
                }
                if (this.n != 3) {
                    // empty if block
                }
            }
            catch (TokenException tokenException) {
                throw new InvalidKeyException("Error initializing the PKCS#11 cipher: " + tokenException.toString());
            }
        }
        this.r = false;
        this.q = true;
    }

    protected void q() {
        if (this.q) {
            this.q = false;
            this.k.closeSession(this.j);
            this.j = null;
        } else {
            this.q = false;
            this.k.disposeSession(this.j);
            this.j = null;
        }
    }

    protected void r() {
        this.p();
        this.p = true;
    }

    protected void engineSetMode(String string) {
        if (!this.a(string)) {
            throw new NoSuchAlgorithmException("Mode not supported: " + string);
        }
        this.u = string;
        this.x = true;
    }

    protected abstract boolean a(String var1);

    protected void engineSetPadding(String string) {
        if (this.b(string)) {
            this.v = string;
            this.y = true;
            if (this.k() == null) {
                throw new NoSuchPaddingException("Padding not supported with this mode: " + this.u + "/" + string);
            }
        } else {
            throw new NoSuchPaddingException("Padding not supported: " + string);
        }
    }

    protected abstract boolean b(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (!this.s) return this.b(byArray, n, n2);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.update(byArray, n, n2);
    }

    protected byte[] b(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        block13: {
            if (!this.p || this.l == null) {
                throw new IllegalStateException("Cipher not initialized.");
            }
            if (!this.q) {
                try {
                    this.p();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.q();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    this.q();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
                }
            }
            if (byArray == null) {
                throw new NullPointerException("Argument \"data\" must not be null.");
            }
            if (n + n2 > byArray.length) {
                throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
            }
            byte[] byArray3 = null;
            if (n == 0 && n2 == byArray.length) {
                byArray3 = byArray;
            } else {
                byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, n2);
            }
            try {
                if (this.n == 1) {
                    byArray2 = this.j.encryptUpdate(byArray3);
                    break block13;
                }
                if (this.n == 2) {
                    byArray2 = this.j.decryptUpdate(byArray3);
                    break block13;
                }
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            catch (TokenException tokenException) {
                this.q();
                throw new IAIKPkcs11Exception("Error updating cipher: " + (Object)((Object)tokenException));
            }
        }
        this.r = true;
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.s) return this.b(byArray, n, n2, byArray2, n3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.update(byArray, n, n2, byArray2, n3);
    }

    protected int b(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.p || this.l == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        byte[] byArray3 = this.b(byArray, n, n2);
        if (byArray3 != null && byArray2 != null) {
            if (byArray2.length - n3 < byArray3.length) {
                throw new ShortBufferException("Output is " + byArray3.length + "bytes long." + "The given buffer has only place for " + (byArray2.length - n3) + "bytes.");
            }
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        }
        this.r = true;
        if (null != byArray3) {
            return byArray3.length;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Key engineUnwrap(byte[] byArray, String string, int n) {
        if (!this.s) return this.a(byArray, string, n);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.unwrap(byArray, string, n);
    }

    protected Key a(byte[] byArray, String string, int n) {
        Object object;
        LongAttribute longAttribute;
        iaik.pkcs.pkcs11.objects.Key key;
        if (!this.p || this.l == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"wrappedKey\" must not be null.");
        }
        if (this.n != 4) {
            throw new UnsupportedOperationException("Method only supported in state unwrap.");
        }
        if (!this.q) {
            try {
                this.p();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.q();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.q();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        IAIKPKCS11Key iAIKPKCS11Key = null;
        if (null == this.B) {
            switch (n) {
                case 3: {
                    key = new GenericTemplate();
                    longAttribute = new LongAttribute(Attribute.CLASS);
                    longAttribute.setLongValue(Object.ObjectClass.SECRET_KEY);
                    ((GenericTemplate)key).addAttribute((Attribute)longAttribute);
                    break;
                }
                case 2: {
                    key = new GenericTemplate();
                    longAttribute = new LongAttribute(Attribute.CLASS);
                    longAttribute.setLongValue(Object.ObjectClass.PRIVATE_KEY);
                    ((GenericTemplate)key).addAttribute((Attribute)longAttribute);
                    break;
                }
                case 1: {
                    key = new GenericTemplate();
                    longAttribute = new LongAttribute(Attribute.CLASS);
                    longAttribute.setLongValue(Object.ObjectClass.PUBLIC_KEY);
                    ((GenericTemplate)key).addAttribute((Attribute)longAttribute);
                    break;
                }
                default: {
                    key = null;
                }
            }
            if (key != null) {
                object = IAIKPKCS11Key.getAlgorithmCode(string);
                LongAttribute longAttribute2 = new LongAttribute(Attribute.KEY_TYPE);
                longAttribute2.setLongValue((Long)object);
                ((GenericTemplate)key).addAttribute((Attribute)longAttribute2);
            }
        } else {
            key = this.B;
        }
        longAttribute = null;
        try {
            if (key != null && string.equalsIgnoreCase("TlsRsaPremasterSecret")) {
                this.j.decryptInit(this.o, this.l.getKeyObject());
                object = this.j.decrypt(byArray);
                return new SecretKeySpec((byte[])object, string);
            }
            longAttribute = this.j.unwrapKey(this.o, this.l.getKeyObject(), byArray, (iaik.pkcs.pkcs11.objects.Object)key);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.q();
            if (pKCS11Exception.getErrorCode() == 112L) {
                throw new NoSuchAlgorithmException("Token does not support this algorithm: " + (Object)((Object)pKCS11Exception));
            }
            if (pKCS11Exception.getErrorCode() == 272L) {
                throw new InvalidKeyException("Token does not support the algorithm of the wrapped key: " + (Object)((Object)pKCS11Exception));
            }
            throw new IAIKPkcs11Exception("Error unwrapping key: " + (Object)((Object)pKCS11Exception));
        }
        catch (TokenException tokenException) {
            this.q();
            throw new IAIKPkcs11Exception("Error unwrapping key: " + (Object)((Object)tokenException));
        }
        if (longAttribute instanceof PrivateKey) {
            iAIKPKCS11Key = IAIKPKCS11Key.create(this.k, (iaik.pkcs.pkcs11.objects.Key)longAttribute);
        } else if (longAttribute instanceof PublicKey) {
            iAIKPKCS11Key = IAIKPKCS11PublicKey.create(this.k, (PublicKey)longAttribute);
        } else if (longAttribute instanceof SecretKey) {
            iAIKPKCS11Key = IAIKPKCS11SecretKey.create(this.k, (SecretKey)longAttribute);
        } else {
            this.q();
            throw new InvalidKeyException("This type of PKCS#11 key cannot be handled: " + longAttribute);
        }
        if (!longAttribute.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.j);
            this.q = false;
        }
        this.q();
        this.k.notifyKeyStores();
        return iAIKPKCS11Key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineWrap(Key key) {
        if (!this.s) return this.b(key);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.t.wrap(key);
    }

    protected byte[] b(Key key) {
        byte[] byArray;
        block13: {
            if (!this.p || this.l == null) {
                throw new IllegalStateException("Cipher not initialized.");
            }
            if (key == null) {
                throw new NullPointerException("Argument \"key\" must not be null.");
            }
            if (!(key instanceof IAIKPKCS11Key)) {
                throw new InvalidKeyException("Argument key must be of instance iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key.");
            }
            if (!this.q) {
                try {
                    this.p();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.q();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    this.q();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
                }
            }
            iaik.pkcs.pkcs11.objects.Key key2 = ((IAIKPKCS11Key)key).getKeyObject();
            try {
                if (this.n == 3) {
                    byArray = this.j.wrapKey(this.o, this.l.getKeyObject(), key2);
                    break block13;
                }
                throw new UnsupportedOperationException("Method only supported in state wrap.");
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error wrapping key: " + (Object)((Object)tokenException));
            }
            finally {
                this.q();
            }
        }
        return byArray;
    }

    protected abstract Mechanism d();

    protected abstract Mechanism k();

    protected void finalize() {
        if (this.j != null) {
            this.q();
        }
        super.finalize();
    }

    DelegateProvider s() {
        if (this.k != null) {
            return this.k.getProvider().getDelegateProvider();
        }
        return IAIKPkcs11.getGlobalDelegateProvider();
    }
}

