/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsOaepParameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11OAEPParameterSpec;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11UnwrapKeySpec;
import iaik.pkcs.pkcs11.provider.hashes.PKCS11Hash;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class RsaCipher
extends PKCS11Cipher {
    protected static final Mechanism a = Mechanism.get((long)1L);
    private static final String[] D = new String[]{"none", "ecb"};
    private static final String[] E = new String[]{"nopadding", "pkcs1padding", "oaeppadding", "oaep", "oaepwith", "iso9796padding", "iso9796", "rawx509"};
    private static final Long[] F = new Long[]{new Long(3L), new Long(1L), new Long(9L), new Long(9L), new Long(9L), new Long(2L), new Long(2L), new Long(3L)};
    private static HashMap G = new HashMap();
    protected static Vector b;
    protected static Vector c;
    protected static Hashtable d;
    protected Hashtable e;
    protected int f;
    protected ByteArrayOutputStream g;
    private HashMap H;
    static Class h;

    public RsaCipher() {
        this.u = this.c();
        this.v = this.i();
        this.g = new ByteArrayOutputStream(128);
        this.H = null;
    }

    protected Mechanism[] a() {
        if (this.z == null) {
            HashSet<Long> hashSet = new HashSet<Long>();
            hashSet.addAll(Arrays.asList(F));
            this.z = new Mechanism[hashSet.size()];
            int n = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Long l2 = (Long)iterator.next();
                this.z[n++] = Mechanism.get((long)l2);
            }
        }
        return this.z;
    }

    protected MechanismInfo[][] f() {
        if (this.A == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            MechanismInfo mechanismInfo3 = new MechanismInfo();
            mechanismInfo3.setSign(true);
            MechanismInfo mechanismInfo4 = new MechanismInfo();
            mechanismInfo4.setVerifyRecover(true);
            MechanismInfo mechanismInfo5 = new MechanismInfo();
            mechanismInfo5.setWrap(true);
            MechanismInfo mechanismInfo6 = new MechanismInfo();
            mechanismInfo6.setUnwrap(true);
            this.A = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4, mechanismInfo5, mechanismInfo6}, {mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4, mechanismInfo5, mechanismInfo6}, {mechanismInfo, mechanismInfo2, mechanismInfo5, mechanismInfo6}, {mechanismInfo3, mechanismInfo4}};
        }
        return this.A;
    }

    protected int engineGetKeySize(Key key) {
        int n;
        if (key instanceof IAIKPKCS11Key) {
            n = this.a(key);
        } else if (key instanceof java.security.interfaces.RSAPrivateKey) {
            n = ((java.security.interfaces.RSAPrivateKey)key).getModulus().bitLength();
        } else if (key instanceof java.security.interfaces.RSAPublicKey) {
            n = ((java.security.interfaces.RSAPublicKey)key).getModulus().bitLength();
        } else {
            throw new UnsupportedOperationException("Cannot determine size of software key. Key is not a RSA key. Key is of class: " + (key != null ? key.getClass().toString() : "null"));
        }
        return n;
    }

    protected void a(iaik.pkcs.pkcs11.objects.Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11Key must be of type RSA");
        }
    }

    protected void a(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        this.s = false;
        if (n != 1 && n != 2 && n != 4 && n != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n);
        }
        this.n = n;
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PKCS11UnwrapKeySpec) && !(algorithmParameterSpec instanceof PKCS11OAEPParameterSpec)) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported: " + algorithmParameterSpec);
        }
        if (algorithmParameterSpec instanceof PKCS11UnwrapKeySpec) {
            this.C = (PKCS11Spec)((Object)algorithmParameterSpec);
            this.B = ((PKCS11UnwrapKeySpec)algorithmParameterSpec).getKeyTemplate();
        } else if (algorithmParameterSpec instanceof PKCS11OAEPParameterSpec) {
            if (!this.v.toLowerCase().contains("oaep")) {
                throw new InvalidAlgorithmParameterException("OAEP parameters not allowed for non-oaep padding.");
            }
            this.C = (PKCS11Spec)((Object)algorithmParameterSpec);
            this.y = true;
        }
        this.l = (IAIKPKCS11Key)key;
        this.m = this.l.getKeyObject();
        this.a(this.m);
        this.o = this.k();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof PKCS11OAEPParameterSpec) {
            RSAPkcsOaepParameters rSAPkcsOaepParameters = (RSAPkcsOaepParameters)this.o.getParameters();
            PKCS11OAEPParameterSpec pKCS11OAEPParameterSpec = (PKCS11OAEPParameterSpec)algorithmParameterSpec;
            if (rSAPkcsOaepParameters.getHashAlgorithm().getMechanismCode() != pKCS11OAEPParameterSpec.getHashAlgorithm().getMechanismCode()) {
                throw new InvalidAlgorithmParameterException("OAEP parameters differ from given oaep padding.");
            }
        }
        if (this.o == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.u + "/" + this.v);
        }
        this.r();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void p() {
        block9: {
            this.o();
            try {
                iaik.pkcs.pkcs11.objects.Key key = this.l.getKeyObject();
                if (this.n == 2) {
                    if (key instanceof PublicKey) {
                        this.j.verifyRecoverInit(this.o, key);
                        this.f = 1;
                        break block9;
                    } else {
                        this.j.decryptInit(this.o, this.l.getKeyObject());
                        this.f = 2;
                    }
                    break block9;
                }
                if (this.n == 1) {
                    if (key instanceof PrivateKey) {
                        this.j.signInit(this.o, key);
                        this.f = 1;
                        break block9;
                    } else {
                        this.j.encryptInit(this.o, key);
                        this.f = 2;
                    }
                    break block9;
                }
                if (this.n != 4 && this.n != 3) {
                    // empty if block
                }
            }
            catch (TokenException tokenException) {
                throw new InvalidKeyException("Error initializing the PKCS#11 RSA cipher: " + tokenException.toString());
            }
        }
        this.r = false;
        this.q = true;
    }

    protected byte[] b(byte[] byArray, int n, int n2) {
        if (!this.p || this.l == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n + n2 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.q) {
            try {
                this.p();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.q();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.q();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        this.g.write(byArray, n, n2);
        byte[] byArray2 = null;
        return byArray2;
    }

    protected byte[] a(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        if (!this.p || this.l == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray != null && n + n2 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.q) {
            try {
                this.p();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.q();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.q();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (byArray != null) {
            this.g.write(byArray, n, n2);
        }
        byte[] byArray3 = this.g.toByteArray();
        this.g.reset();
        try {
            if (this.n == 1) {
                byArray2 = this.f == 1 ? this.j.sign(byArray3) : this.j.encrypt(byArray3);
            } else if (this.n == 2) {
                byArray2 = this.f == 1 ? this.j.verifyRecover(byArray3) : this.j.decrypt(byArray3);
            } else {
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            this.q = false;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Error finishing cipher operation: " + (Object)((Object)tokenException));
        }
        finally {
            this.q();
        }
        return byArray2;
    }

    protected String b() {
        return "RSA";
    }

    protected int a(int n) {
        int n2 = -1;
        if (this.p) {
            try {
                n2 = this.a(this.l) + 7 >> 3;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception(invalidKeyException.toString());
            }
        } else {
            throw new IAIKPkcs11Exception("Cipher object not initialized.");
        }
        return n2;
    }

    protected int a(Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n = -1;
        if (key instanceof IAIKPKCS11PrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)((IAIKPKCS11PrivateKey)key).getKeyObject();
            n = rSAPrivateKey.getModulus().getByteArrayValue().length << 3;
        } else if (key instanceof IAIKPKCS11PublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)((IAIKPKCS11PublicKey)key).getKeyObject();
            n = rSAPublicKey.getModulusBits().getLongValue().intValue();
        } else if (key instanceof java.security.interfaces.RSAPrivateKey) {
            n = ((java.security.interfaces.RSAPrivateKey)key).getModulus().bitLength();
        } else if (key instanceof java.security.interfaces.RSAPublicKey) {
            n = ((java.security.interfaces.RSAPublicKey)key).getModulus().bitLength();
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11PrivateKey or an IAIKPKCS11PublicKey but it is : " + key.toString());
        }
        return n;
    }

    protected int e() {
        return this.a(1);
    }

    protected Mechanism d() {
        return a;
    }

    protected String c() {
        return "ECB";
    }

    protected String i() {
        return "PKCS1Padding";
    }

    protected Mechanism k() {
        if (this.x || this.y) {
            try {
                this.o = this.j();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.o = null;
            }
            this.x = false;
            this.y = false;
        }
        return this.o;
    }

    private HashMap t() {
        if (this.H == null) {
            try {
                Vector vector;
                Object object;
                Object object2;
                String string;
                Object object3;
                Object object4;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                HashMap<Object, Vector> hashMap2 = new HashMap<Object, Vector>();
                URL uRL = (h == null ? (h = RsaCipher.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : h).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11Algorithm.properties");
                InputStream inputStream = uRL.openStream();
                Properties properties = new Properties();
                properties.load(inputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    int n;
                    object4 = (String)enumeration.nextElement();
                    if (!(object4 instanceof String) || (n = ((String)(object3 = object4)).indexOf("MessageDigest")) <= -1 || (string = ((String)object3).substring(n + 14)).indexOf(".") != -1) continue;
                    string = string.toLowerCase();
                    object2 = properties.getProperty((String)object4);
                    try {
                        object = Class.forName((String)object2);
                        vector = (PKCS11Hash)((Class)object).newInstance();
                        Mechanism mechanism = ((PKCS11Hash)((Object)vector)).getUsedMechanism();
                        hashMap.put(string, mechanism);
                    }
                    catch (Exception exception) {
                        object2 = ((String)object2).toLowerCase();
                        if (hashMap2.containsKey(object2)) {
                            vector = (Vector)hashMap2.get(object2);
                        } else {
                            vector = new Vector();
                            hashMap2.put(object2, vector);
                        }
                        vector.add(string);
                    }
                }
                object4 = hashMap2.keySet();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    String string2 = (String)object3.next();
                    if (!hashMap.containsKey(string2)) continue;
                    string = (Mechanism)hashMap.get(string2);
                    object2 = (Vector)hashMap2.get(string2);
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        vector = (String)object.next();
                        hashMap.put((String)((Object)vector), string);
                    }
                }
                return hashMap;
            }
            catch (Exception exception) {
                return G;
            }
        }
        return this.H;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Mechanism j() {
        long l2;
        long l3;
        Mechanism mechanism;
        Object object;
        String string;
        String string2;
        Mechanism mechanism2 = null;
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.u);
        stringBuffer.append('/');
        stringBuffer.append(this.v);
        String string3 = stringBuffer.toString().toLowerCase();
        this.e = this.l();
        if (!this.e.containsKey(string3)) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string3);
        mechanism2 = (Mechanism)this.e.get(string3);
        if (mechanism2 == null) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string3);
        if (!(mechanism2 = (Mechanism)mechanism2.clone()).equals((Object)Mechanism.get((long)9L))) return mechanism2;
        PKCS11OAEPParameterSpec pKCS11OAEPParameterSpec = null;
        if (this.C != null && this.C instanceof PKCS11OAEPParameterSpec) {
            pKCS11OAEPParameterSpec = (PKCS11OAEPParameterSpec)this.C;
        }
        if ((string2 = this.v.toLowerCase()).startsWith(string = "oaepwith")) {
            String string4 = string2.substring(string.length());
            int n = string4.indexOf("andmgf1padding");
            if (!string4.endsWith("andmgf1padding") || n == -1) {
                throw new NoSuchAlgorithmException("Unknown message generation function (MGF) in requested padding: " + string3);
            }
            string4 = string4.substring(0, n);
            AlgorithmID.getAlgorithmID((String)string4.toLowerCase());
            HashMap hashMap = this.t();
            Set set = hashMap.keySet();
            object = set.iterator();
            mechanism = null;
            boolean bl = false;
            while (object.hasNext() && !bl) {
                String string5 = (String)object.next();
                if (!string4.equalsIgnoreCase(string5)) continue;
                mechanism = (Mechanism)((Mechanism)hashMap.get(string5)).clone();
                bl = true;
            }
            if (mechanism == null) {
                throw new NoSuchAlgorithmException("Requested hash algorithm for padding not supported: " + string3);
            }
        } else {
            mechanism = pKCS11OAEPParameterSpec != null ? pKCS11OAEPParameterSpec.getHashAlgorithm() : Mechanism.get((long)544L);
        }
        if (pKCS11OAEPParameterSpec != null) {
            l3 = pKCS11OAEPParameterSpec.getMgfHashAlgorithm();
            l2 = pKCS11OAEPParameterSpec.getOaepSourceType();
            object = pKCS11OAEPParameterSpec.getOaepSourceData();
        } else {
            l3 = mechanism.getMechanismCode() == 544L ? 1L : (mechanism.getMechanismCode() == 592L ? 2L : (mechanism.getMechanismCode() == 608L ? 3L : (mechanism.getMechanismCode() == 624L ? 4L : 1L)));
            l2 = 1L;
            object = null;
        }
        RSAPkcsOaepParameters rSAPkcsOaepParameters = new RSAPkcsOaepParameters(mechanism, l3, l2, (byte[])object);
        mechanism2.setParameters((Parameters)rSAPkcsOaepParameters);
        return mechanism2;
    }

    protected Hashtable l() {
        if (d == null) {
            HashMap hashMap = this.t();
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(D.length * (E.length + hashMap.size()));
            hashtable.put("ssl/pkcs1padding", Mechanism.get((long)1L));
            for (int i2 = 0; i2 < E.length; ++i2) {
                String string = E[i2];
                if (string.equals("oaepwith")) {
                    Set set = hashMap.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        String string3 = string + string2 + "andmgf1padding";
                        for (int i3 = 0; i3 < D.length; ++i3) {
                            hashtable.put(D[i3] + "/" + string3, Mechanism.get((long)F[i2]));
                        }
                    }
                    continue;
                }
                for (int i4 = 0; i4 < D.length; ++i4) {
                    hashtable.put(D[i4] + "/" + string, Mechanism.get((long)F[i2]));
                }
            }
            d = hashtable;
        }
        return d;
    }

    protected boolean a(String string) {
        boolean bl = false;
        if (string != null) {
            if (b == null) {
                Vector<String> vector = new Vector<String>(1);
                vector.add("ecb");
                vector.add("none");
                vector.add("ssl");
                b = vector;
            }
            bl = b.contains(string.toLowerCase());
        }
        return bl;
    }

    protected void engineSetMode(String string) {
        if (string.toUpperCase(Locale.US).equalsIgnoreCase("SSL")) {
            string = this.c();
        }
        if (!this.a(string)) {
            throw new NoSuchAlgorithmException("Mode not supported: " + string);
        }
        this.u = string;
        this.x = true;
    }

    protected boolean b(String string) {
        boolean bl = false;
        if (string != null) {
            if (c == null) {
                HashMap hashMap = this.t();
                Vector<String> vector = new Vector<String>(15);
                for (int i2 = 0; i2 < E.length; ++i2) {
                    String string2 = E[i2];
                    if (string2.equals("oaepwith")) {
                        Set set = hashMap.keySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            String string4 = string2 + string3 + "andmgf1padding";
                            vector.add(string4);
                        }
                        continue;
                    }
                    vector.add(string2);
                }
                c = vector;
            }
            bl = c.contains(string.toLowerCase());
        }
        return bl;
    }

    static Class c(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        G.put("SHA-1", Mechanism.get((long)544L));
        G.put("SHA", Mechanism.get((long)544L));
        G.put("SHA1", Mechanism.get((long)544L));
        G.put("SHA-256", Mechanism.get((long)592L));
        G.put("SHA256", Mechanism.get((long)592L));
        G.put("SHA-384", Mechanism.get((long)608L));
        G.put("SHA384", Mechanism.get((long)608L));
        G.put("SHA-512", Mechanism.get((long)624L));
        G.put("SHA512", Mechanism.get((long)624L));
        G.put("MD2", Mechanism.get((long)512L));
        G.put("MD5", Mechanism.get((long)528L));
        G.put("RipeMd128", Mechanism.get((long)560L));
        G.put("RipeMd-128", Mechanism.get((long)560L));
        G.put("RipeMd160", Mechanism.get((long)576L));
        G.put("RipeMd-160", Mechanism.get((long)576L));
        G.put("FastHash", Mechanism.get((long)4208L));
    }
}

