/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keygenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyGenerationSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;

public abstract class PKCS11KeyGenerator
extends KeyGeneratorSpi
implements PKCS11EngineClass {
    protected TokenManager b;
    protected Session c;
    protected PKCS11KeyGenerationSpec d;
    protected boolean e;
    protected boolean f;
    protected Mechanism[] g;
    protected MechanismInfo[][] h;

    protected Mechanism[] e() {
        if (this.g == null) {
            Mechanism mechanism = (Mechanism)this.a().clone();
            mechanism.setParameters(null);
            this.g = new Mechanism[]{mechanism};
        }
        return this.g;
    }

    protected MechanismInfo[][] d() {
        if (this.h == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setGenerate(true);
            this.h = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.h;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.e();
            MechanismInfo[][] mechanismInfoArray = this.d();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected javax.crypto.SecretKey engineGenerateKey() {
        if (!this.e) {
            this.engineInit(-1, null);
        }
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = null;
        Mechanism mechanism = this.a();
        SecretKey secretKey = this.d.getKeyTemplate();
        SecretKey secretKey2 = null;
        if (!this.f) {
            this.g();
        }
        try {
            secretKey2 = (SecretKey)this.c.generateKey(mechanism, (iaik.pkcs.pkcs11.objects.Object)secretKey);
        }
        catch (TokenException tokenException) {
            this.h();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        iAIKPKCS11SecretKey = IAIKPKCS11SecretKey.create(this.b, secretKey2);
        if (!secretKey2.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11SecretKey.setSession(this.c);
        }
        this.h();
        this.b.notifyKeyStores();
        return iAIKPKCS11SecretKey;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.engineInit(-1, secureRandom);
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
        if (iAIKPkcs11 == null) {
            throw new IAIKPkcs11Exception("No IAIKPkcs11 provider available.");
        }
        SecretKey secretKey = IAIKPkcs11.getGlobalKeyHandler().getKeyGeneratorTemplate(this.c(), n);
        AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)((Object)new PKCS11KeyGenerationSpec(secretKey).setUseUserRole(false));
        try {
            this.engineInit(algorithmParameterSpec, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IAIKPkcs11Exception(invalidAlgorithmParameterException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyGenerationSpec)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            SecretKey secretKey = IAIKPkcs11.getGlobalKeyHandler().getKeyGeneratorTemplate(this.c(), algorithmParameterSpec);
            this.d = (PKCS11KeyGenerationSpec)new PKCS11KeyGenerationSpec(secretKey).setUseUserRole(false);
        } else {
            this.d = (PKCS11KeyGenerationSpec)algorithmParameterSpec;
        }
        this.b = this.d.getTokenManager();
        this.g();
        this.e = true;
    }

    protected void f() {
        try {
            if (this.c == null) {
                this.c = this.b.getSession(this.d.isUseRwSession());
            }
            if (!this.d.isUseAnonymousRole()) {
                this.b.login(this.c, this.d.isUseSORole(), this.d.getPin());
            } else {
                this.b.makeAuthorizedSession(this.c, null);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void g() {
        this.f();
        this.f = true;
    }

    protected void h() {
        this.f = false;
        this.b.disposeSession(this.c);
        this.c = null;
    }

    protected abstract Mechanism a();

    protected abstract String c();

    protected void finalize() {
        if (this.c != null) {
            this.b.disposeSession(this.c);
        }
        super.finalize();
    }
}

