/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DhKeyPairGenerator
extends PKCS11KeyPairGenerator {
    protected Mechanism a() {
        return Mechanism.get((long)32L);
    }

    protected String b() {
        return "DH";
    }

    protected iaik.pkcs.pkcs11.objects.Object a(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        PrivateKey privateKey;
        AlgorithmParameterSpec algorithmParameterSpec = pKCS11KeyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            DHPrivateKey dHPrivateKey = new DHPrivateKey();
            int n = dHParameterSpec.getL();
            if (n > 0) {
                dHPrivateKey.getValueBits().setLongValue(new Long(n));
                PrivateKey privateKey2 = pKCS11KeyPairGenerationSpec.getPrivateKeyTemplate();
                GenericTemplate genericTemplate = new GenericTemplate();
                genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)dHPrivateKey);
                if (privateKey2 != null) {
                    genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)privateKey2);
                }
                privateKey = genericTemplate;
            } else {
                privateKey = pKCS11KeyPairGenerationSpec.getPrivateKeyTemplate();
            }
        } else {
            privateKey = pKCS11KeyPairGenerationSpec.getPrivateKeyTemplate();
        }
        return privateKey;
    }

    protected iaik.pkcs.pkcs11.objects.Object b(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        PublicKey publicKey;
        AlgorithmParameterSpec algorithmParameterSpec = pKCS11KeyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            DHPublicKey dHPublicKey = new DHPublicKey();
            BigInteger bigInteger = dHParameterSpec.getP();
            byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger);
            BigInteger bigInteger2 = dHParameterSpec.getG();
            byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger2);
            dHPublicKey.getPrime().setByteArrayValue(byArray);
            dHPublicKey.getBase().setByteArrayValue(byArray2);
            PublicKey publicKey2 = pKCS11KeyPairGenerationSpec.getPublicKeyTemplate();
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)dHPublicKey);
            if (publicKey2 != null) {
                genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)publicKey2);
            }
            publicKey = genericTemplate;
        } else {
            publicKey = pKCS11KeyPairGenerationSpec.getPublicKeyTemplate();
        }
        return publicKey;
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept the given parameters. They must be null or an isntance of DHParameterSpec, but they are " + algorithmParameterSpec);
        }
    }
}

