/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11ECPublicKey;
import iaik.security.ec.common.EllipticCurve;
import iaik.security.ec.errorhandling.DecodingException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public class IAIKPKCS11EC15PublicKey
extends IAIKPKCS11ECPublicKey
implements ECPublicKey {
    public IAIKPKCS11EC15PublicKey(TokenManager tokenManager, PublicKey publicKey) {
        super(tokenManager, publicKey);
    }

    public static IAIKPKCS11ECPublicKey create(TokenManager tokenManager, ECDSAPublicKey eCDSAPublicKey) {
        return new IAIKPKCS11EC15PublicKey(tokenManager, (PublicKey)eCDSAPublicKey);
    }

    public ECPoint getW() {
        try {
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)this.d;
            byte[] byArray = eCDSAPublicKey.getEcPoint().getByteArrayValue();
            ASN1Object aSN1Object = DerCoder.decode((byte[])byArray);
            return ((EllipticCurve)this.getParams().getCurve()).decodePoint((byte[])aSN1Object.getValue());
        }
        catch (DecodingException decodingException) {
            throw new IAIKPkcs11Exception(decodingException.getMessage());
        }
        catch (CodingException codingException) {
            throw new IAIKPkcs11Exception(codingException.getMessage());
        }
    }

    public ECParameterSpec getParams() {
        try {
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)this.d;
            byte[] byArray = eCDSAPublicKey.getEcdsaParams().getByteArrayValue();
            ASN1Object aSN1Object = DerCoder.decode((byte[])byArray);
            return iaik.security.ec.common.ECParameterSpec.decode((ASN1Object)aSN1Object);
        }
        catch (CodingException codingException) {
            throw new IAIKPkcs11Exception(codingException.getMessage());
        }
    }
}

