/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.digest;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.NoSuchAlgorithmRuntimeException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public abstract class ProxyMessageDigest
extends MessageDigestSpi {
    protected MessageDigest digest_;

    protected ProxyMessageDigest() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (!XSecProvider.lateAlgorithmProxyInstantiation()) {
            this.getInstanceUncaught(null);
        }
    }

    protected void getInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException, NoSuchProviderException {
        String string = this.getMessageDigestName();
        Provider provider = XSecProvider.getDelegationProvider("MessageDigest." + string, purpose);
        if (provider != null) {
            try {
                this.digest_ = MessageDigest.getInstance(string, provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.digest_ = MessageDigest.getInstance(string, provider.getName());
            }
        }
        if (this.digest_ == null) {
            this.digest_ = MessageDigest.getInstance(string);
        }
    }

    protected void getInstance(XSecProvider.Purpose purpose) {
        if (this.digest_ != null) {
            return;
        }
        try {
            this.getInstanceUncaught(purpose);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmRuntimeException("Delegation provider not registered, any more.", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmRuntimeException("Delegation provider not registered, any more.", noSuchAlgorithmException);
        }
    }

    protected abstract String getMessageDigestName();

    protected void engineReset() {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        this.digest_.reset();
    }

    protected byte[] engineDigest() {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        return this.digest_.digest();
    }

    protected void engineUpdate(byte by) {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        this.digest_.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        this.digest_.update(byArray, n2, n3);
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        this.digest_.update(byteBuffer);
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        return this.digest_.digest(byArray, n2, n3);
    }

    protected int engineGetDigestLength() {
        if (this.digest_ == null) {
            this.getInstance(null);
        }
        return this.digest_.getDigestLength();
    }
}

