/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.signature;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.xml.crypto.alg.signature.ProxySignature;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;

public class ECDSAProxySignature
extends ProxySignature {
    protected String getSignatureName() {
        return "ECDSA";
    }

    protected byte[] engineSign() throws SignatureException {
        INTEGER iNTEGER;
        INTEGER iNTEGER2;
        Object object;
        byte[] byArray = super.engineSign();
        try {
            object = new ASN1(byArray);
            iNTEGER2 = (INTEGER)object.getComponentAt(0);
            iNTEGER = (INTEGER)object.getComponentAt(1);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        object = (BigInteger)iNTEGER2.getValue();
        BigInteger bigInteger = (BigInteger)iNTEGER.getValue();
        byte[] byArray2 = ECDSAProxySignature.unsignedBigIntergerToByteArray((BigInteger)object);
        byte[] byArray3 = ECDSAProxySignature.unsignedBigIntergerToByteArray(bigInteger);
        int n2 = Math.max(byArray2.length, byArray3.length);
        byte[] byArray4 = new byte[2 * n2];
        System.arraycopy(byArray2, 0, byArray4, n2 - byArray2.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, 2 * n2 - byArray3.length, byArray3.length);
        return byArray4;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        int n2 = byArray.length / 2;
        if (byArray.length % 2 != 0) {
            throw new SignatureException("Specified ECDSA signature (r || s) does not consist of an even number of bytes, wich is necessary to seperate r and s.");
        }
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
        System.arraycopy(byArray, n2, byArray4, 0, byArray4.length);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = new BigInteger(1, byArray4);
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(bigInteger));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(bigInteger2));
        try {
            byArray2 = new ASN1((ASN1Object)sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        return super.engineVerify(byArray2);
    }

    public static byte[] unsignedBigIntergerToByteArray(BigInteger bigInteger) {
        if (bigInteger == null) {
            return null;
        }
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 0 && byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }
}

