/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.a;
import iaik.utils.InternalErrorException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public class ASN
implements Cloneable {
    static final Class a = c == null ? (c = ASN.class$("iaik.asn1.ASN1Object")) : c;
    static final a b = new a(a);
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT_SPECIFIC = 128;
    public static final int PRIVATE = 192;
    public static final ASN UNKNOWN = new ASN(0, "UNKNOWN");
    public static final ASN BOOLEAN = new ASN(1, "BOOLEAN");
    public static final ASN INTEGER = new ASN(2, "INTEGER");
    public static final ASN BIT_STRING = new ASN(3, "BIT STRING");
    public static final ASN OCTET_STRING = new ASN(4, "OCTET STRING");
    public static final ASN NULL = new ASN(5, "NULL");
    public static final ASN ObjectID = new ASN(6, "OBJECT ID");
    public static final ASN OBJECT_DESCRIPTOR = new ASN(7, "OBJECT DESCRIPTOR");
    public static final ASN EXTERNAL = new ASN(8, "EXTERNAL");
    public static final ASN ENUMERATED = new ASN(10, "ENUMERATED");
    public static final ASN UTF8String = new ASN(12, "UTF8String");
    public static final ASN SEQUENCE = new ASN(16, "SEQUENCE");
    public static final ASN SET = new ASN(17, "SET");
    public static final ASN NumericString = new ASN(18, "NumericString");
    public static final ASN PrintableString = new ASN(19, "PrintableString");
    public static final ASN T61String = new ASN(20, "T61String");
    public static final ASN IA5String = new ASN(22, "IA5String");
    public static final ASN UTCTime = new ASN(23, "UTCTime");
    public static final ASN GeneralizedTime = new ASN(24, "GeneralizedTime");
    public static final ASN VisibleString = new ASN(26, "VisibleString");
    public static final ASN GeneralString = new ASN(27, "GeneralString");
    public static final ASN UNIString = new ASN(28, "UNIString");
    public static final ASN BMPString = new ASN(30, "BMPString");
    public static final ASN CON_SPEC = new ASN(128, "CONTEXTSPECIFIC", 128);
    private static final ASN d = new ASN(0, "CONTEXTSPECIFIC", 128);
    protected int tag;
    protected int tag_class;
    protected String name;
    static Class c;

    public static ASN1Object create(ASN aSN) throws InstantiationException {
        ASN1Object aSN1Object;
        if (aSN == null) {
            aSN = NULL;
        }
        if (aSN.tag_class == 128) {
            aSN1Object = (ASN1Object)b.create(d);
            aSN1Object.asnType.tag = aSN.tag;
        } else {
            aSN1Object = (ASN1Object)b.create(aSN);
        }
        return aSN1Object;
    }

    public static ASN1Object create(ASN aSN, Object object) throws InstantiationException {
        ASN1Object aSN1Object = ASN.create(aSN);
        aSN1Object.setValue(object);
        return aSN1Object;
    }

    public static void register(ASN aSN, Class clazz) {
        if (!a.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is no ASN1Object implementation!");
        }
        b.register((Object)aSN, clazz);
    }

    private static void a(ASN aSN, String string) {
        b.register((Object)aSN, string);
    }

    public static ASN1Object createSequenceOf(ASN1Type[] aSN1TypeArray) throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (aSN1TypeArray == null || aSN1TypeArray.length == 0) {
            return sEQUENCE;
        }
        for (int i2 = 0; i2 < aSN1TypeArray.length; ++i2) {
            sEQUENCE.addComponent(aSN1TypeArray[i2].toASN1Object());
        }
        return sEQUENCE;
    }

    public static ASN1Object createSequenceOf(Vector vector) throws CodingException {
        ASN1Type[] aSN1TypeArray = new ASN1Type[vector.size()];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            aSN1TypeArray[n2] = (ASN1Type)enumeration.nextElement();
            ++n2;
        }
        return ASN.createSequenceOf(aSN1TypeArray);
    }

    public static ASN1Object createSetOf(ASN1Type[] aSN1TypeArray) throws CodingException {
        return ASN.createSetOf(aSN1TypeArray, false);
    }

    public static ASN1Object createSetOf(ASN1Type[] aSN1TypeArray, boolean bl) throws CodingException {
        SET sET = new SET(bl);
        if (aSN1TypeArray == null) {
            return sET;
        }
        for (int i2 = 0; i2 < aSN1TypeArray.length; ++i2) {
            sET.addComponent(aSN1TypeArray[i2].toASN1Object());
        }
        return sET;
    }

    public static ASN1Object createSetOf(Vector vector) throws CodingException {
        ASN1Type[] aSN1TypeArray = new ASN1Type[vector.size()];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            aSN1TypeArray[n2] = (ASN1Type)enumeration.nextElement();
            ++n2;
        }
        return ASN.createSetOf(aSN1TypeArray);
    }

    public static ASN1Type[] parseSequenceOf(ASN1Object aSN1Object, Class clazz) throws CodingException {
        ASN1Type[] aSN1TypeArray = null;
        int n2 = aSN1Object.countComponents();
        try {
            aSN1TypeArray = (ASN1Type[])Array.newInstance(clazz, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                aSN1TypeArray[i2] = (ASN1Type)clazz.newInstance();
                aSN1TypeArray[i2].decode(aSN1Object.getComponentAt(i2));
            }
        }
        catch (InstantiationException instantiationException) {
            throw new InternalErrorException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalErrorException(illegalAccessException);
        }
        return aSN1TypeArray;
    }

    public ASN(int n2, String string) {
        this.tag = n2;
        this.name = string;
        this.tag_class = 0;
    }

    public ASN(int n2, String string, int n3) {
        this.tag = n2;
        this.name = string;
        this.tag_class = n3;
    }

    public String getName() {
        return this.name;
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tag_class;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ASN)) {
            return false;
        }
        ASN aSN = (ASN)object;
        return this.tag == aSN.tag && this.tag_class == aSN.tag_class;
    }

    public int hashCode() {
        return this.tag | this.tag_class << 24;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ASN.1 Type [");
        stringBuffer.append(this.tag);
        stringBuffer.append(",");
        stringBuffer.append(this.name);
        stringBuffer.append(",");
        if (this.tag_class == 192) {
            stringBuffer.append("PRIVATE");
        } else if (this.tag_class == 64) {
            stringBuffer.append("APPLICATION");
        } else if (this.tag_class == 128) {
            stringBuffer.append("CONTEXT_SPECIFIC");
        } else {
            stringBuffer.append("UNIVERSAL");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ASN.a(BIT_STRING, "iaik.asn1.BIT_STRING");
        ASN.a(BOOLEAN, "iaik.asn1.BOOLEAN");
        ASN.a(ObjectID, "iaik.asn1.ObjectID");
        ASN.a(ENUMERATED, "iaik.asn1.ENUMERATED");
        ASN.a(UTF8String, "iaik.asn1.UTF8String");
        ASN.a(IA5String, "iaik.asn1.IA5String");
        ASN.a(INTEGER, "iaik.asn1.INTEGER");
        ASN.a(NULL, "iaik.asn1.NULL");
        ASN.a(OCTET_STRING, "iaik.asn1.OCTET_STRING");
        ASN.a(NumericString, "iaik.asn1.NumericString");
        ASN.a(PrintableString, "iaik.asn1.PrintableString");
        ASN.a(T61String, "iaik.asn1.T61String");
        ASN.a(GeneralString, "iaik.asn1.GeneralString");
        ASN.a(BMPString, "iaik.asn1.BMPString");
        ASN.a(UNIString, "iaik.asn1.UNIString");
        ASN.a(UTCTime, "iaik.asn1.UTCTime");
        ASN.a(GeneralizedTime, "iaik.asn1.GeneralizedTime");
        ASN.a(VisibleString, "iaik.asn1.VisibleString");
        ASN.a(SEQUENCE, "iaik.asn1.SEQUENCE");
        ASN.a(SET, "iaik.asn1.SET");
        ASN.a(d, "iaik.asn1.CON_SPEC");
        ASN.a(UNKNOWN, "iaik.asn1.UNKNOWN");
    }
}

