/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerInputException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.ObjectID;
import iaik.asn1.UNIString;
import iaik.asn1.UTCTime;
import iaik.asn1.UTF8String;
import iaik.utils.ExtByteArrayOutputStream;
import iaik.utils.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;

public class DerInputStream
extends InputStream {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT_SPECIFIC = 128;
    public static final int PRIVATE = 192;
    public static final int CONSTRUCTED = 32;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_ID = 6;
    public static final int OBJECT_DESCRIPTOR = 7;
    public static final int EXTERNAL = 8;
    public static final int ENUMERATED = 10;
    public static final int UTF8String = 12;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int NumericString = 18;
    public static final int PrintableString = 19;
    public static final int T61String = 20;
    public static final int IA5String = 22;
    public static final int UTCTime = 23;
    public static final int GeneralizedTime = 24;
    public static final int VisibleString = 26;
    public static final int GeneralString = 27;
    public static final int UNIString = 28;
    public static final int BMPString = 30;
    int a;
    boolean b = false;
    InputStream c;
    int d;
    DerInputStream e;
    InputStream f;

    public DerInputStream(InputStream inputStream) {
        this.a = -2;
        this.d = -2;
        this.f = this.c = new PushbackInputStream(inputStream, 32);
    }

    private DerInputStream(DerInputStream derInputStream, int n2, int n3) {
        this.c = derInputStream;
        this.a = n2;
        this.d = n3;
        derInputStream.e = this;
        this.f = derInputStream.a();
    }

    InputStream a() {
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int skipObjects(int n2) throws IOException {
        int n3 = 0;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        DerInputStream derInputStream = null;
        try {
            while (n3 < n2 && (this.d = this.a(false)) > 0) {
                int n4 = this.c();
                if (n4 >= 0) {
                    this.skip(n4);
                } else {
                    derInputStream = new DerInputStream(this, n4, this.d);
                    derInputStream.skipObjects(-1);
                }
                ++n3;
            }
        }
        finally {
            if (derInputStream != null) {
                try {
                    derInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n3;
    }

    public int available() {
        if (this.b) {
            return 0;
        }
        return this.a;
    }

    public void close() throws IOException {
        this.c.close();
    }

    void a(int n2) throws IOException {
        if (this.c instanceof PushbackInputStream) {
            ((PushbackInputStream)this.c).unread(n2);
        } else {
            ((DerInputStream)this.c).a(n2);
        }
        if (this.a >= 0) {
            ++this.a;
        }
    }

    void a(byte[] byArray, int n2) throws IOException {
        if (this.c instanceof PushbackInputStream) {
            ((PushbackInputStream)this.c).unread(byArray, 0, n2);
        } else {
            ((DerInputStream)this.c).a(byArray, n2);
        }
        if (this.a >= 0) {
            this.a += n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int a(boolean bl) throws IOException {
        if (this.e != null) {
            this.e.readEOC();
        }
        if (this.b) {
            return -1;
        }
        int n2 = this.read();
        boolean bl2 = false;
        if (n2 == -1) {
            bl2 = true;
        } else if (n2 == 0) {
            if (this.a >= 0) throw new DerInputException("Found EOC 0 tag but no indefinite length encoding!");
            bl2 = true;
            n2 = -1;
            if (this.read() != 0) {
                throw new DerInputException("Indefinite length: second fin byte not 0!");
            }
        } else if ((n2 & 0x1F) == 31) {
            int n3;
            byte[] byArray = new byte[10];
            int n4 = 0;
            byArray[n4++] = (byte)n2;
            n2 = 0;
            do {
                n2 <<= 7;
                n3 = this.read();
                byArray[n4++] = (byte)n3;
                n2 |= n3 & 0x7F;
            } while ((n3 & 0x80) != 0);
            if (bl) {
                this.a(byArray, n4);
            }
        } else {
            if (bl) {
                this.a(n2);
            }
            n2 &= 0x1F;
        }
        if (bl2 && this.a != -2) {
            ((DerInputStream)this.c).b();
        }
        if (!bl2) return n2;
        this.b = true;
        return n2;
    }

    public void readEOC() throws IOException {
        if (!this.b && this.a == -1) {
            int n2 = this.read();
            if (n2 == 0) {
                n2 = this.read();
                if (n2 == -1) {
                    throw new EOFException("Indefinite length: Missing second EOC byte!");
                }
                if (n2 != 0) {
                    throw new DerInputException("Indefinite length: second byte not 0!");
                }
            } else {
                if (n2 == -1) {
                    throw new EOFException("Indefinite length: Missing EOC octets!");
                }
                throw new DerInputException("Indefinite length encoding not closed by EOC!");
            }
            ((DerInputStream)this.c).b();
            this.b = true;
        }
    }

    private void b() throws IOException {
        if (this.b) {
            return;
        }
        if (this.a == -1) {
            int n2 = this.read();
            if (n2 > 0) {
                this.a(n2);
                return;
            }
            if (n2 == 0) {
                if (this.a < 0) {
                    int n3 = this.read();
                    this.b = true;
                    if (n3 != 0) {
                        if (n3 == -1) {
                            throw new EOFException("Indefinite length: Missing second EOC byte!");
                        }
                        throw new DerInputException("Indefinite length: second byte not 0!");
                    }
                } else {
                    throw new DerInputException("Found 0 tag but no indefinite length encoding!");
                }
            }
            if (this.c instanceof DerInputStream) {
                ((DerInputStream)this.c).b();
            }
        } else if (this.a == 0 && this.c instanceof DerInputStream) {
            ((DerInputStream)this.c).b();
        }
    }

    public int nextTag() throws IOException {
        return this.a(true);
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.a(false);
        if (n2 != 1) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read BOOLEAN tag!");
            }
            throw new DerInputException("Next ASN.1 object is no BOOLEAN!");
        }
        if (this.c() != 1) {
            throw new IOException("Boolean length not 1!");
        }
        return this.read() != 0;
    }

    public BigInteger readInteger() throws IOException {
        int n2 = this.a(false);
        if (n2 != 2) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read INTEGER tag!");
            }
            throw new DerInputException("Next ASN.1 object is no INTEGER!");
        }
        try {
            byte[] byArray = new byte[this.c()];
            Util.fillArray(byArray, this);
            return new BigInteger(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 INTEGER!");
        }
    }

    public BIT_STRING readBitString() throws IOException {
        int n2 = this.a(false);
        if (n2 != 3) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read BIT STRING tag!");
            }
            throw new DerInputException("Next ASN.1 object is no BIT_STRING!");
        }
        BIT_STRING bIT_STRING = new BIT_STRING();
        bIT_STRING.decode(this.c(), this);
        return bIT_STRING;
    }

    public byte[] readOctetStringByteArray() throws IOException {
        int n2 = this.a(false);
        if (n2 == -1) {
            return null;
        }
        if (n2 != 4) {
            throw new DerInputException("Next ASN.1 object is no OCTET_STRING!");
        }
        try {
            int n3 = this.c();
            if (n3 >= 0) {
                byte[] byArray = new byte[n3];
                Util.fillArray(byArray, this);
                return byArray;
            }
            throw new DerInputException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 OCTET STRING!");
        }
    }

    public InputStream readOctetString(boolean bl) throws IOException {
        InputStream inputStream;
        if (bl) {
            DerInputStream derInputStream = this;
            while ((inputStream = derInputStream.readOctetString()) instanceof DerInputStream) {
                derInputStream = (DerInputStream)inputStream;
            }
        } else {
            inputStream = this.readOctetString();
        }
        return inputStream;
    }

    public InputStream readOctetString() throws IOException {
        int n2;
        if (this.e != null) {
            this.e.readEOC();
        }
        if ((n2 = this.read()) == -1) {
            return null;
        }
        if ((n2 & 0x1F) != 4) {
            throw new DerInputException("Next ASN.1 object is no OCTET_STRING!");
        }
        int n3 = this.c();
        if ((n2 & 0x20) == 0) {
            if (n3 == -1) {
                throw new DerInputException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
            }
            return new a(new DerInputStream(this, n3, n2), false);
        }
        if (this.f(false)) {
            return new DerInputStream(this, n3, n2);
        }
        return new a(new DerInputStream(this, n3, n2), true);
    }

    public void readNull() throws IOException {
        int n2 = this.a(false);
        if (n2 != 5) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read NULL tag!");
            }
            throw new DerInputException("Next ASN.1 object is not NULL!");
        }
        this.c();
    }

    public ObjectID readObjectID() throws IOException {
        int n2 = this.a(false);
        if (n2 != 6) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read OID tag!");
            }
            throw new DerInputException("Next ASN.1 object is no OBJECT IDENTIFIER!");
        }
        ObjectID objectID = new ObjectID();
        objectID.decode(this.c(), this);
        return objectID;
    }

    public String readString() throws IOException {
        int n2 = this.a(false);
        if (n2 == -1) {
            throw new EOFException("Unexpected EOF when trying to read String tag!");
        }
        byte[] byArray = null;
        try {
            byArray = new byte[this.c()];
            Util.fillArray(byArray, this);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 String value!");
        }
        switch (n2) {
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: {
                return Util.toASCIIString(byArray);
            }
            case 28: {
                return iaik.asn1.UNIString.a(byArray);
            }
            case 30: {
                return new String(byArray, "UnicodeBig");
            }
            case 12: {
                try {
                    return iaik.asn1.UTF8String.getStringFromUTF8Encoding(byArray);
                }
                catch (CodingException codingException) {
                    throw new DerInputException(codingException.getMessage());
                }
            }
        }
        throw new DerInputException("Next ASN.1 object is no STRING type!");
    }

    public UTCTime readUTCTime() throws IOException {
        int n2 = this.a(false);
        if (n2 != 23) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read UTCTime tag!");
            }
            throw new DerInputException("Next ASN.1 object is no UTC TIME!");
        }
        UTCTime uTCTime = new UTCTime();
        uTCTime.decode(this.c(), this);
        return uTCTime;
    }

    public GeneralizedTime readGeneralizedTime() throws IOException {
        int n2 = this.a(false);
        if (n2 != 24) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read GeneralizedTime tag!");
            }
            throw new DerInputException("Next ASN.1 object is no GeneralizedTime!");
        }
        GeneralizedTime generalizedTime = new GeneralizedTime();
        generalizedTime.decode(this.c(), this);
        return generalizedTime;
    }

    public DerInputStream readSequence() throws IOException {
        int n2 = this.a(false);
        if (n2 != 16) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read SEQUENCE tag!");
            }
            throw new DerInputException("Next ASN.1 object is no SEQUENCE!");
        }
        return new DerInputStream(this, this.c(), n2);
    }

    public DerInputStream readSet() throws IOException {
        int n2 = this.a(false);
        if (n2 != 17) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read SET tag!");
            }
            throw new DerInputException("Next ASN.1 object is no SET!");
        }
        return new DerInputStream(this, this.c(), n2);
    }

    public DerInputStream readConstructed() throws IOException {
        if (!this.f(true)) {
            throw new DerInputException("Next ASN.1 object is not CONSTRUCTED!");
        }
        int n2 = this.a(false);
        return new DerInputStream(this, this.c(), n2);
    }

    public DerInputStream readContextSpecific() throws IOException {
        if (!this.d(true)) {
            throw new DerInputException("Next ASN.1 object is no CONTEXT SPECIFIC!");
        }
        int n2 = this.a(false);
        return new DerInputStream(this, this.c(), n2);
    }

    public int readContextSpecific(int n2) throws IOException {
        if (!this.d(true)) {
            throw new DerInputException("Next ASN.1 object is no CONTEXT SPECIFIC!");
        }
        if (this.f(true)) {
            n2 |= 0x20;
        }
        int n3 = this.a(false);
        this.a(n2);
        return n3;
    }

    private int c() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException("Unexpected EOF while reading length field!");
        }
        if ((n2 &= 0xFF) < 128) {
            return n2;
        }
        if (n2 == 128) {
            return -1;
        }
        if ((n2 &= 0x7F) > 4) {
            throw new DerInputException("Length: Too large ASN.1 object: " + n2);
        }
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException("Unexpected EOF while reading length field!");
            }
            n3 = n3 << 8 | n4 & 0xFF;
        }
        return n3;
    }

    public int getTag() {
        return this.d;
    }

    public boolean nextIsUniversal() throws IOException {
        return this.b(false);
    }

    private boolean b(boolean bl) throws IOException {
        int n2;
        if (this.e != null) {
            this.e.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 0;
    }

    public boolean nextIsApplication() throws IOException {
        return this.c(false);
    }

    private boolean c(boolean bl) throws IOException {
        int n2;
        if (this.e != null) {
            this.e.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 64;
    }

    public boolean nextIsContextSpecific() throws IOException {
        return this.d(false);
    }

    private boolean d(boolean bl) throws IOException {
        int n2;
        if (this.e != null) {
            this.e.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 128;
    }

    public boolean nextIsPrivate() throws IOException {
        return this.e(false);
    }

    private boolean e(boolean bl) throws IOException {
        int n2;
        if (this.e != null) {
            this.e.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 192;
    }

    public boolean nextIsConstructed() throws IOException {
        return this.f(false);
    }

    private boolean f(boolean bl) throws IOException {
        int n2;
        if (this.e != null) {
            this.e.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0x20) == 32;
    }

    public int read() throws IOException {
        int n2 = -1;
        if (!this.b) {
            if (this.a < 0) {
                n2 = this.c.read();
            } else if (this.a > 0) {
                --this.a;
                n2 = this.c.read();
            }
        }
        return n2;
    }

    public int read(boolean bl) throws IOException {
        int n2 = this.read();
        if (bl && n2 != -1) {
            this.a(n2);
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        if (!this.b) {
            if (this.a < 0) {
                n4 = this.c.read(byArray, n2, n3);
            } else if (this.a > 0) {
                int n5 = Math.min(n3, this.a);
                this.a -= n5;
                int n6 = n5;
                while (n6 > 0) {
                    n4 = this.c.read(byArray, n2, n6);
                    if (n4 < 0) {
                        throw new EOFException();
                    }
                    n6 -= n4;
                    n2 += n4;
                }
                n4 = n5;
            }
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        if (this.a < 0) {
            return this.c.skip(l2);
        }
        int n2 = Math.min((int)l2, this.a);
        this.c.skip(n2);
        this.a -= n2;
        return n2;
    }

    static class a
    extends InputStream {
        private byte[] a;
        private int b;
        private int c;
        private boolean d = false;
        private boolean e = false;
        private final DerInputStream f;
        private InputStream g;
        private int h = 0;
        private ExtByteArrayOutputStream i;
        private final boolean j;

        public a(DerInputStream derInputStream, boolean bl) {
            this.f = derInputStream;
            this.j = bl;
        }

        public int read() throws IOException {
            if (this.j) {
                do {
                    if (this.c <= 0) continue;
                    --this.c;
                    return this.a[this.b++] & 0xFF;
                } while (this.a() != -1);
                return -1;
            }
            int n2 = this.f.read();
            if (n2 == -1) {
                this.f.a(true);
            }
            return n2;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.j) {
                int n4 = 0;
                do {
                    if (this.c >= n3) {
                        System.arraycopy(this.a, this.b, byArray, n2 + n4, n3);
                        this.c -= n3;
                        this.b += n3;
                        return n4 += n3;
                    }
                    if (this.c <= 0) continue;
                    System.arraycopy(this.a, this.b, byArray, n2 + n4, this.c);
                    n3 -= this.c;
                    n4 += this.c;
                    this.c = 0;
                } while (this.a() != -1);
                return n4 == 0 ? -1 : n4;
            }
            int n5 = this.f.read(byArray, n2, n3);
            if (n5 == -1) {
                this.f.a(true);
            }
            return n5;
        }

        public int available() throws IOException {
            if (this.d || this.e) {
                return 0;
            }
            if (this.j) {
                int n2;
                if (this.i == null) {
                    this.i = new ExtByteArrayOutputStream(32);
                }
                while (this.c == 0 && (n2 = this.f.available()) != 0) {
                    int n3;
                    if (this.g == null) {
                        this.g = this.f.a();
                    }
                    if ((n3 = this.g.available()) <= 1) break;
                    if (this.h == 0) {
                        this.i.reset();
                        int n4 = this.b();
                        if (n4 == 4) {
                            this.i.write(n4);
                            int n5 = this.a(this.i, n3);
                            if (n5 > -1) {
                                this.h = this.i.size() + n5;
                            }
                            this.f.a(this.i.getInternalByteArray(), this.i.size());
                        }
                    }
                    if (this.h > 0 && this.h <= n3) {
                        this.a();
                        this.h = 0;
                        if (!this.d && !this.e) continue;
                    }
                    break;
                }
            } else {
                this.c = this.f.available();
                if (this.c != 0) {
                    int n6;
                    if (this.g == null) {
                        this.g = this.f.a();
                    }
                    if ((n6 = this.g.available()) >= 0) {
                        if (this.c > 0) {
                            if (n6 < this.c) {
                                this.c = n6;
                            }
                        } else {
                            this.c = n6;
                        }
                    } else if (this.c < 0) {
                        this.c = 0;
                    }
                }
            }
            return this.c;
        }

        public void close() throws IOException {
            this.f.close();
        }

        private int a() throws IOException {
            if (this.d) {
                return -1;
            }
            this.a = this.f.readOctetStringByteArray();
            if (this.a == null) {
                this.d = true;
                return -1;
            }
            this.c = this.a.length;
            this.b = 0;
            return this.c;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int b() throws IOException {
            int n2 = this.f.read();
            if (n2 == -1) {
                this.e = true;
                return n2;
            } else if (n2 == 0) {
                if (this.f.a >= 0) throw new DerInputException("Found EOC 0 tag but no indefinite length encoding!");
                if (this.f.read() != 0) {
                    throw new DerInputException("Indefinite length: second EOC octet not 0!");
                }
                this.f.a(new byte[]{0, 0}, 2);
                this.e = true;
                return n2;
            } else {
                if (n2 == 4) return n2;
                throw new DerInputException("Not an octet string!");
            }
        }

        private int a(ExtByteArrayOutputStream extByteArrayOutputStream, int n2) throws IOException {
            int n3 = 0;
            int n4 = extByteArrayOutputStream.size();
            if (n2 > n4) {
                int n5 = this.f.read();
                extByteArrayOutputStream.write(n5);
                if ((n5 &= 0xFF) == 128) {
                    throw new DerInputException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
                }
                if (n5 < 128) {
                    n3 = n5;
                } else {
                    ++n4;
                    if ((n5 &= 0x7F) > 4) {
                        throw new DerInputException("Length: Too large ASN.1 object: " + n5);
                    }
                    if (n5 > n2 - n4) {
                        n3 = -1;
                    } else {
                        while (--n5 >= 0) {
                            int n6 = this.f.read();
                            if (n6 == -1) {
                                throw new EOFException("Unexpected EOF while reading length field!");
                            }
                            extByteArrayOutputStream.write(n6);
                            n3 = n3 << 8 | n6 & 0xFF;
                        }
                    }
                }
            }
            return n3;
        }
    }
}

