/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.Padding;
import iaik.pkcs.pkcs1.RSAOaepPSourceParameterSpec;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import iaik.security.md.SHA;
import iaik.security.rsa.RSAOaepPrivateKey;
import iaik.security.rsa.RSAOaepPublicKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;

class a
extends Padding {
    private static final BadPaddingException a = new BadPaddingException("Invalid OAEP padding!");
    private static boolean b = false;
    private AlgorithmID c;
    private MessageDigest d;
    private AlgorithmID e;
    private MaskGenerationAlgorithm f;
    private AlgorithmID g;
    private byte[] h;

    static void a(boolean bl) {
        b = bl;
    }

    static a a(String string) throws NoSuchPaddingException {
        a a2 = null;
        if (string.length() == 4) {
            a2 = new a();
        } else {
            if (string.length() < 21) {
                throw new NoSuchPaddingException("Invalid OAEP padding name: " + string + "!");
            }
            String string2 = string.substring(8, string.length() - 7).toUpperCase(Locale.US);
            int n2 = string2.indexOf("AND");
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 3);
            AlgorithmID algorithmID = iaik.pkcs.pkcs1.a.b(string3.toUpperCase(Locale.US));
            if (algorithmID == null) {
                algorithmID = AlgorithmID.getAlgorithmID(string3);
            }
            if (algorithmID == null) {
                throw new NoSuchPaddingException("No AlgorithmID available for hash algorithm \"" + string3 + "\" of padding scheme " + string);
            }
            algorithmID = (AlgorithmID)algorithmID.clone();
            MessageDigest messageDigest = null;
            try {
                messageDigest = algorithmID.getMessageDigestInstance("IAIK");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    messageDigest = algorithmID.getMessageDigestInstance();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    throw new NoSuchPaddingException("No engine available for hash algorithm \"" + string3 + "\" of padding scheme " + string);
                }
            }
            AlgorithmID algorithmID2 = null;
            MaskGenerationAlgorithm maskGenerationAlgorithm = null;
            if (string4.equals("MGF1")) {
                algorithmID2 = (AlgorithmID)AlgorithmID.mgf1.clone();
                algorithmID2.setParameter(algorithmID.toASN1Object());
                maskGenerationAlgorithm = new MGF1(algorithmID, messageDigest);
            } else {
                algorithmID2 = AlgorithmID.getAlgorithmID(string4);
                if (algorithmID2 == null) {
                    throw new NoSuchPaddingException("No AlgorithmID available for MGF algorithm \"" + string4 + "\" of padding scheme " + string);
                }
                algorithmID2 = (AlgorithmID)algorithmID2.clone();
                try {
                    maskGenerationAlgorithm = algorithmID2.getMaskGenerationAlgorithmInstance("IAIK");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    try {
                        maskGenerationAlgorithm = algorithmID2.getMaskGenerationAlgorithmInstance();
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                        throw new NoSuchPaddingException("No engine available for MGF algorithm \"" + string4 + "\" of padding scheme " + string);
                    }
                }
            }
            AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.pSpecified.clone();
            algorithmID3.setParameter(new OCTET_STRING());
            byte[] byArray = new byte[]{};
            a2 = new a(string, algorithmID, algorithmID2, algorithmID3, messageDigest, maskGenerationAlgorithm, byArray);
        }
        return a2;
    }

    private static AlgorithmID b(String string) {
        String string2 = string.toUpperCase(Locale.US);
        AlgorithmID algorithmID = null;
        if (string2.equals("SHA") || string2.equals("SHA1") || string2.equals("SHA-1")) {
            algorithmID = (AlgorithmID)AlgorithmID.sha.clone();
        } else if (string2.equals("MD5")) {
            algorithmID = (AlgorithmID)AlgorithmID.md5.clone();
        } else if (string2.equals("RIPEMD160") || string2.equals("RIPEMD-160")) {
            algorithmID = (AlgorithmID)AlgorithmID.ripeMd160.clone();
        } else if (string2.equals("RIPEMD128") || string2.equals("RIPEMD-128")) {
            algorithmID = (AlgorithmID)AlgorithmID.ripeMd128.clone();
        } else if (string2.equals("SHA-256") || string2.equals("SHA256")) {
            algorithmID = (AlgorithmID)AlgorithmID.sha256.clone();
        } else if (string2.equals("SHA-384") || string2.equals("SHA384")) {
            algorithmID = (AlgorithmID)AlgorithmID.sha384.clone();
        } else if (string2.equals("SHA-512") || string2.equals("SHA512")) {
            algorithmID = (AlgorithmID)AlgorithmID.sha512.clone();
        } else if (string2.equals("MD2")) {
            algorithmID = (AlgorithmID)AlgorithmID.md2.clone();
        } else if (string2.equals("WHIRLPOOL")) {
            algorithmID = (AlgorithmID)AlgorithmID.whirlpool.clone();
        }
        return algorithmID;
    }

    a() {
        super("OAEP");
        this.c = (AlgorithmID)RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM.clone();
        this.d = new SHA();
        this.e = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.e.setParameter(this.c.toASN1Object());
        this.f = new MGF1(this.c, this.d);
        this.g = (AlgorithmID)AlgorithmID.pSpecified.clone();
        this.g.setParameter(new OCTET_STRING());
        this.h = new byte[0];
    }

    a(String string, AlgorithmID algorithmID, AlgorithmID algorithmID2, AlgorithmID algorithmID3, MessageDigest messageDigest, MaskGenerationAlgorithm maskGenerationAlgorithm, byte[] byArray) {
        super(string);
        this.c = (AlgorithmID)algorithmID.clone();
        this.e = (AlgorithmID)algorithmID2.clone();
        this.g = (AlgorithmID)algorithmID3.clone();
        this.d = messageDigest;
        this.f = maskGenerationAlgorithm;
        this.h = (byte[])byArray.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int n2, Key key, int n3, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.init(n2, key, n3, algorithmParameterSpec, secureRandom);
        if (this.modLen_ < 42) {
            throw new InvalidKeyException("OAEP requires a modulus of at least 336 bits!");
        }
        if (this.opMode_ == 1) {
            if (this.publicKey_ == null) {
                throw new InvalidKeyException("OAEP cannot be used to generate signatures");
            }
        } else if (this.privateKey_ == null) {
            throw new InvalidKeyException("OAEP cannot be used to verify signatures");
        }
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof RSAOaepParameterSpec) {
                RSAOaepParameterSpec rSAOaepParameterSpec = (RSAOaepParameterSpec)algorithmParameterSpec;
                if (b) {
                    if (this.publicKey_ != null) {
                        if (this.publicKey_ instanceof RSAOaepPublicKey) {
                            try {
                                if (!((RSAOaepPublicKey)this.publicKey_).validateParameters(algorithmParameterSpec)) {
                                    throw new InvalidAlgorithmParameterException("Parameters are not valid for OAEP-Key used with this engine!");
                                }
                            }
                            catch (InvalidParameterSpecException invalidParameterSpecException) {}
                        }
                    } else if (this.privateKey_ != null && this.privateKey_ instanceof RSAOaepPrivateKey) {
                        try {
                            if (!((RSAOaepPrivateKey)this.privateKey_).validateParameters(algorithmParameterSpec)) {
                                throw new InvalidAlgorithmParameterException("Parameters are not valid for OAEP-Key used with this engine!");
                            }
                        }
                        catch (InvalidParameterSpecException invalidParameterSpecException) {
                            // empty catch block
                        }
                    }
                }
                this.a(rSAOaepParameterSpec);
                return;
            }
            if (!(algorithmParameterSpec instanceof RSAOaepPSourceParameterSpec)) throw new InvalidAlgorithmParameterException("Invalid parameters. Expected RSAOaepParameterSpec or RSAOaepPSourceParameterSpec!");
            this.d();
            RSAOaepPSourceParameterSpec rSAOaepPSourceParameterSpec = (RSAOaepPSourceParameterSpec)algorithmParameterSpec;
            this.g = rSAOaepPSourceParameterSpec.getPSourceAlgorithm();
            this.h = rSAOaepPSourceParameterSpec.getLabel();
            return;
        }
        this.d();
    }

    private void d() throws InvalidAlgorithmParameterException {
        RSAOaepParameterSpec rSAOaepParameterSpec = null;
        if (this.publicKey_ != null) {
            if (this.publicKey_ instanceof RSAOaepPublicKey) {
                rSAOaepParameterSpec = (RSAOaepParameterSpec)((RSAOaepPublicKey)this.publicKey_).getParams();
            }
        } else if (this.privateKey_ != null && this.privateKey_ instanceof RSAOaepPrivateKey) {
            rSAOaepParameterSpec = (RSAOaepParameterSpec)((RSAOaepPrivateKey)this.privateKey_).getParams();
        }
        if (rSAOaepParameterSpec != null) {
            this.a(rSAOaepParameterSpec);
        }
    }

    private void a(RSAOaepParameterSpec rSAOaepParameterSpec) throws InvalidAlgorithmParameterException {
        this.c = rSAOaepParameterSpec.getHashAlgorithm();
        try {
            this.d = rSAOaepParameterSpec.getHashEngine();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException("Cannot set hash algorithm parameter; no hash engine available: " + noSuchAlgorithmException.getMessage());
        }
        this.e = rSAOaepParameterSpec.getMaskGenAlgorithm();
        try {
            this.f = rSAOaepParameterSpec.getMGFEngine();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException("Cannot set mask generation algorithm parameter; no mgf engine available: " + noSuchAlgorithmException.getMessage());
        }
        this.g = rSAOaepParameterSpec.getPSourceAlgorithm();
        this.h = rSAOaepParameterSpec.getLabel();
    }

    public AlgorithmParameters getParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.c != null && this.e != null && this.g != null) {
            if (this.h != null) {
                this.g.setParameter(new OCTET_STRING((byte[])this.h.clone()));
            }
            try {
                RSAOaepParameterSpec rSAOaepParameterSpec = new RSAOaepParameterSpec(this.c, this.e, this.g);
                algorithmParameters = AlgorithmParameters.getInstance("OAEP", "IAIK");
                algorithmParameters.init(rSAOaepParameterSpec);
                return algorithmParameters;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return algorithmParameters;
    }

    public byte[] pad(byte[] byArray) throws BadPaddingException {
        if (this.d == null) {
            throw new NullPointerException("Cannot do OAEP padding. Hash engine must not be null!");
        }
        if (this.f == null) {
            throw new NullPointerException("Cannot do OAEP padding. MGF engine must not be null!");
        }
        SecureRandom secureRandom = this.b();
        if (secureRandom == null) {
            throw new NullPointerException("Cannot do OAEP padding. No SecureRandom available!");
        }
        if (this.h == null) {
            this.h = new byte[0];
        }
        byte[] byArray2 = this.d.digest(this.h);
        int n2 = byArray2.length;
        int n3 = this.modLen_;
        if (byArray.length > this.modLen_ - 2 * n2 - 2) {
            throw new BadPaddingException("Message to long for OAEP, must be (2*hLen)-2 bytes less than modulus");
        }
        byte[] byArray3 = new byte[n2];
        secureRandom.nextBytes(byArray3);
        byte[] byArray4 = new byte[n3];
        int n4 = 1;
        int n5 = n2;
        int n6 = n3 - n2 - 1;
        int n7 = n5 + 1;
        System.arraycopy(byArray3, 0, byArray4, n4, n5);
        System.arraycopy(byArray2, 0, byArray4, n7, n2);
        System.arraycopy(byArray, 0, byArray4, n3 - byArray.length, byArray.length);
        byArray4[n3 - byArray.length - 1] = 1;
        this.f.mask(byArray4, n4, n5, n6, byArray4, n7);
        this.f.mask(byArray4, n7, n6, n5, byArray4, n4);
        this.a();
        return byArray4;
    }

    public byte[] unpad(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3;
        byte[] byArray2;
        int n4;
        if (this.d == null) {
            throw new NullPointerException("Cannot do OAEP padding. Hash engine must not be null!");
        }
        if (this.f == null) {
            throw new NullPointerException("Cannot do OAEP padding. MGF engine must not be null!");
        }
        byte[] byArray3 = byArray;
        int n5 = byArray3.length;
        if (this.h == null) {
            this.h = new byte[0];
        }
        if (this.modLen_ < 2 * (n4 = (byArray2 = this.d.digest(this.h)).length) + 2) {
            throw new BadPaddingException("Invalid OAEP: decrypted message too short");
        }
        int n6 = 1;
        int n7 = n4;
        int n8 = n5 - n4 - 1;
        int n9 = n6 + n7;
        this.f.mask(byArray3, n9, n8, n7, byArray3, n6);
        this.f.mask(byArray3, n6, n7, n8, byArray3, n9);
        boolean bl = false;
        for (n3 = 0; n3 < n4; ++n3) {
            if (byArray3[n9 + n3] == byArray2[n3]) continue;
            bl = true;
        }
        int n10 = n9 + n3;
        int n11 = -1;
        for (n2 = n3; n2 < n8; ++n2) {
            if (byArray3[n9 + n3] == 0) {
                ++n3;
                continue;
            }
            ++n11;
        }
        if (n3 == n8 || byArray3[n9 + n3++] != 1) {
            bl = true;
        }
        if (n11 == -1) {
            ++n11;
        }
        n2 = n9 + n3;
        byte[] byArray4 = new byte[n2 - n10];
        System.arraycopy(byArray3, n10, byArray4, 0, byArray4.length);
        byte[] byArray5 = new byte[n11];
        System.arraycopy(byArray3, n2, byArray5, 0, n11);
        System.arraycopy(byArray5, 0, byArray, 0, n11);
        System.arraycopy(byArray4, 0, byArray, n11, byArray4.length);
        this.a();
        if (bl) {
            throw a;
        }
        return byArray5;
    }

    void a() {
        if (this.d != null) {
            this.d.reset();
        }
        if (this.f != null) {
            this.f.reset();
        }
    }
}

