/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.DES;
import iaik.security.cipher.DESKeyGenerator;
import iaik.security.cipher.SecretKey;
import iaik.security.pbe.PBEGenParameterSpec;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PbeWithMD5AndDES_CBC
extends DES {
    protected AlgorithmParameters params;
    static Class j;

    public PbeWithMD5AndDES_CBC() throws NoSuchAlgorithmException, NoSuchPaddingException {
        super.engineSetMode("CBC");
        try {
            this.params = AlgorithmParameters.getInstance("PBE", "IAIK");
        }
        catch (Exception exception) {
            this.params = AlgorithmParameters.getInstance("PBE");
        }
    }

    public AlgorithmParameters engineGetParameters() {
        return this.params;
    }

    protected void initCipher(int n2, Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        MessageDigest messageDigest;
        PBEParameterSpec pBEParameterSpec;
        if (key == null || !key.getAlgorithm().equals("PBE") || !key.getFormat().equals("RAW")) {
            throw new InvalidKeyException("Must be a PBEKey in RAW format.");
        }
        byte[] byArray = key.getEncoded();
        try {
            pBEParameterSpec = (PBEParameterSpec)this.params.getParameterSpec(j == null ? (j = PbeWithMD5AndDES_CBC.class$("javax.crypto.spec.PBEParameterSpec")) : j);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
        byte[] byArray2 = pBEParameterSpec.getSalt();
        int n3 = pBEParameterSpec.getIterationCount();
        if (byArray2.length != 8) {
            throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long.");
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        try {
            messageDigest = MessageDigest.getInstance("MD5", "IAIK");
        }
        catch (Exception exception) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException(noSuchAlgorithmException.toString());
            }
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray3 = messageDigest.digest(byArray3);
        }
        DESKeyGenerator.adjustParity(byArray3, 0);
        SecretKey secretKey = new SecretKey(byArray3, 0, 8, "DES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3, 8, 8);
        super.engineInit(n2, (Key)secretKey, ivParameterSpec, null);
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = this.a("PBE");
            algorithmParameterGenerator.init(8, secureRandom);
            this.params = algorithmParameterGenerator.generateParameters();
            this.initCipher(n2, key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters == null || algorithmParameters.getAlgorithm() != "PBE") {
            throw new InvalidAlgorithmParameterException("Parameters must be of type PBEParameters.");
        }
        this.params = algorithmParameters;
        this.initCipher(n2, key);
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.engineInit(n2, key, secureRandom);
        } else {
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                try {
                    this.params.init(algorithmParameterSpec);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
                }
            } else if (algorithmParameterSpec instanceof PBEGenParameterSpec) {
                try {
                    AlgorithmParameterGenerator algorithmParameterGenerator = this.a("PBE");
                    algorithmParameterGenerator.init(algorithmParameterSpec, secureRandom);
                    this.params = algorithmParameterGenerator.generateParameters();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
                }
            } else {
                throw new InvalidAlgorithmParameterException("Parameters must be an instance of PBEParameterSpec or PBEGenParameterSpec.");
            }
            this.initCipher(n2, key);
        }
    }

    public void engineSetPadding(String string) {
    }

    public void engineSetMode(String string) {
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n2 = 56;
        return n2;
    }

    private AlgorithmParameterGenerator a(String string) throws NoSuchAlgorithmException {
        AlgorithmParameterGenerator algorithmParameterGenerator = null;
        try {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string, "IAIK");
        }
        catch (Exception exception) {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
        }
        return algorithmParameterGenerator;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

