/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.security.dsa.DSAPrivateKey;
import iaik.security.dsa.DSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class DSAKeyFactory
extends KeyFactorySpi {
    static Class a;
    static Class b;
    static Class c;
    static Class d;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPrivateKeySpec) {
                return new DSAPrivateKey((DSAPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only DSA key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                return new DSAPublicKey((DSAPublicKeySpec)keySpec);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only DSA key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof java.security.interfaces.DSAPublicKey) {
            if ((a == null ? (a = DSAKeyFactory.class$("java.security.spec.DSAPublicKeySpec")) : a).isAssignableFrom(clazz)) {
                java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
                DSAParams dSAParams = dSAPublicKey.getParams();
                return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            }
            if ((b == null ? (b = DSAKeyFactory.class$("java.security.spec.X509EncodedKeySpec")) : b).isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        if (key instanceof java.security.interfaces.DSAPrivateKey) {
            java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
            if ((c == null ? (c = DSAKeyFactory.class$("java.security.spec.DSAPrivateKeySpec")) : c).isAssignableFrom(clazz)) {
                DSAParams dSAParams = dSAPrivateKey.getParams();
                return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            }
            if ((d == null ? (d = DSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")) : d).isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(dSAPrivateKey.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        throw new InvalidKeySpecException("Can only convert DSA keys.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof java.security.interfaces.DSAPublicKey) {
            BigInteger bigInteger = ((java.security.interfaces.DSAPublicKey)key).getY();
            DSAParams dSAParams = ((java.security.interfaces.DSAPublicKey)key).getParams();
            return new DSAPublicKey(bigInteger, dSAParams);
        }
        if (key instanceof java.security.interfaces.DSAPrivateKey) {
            BigInteger bigInteger = ((java.security.interfaces.DSAPrivateKey)key).getX();
            DSAParams dSAParams = ((java.security.interfaces.DSAPrivateKey)key).getParams();
            return new DSAPrivateKey(bigInteger, dSAParams);
        }
        throw new InvalidKeyException("Only keys of type DSAPublicKey and DSAPrivateKey can be translated.");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

