/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.elgamal;

import iaik.security.elgamal.ElGamalGenParameterSpec;
import iaik.security.elgamal.ElGamalParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class ElGamalParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final BigInteger a = BigInteger.valueOf(2L);
    private SecureRandom b;
    private int c = 1024;
    private int d = 300;

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.c = n2;
        this.b = secureRandom;
        this.a();
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ElGamalGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("DH parameter generator requires a DHGenParameterSpec for initialisation");
        }
        ElGamalGenParameterSpec elGamalGenParameterSpec = (ElGamalGenParameterSpec)algorithmParameterSpec;
        this.c = elGamalGenParameterSpec.getPrimeSize();
        this.d = elGamalGenParameterSpec.getExponentSize();
        this.b = secureRandom;
        this.a();
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters;
        BigInteger[] bigIntegerArray = ElGamalParameterGenerator.a(this.c, 80, this.b);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = ElGamalParameterGenerator.a(bigInteger, bigInteger2, this.b);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("ElGamal", "IAIK");
            algorithmParameters.init(new ElGamalParameterSpec(bigInteger, bigInteger3, this.d));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return algorithmParameters;
    }

    private static BigInteger[] a(int n2, int n3, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n4 = n2 - 1;
        while (!(bigInteger2 = (bigInteger = new BigInteger(n4, 2, secureRandom)).shiftLeft(1).add(BigInteger.ONE)).isProbablePrime(n3) || !bigInteger.isProbablePrime(n3)) {
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(a);
        while ((bigInteger4 = new BigInteger(bigInteger.bitLength(), secureRandom)).compareTo(a) < 0 || bigInteger4.compareTo(bigInteger5) > 0 || (bigInteger3 = bigInteger4.multiply(bigInteger4).mod(bigInteger)).equals(BigInteger.ONE)) {
        }
        return bigInteger3;
    }

    private void a() throws IllegalArgumentException {
        if (this.c < 512 || this.d != 0 && this.d < 160) {
            throw new IllegalArgumentException("Prime must be at least 512, exponent at least 160 bits long!");
        }
    }
}

