/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.security.rsa.RSA;
import iaik.utils.CryptoUtils;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class RawRSASignature
extends SignatureSpi {
    private RSA a;
    protected ByteArrayOutputStream dataBuffer_;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.a = RSA.a();
            this.dataBuffer_ = new ByteArrayOutputStream(64);
            this.a.setMode("ECB");
            this.a.setPadding("PKCS1Padding");
            this.a.init(2, publicKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitVerify error: " + exception.toString());
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.appRandom = secureRandom;
        try {
            this.a = RSA.a();
            this.dataBuffer_ = new ByteArrayOutputStream(64);
            this.a.setMode("ECB");
            this.a.setPadding("PKCS1Padding");
            this.a.init(1, privateKey, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitSign error: " + exception.toString());
        }
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.dataBuffer_.toByteArray();
        byte[] byArray2 = null;
        try {
            byArray2 = this.a.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signing error: " + exception.toString());
        }
        return byArray2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        byte[] byArray3 = this.dataBuffer_.toByteArray();
        try {
            byArray2 = this.a.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signature decryption error: " + exception.toString());
        }
        return CryptoUtils.secureEqualsBlock(byArray3, byArray2);
    }

    protected void engineUpdate(byte by) {
        this.dataBuffer_.write(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.dataBuffer_.write(byArray, n2, n3);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }
}

