/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.math.BigInteger;

public class IssuerSerial {
    private GeneralNames a;
    private BigInteger b;
    private BigInteger c;

    public IssuerSerial(GeneralNames generalNames, BigInteger bigInteger) {
        this.a = generalNames;
        this.b = bigInteger;
    }

    public IssuerSerial(Name name, BigInteger bigInteger) {
        GeneralName generalName = new GeneralName(4, name);
        this.a = new GeneralNames(generalName);
        this.b = bigInteger;
    }

    public IssuerSerial(X509Certificate x509Certificate) {
        GeneralName generalName = new GeneralName(4, x509Certificate.getIssuerDN());
        this.a = new GeneralNames(generalName);
        this.b = x509Certificate.getSerialNumber();
        this.setIssuerUID(x509Certificate.getIssuerUniqueID());
    }

    public IssuerSerial(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        this.a = new GeneralNames(aSN1Object.getComponentAt(0));
        this.b = (BigInteger)aSN1Object.getComponentAt(1).getValue();
        if (aSN1Object.countComponents() == 3) {
            this.c = new BigInteger(1, (byte[])aSN1Object.getComponentAt(2).getValue());
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            sEQUENCE.addComponent(this.a.toASN1Object());
            sEQUENCE.addComponent(new INTEGER(this.b));
            if (this.c != null) {
                sEQUENCE.addComponent(new BIT_STRING(this.c.toByteArray()));
            }
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        return sEQUENCE;
    }

    public GeneralNames getIssuer() {
        return this.a;
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    public boolean[] getIssuerUID() {
        if (this.c == null) {
            return null;
        }
        String string = this.c.toString(2);
        return Util.toBooleanArray(string);
    }

    public void setIssuerUID(boolean[] blArray) {
        if (blArray != null) {
            this.c = new BigInteger(Util.fromBooleanArray(blArray), 2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssuerSerial)) {
            return false;
        }
        IssuerSerial issuerSerial = (IssuerSerial)object;
        if (!this.a.equals(issuerSerial.a)) {
            return false;
        }
        if (this.b.compareTo(issuerSerial.b) != 0) {
            return false;
        }
        if (this.c != null && issuerSerial.c != null) {
            return this.c.compareTo(issuerSerial.c) == 0;
        }
        return this.c == null && issuerSerial.c == null;
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.equals(new IssuerSerial(x509Certificate));
    }

    public int hashCode() {
        int n2 = this.a.hashCode() + this.b.hashCode();
        if (this.c != null) {
            n2 += this.c.hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Issuer: " + this.a + "\n");
        stringBuffer.append("SerialNumber: " + this.b);
        if (this.c != null) {
            stringBuffer.append("\nIssuerUID: " + this.c);
        }
        return stringBuffer.toString();
    }
}

