/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.ObjectDigestInfo;
import iaik.x509.attr.Target;

public class TargetCert
extends Target {
    private IssuerSerial a;
    private GeneralName b;
    private ObjectDigestInfo c;

    TargetCert() {
    }

    public TargetCert(IssuerSerial issuerSerial) {
        if (issuerSerial == null) {
            throw new NullPointerException("Target certificate issuer and serial number must not be null.");
        }
        this.a = issuerSerial;
    }

    public TargetCert(ASN1Object aSN1Object) throws CodingException {
        super(aSN1Object);
    }

    public int getType() {
        return 2;
    }

    protected String getTypeAsString() {
        return "TargetCert";
    }

    public IssuerSerial getTargetCertificate() {
        return this.a;
    }

    public void setTargetName(GeneralName generalName) {
        this.b = generalName;
    }

    public GeneralName getTargetName() {
        return this.b;
    }

    public void setCertDigestInfo(ObjectDigestInfo objectDigestInfo) {
        this.c = objectDigestInfo;
    }

    public ObjectDigestInfo getCertDigestInfo() {
        return this.c;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof TargetCert) {
            TargetCert targetCert = (TargetCert)object;
            try {
                bl = CryptoUtils.equalsBlock(DerCoder.encode(this.toASN1Object()), DerCoder.encode(targetCert.toASN1Object()));
            }
            catch (CodingException codingException) {
                bl = false;
            }
        }
        return bl;
    }

    public int hashCode() {
        return super.hashCode() + this.a.hashCode();
    }

    public void decodeUnTaggedASN1Object(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 target cert. Expected SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 3) {
            throw new CodingException("Invalid number (" + n2 + ") of components in ASN.1 target certificate. Expected 1, 2 od 3!");
        }
        this.a = new IssuerSerial(aSN1Object.getComponentAt(0));
        for (int i2 = 1; i2 < n2; ++i2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (!aSN1Object2.isA(ASN.SEQUENCE)) {
                this.b = new GeneralName(aSN1Object2);
                continue;
            }
            this.c = new ObjectDigestInfo(aSN1Object2);
        }
    }

    public ASN1Object toUnTaggedASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a.toASN1Object());
        if (this.b != null) {
            sEQUENCE.addComponent(this.b.toASN1Object());
        }
        if (this.c != null) {
            sEQUENCE.addComponent(this.c.toASN1Object());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(": {\n  targetCertificate: {\n");
        Util.printIndented(this.a.toString(), true, "    ", stringBuffer);
        stringBuffer.append("\n  }");
        if (this.b != null) {
            stringBuffer.append("\n  targetName: {\n");
            Util.printIndented(this.b.toString(), true, "    ", stringBuffer);
            stringBuffer.append(":\n  }");
        }
        if (this.c != null) {
            stringBuffer.append("\n  certDigestInfo: {\n");
            Util.printIndented(this.c.toString(), true, "    ", stringBuffer);
            stringBuffer.append(":\n  }");
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }
}

