/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralNames;
import iaik.utils.Util;
import java.util.Enumeration;
import java.util.Vector;

public abstract class IetfAttrSyntax
extends AttributeValue {
    private GeneralNames a;
    private ASN b;
    private boolean c;
    private Vector d;

    protected IetfAttrSyntax(boolean bl) {
        this.c = bl;
        this.d = new Vector();
    }

    protected IetfAttrSyntax(byte[][] byArray, boolean bl) throws IllegalArgumentException {
        this(bl);
        if (byArray == null) {
            throw new NullPointerException("values must not be null");
        }
        if (!this.c && byArray.length > 1) {
            throw new IllegalArgumentException("Only one value allowed!");
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == null) continue;
            this.d.addElement(new OCTET_STRING(byArray[i2]));
        }
        if (this.d.size() > 0) {
            this.b = ASN.OCTET_STRING;
        }
    }

    protected IetfAttrSyntax(String[] stringArray, boolean bl) throws IllegalArgumentException {
        this(bl);
        if (stringArray == null) {
            throw new NullPointerException("values must not be null");
        }
        if (!this.c && stringArray.length > 1) {
            throw new IllegalArgumentException("Only one value allowed!");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) continue;
            this.d.addElement(new UTF8String(stringArray[i2]));
        }
        if (this.d.size() > 0) {
            this.b = ASN.UTF8String;
        }
    }

    protected IetfAttrSyntax(ObjectID[] objectIDArray, boolean bl) throws IllegalArgumentException {
        this(bl);
        if (objectIDArray == null) {
            throw new NullPointerException("values must not be null");
        }
        if (!this.c && objectIDArray.length > 1) {
            throw new IllegalArgumentException("Only one value allowed!");
        }
        for (int i2 = 0; i2 < objectIDArray.length; ++i2) {
            if (objectIDArray[i2] == null) continue;
            this.d.addElement(objectIDArray[i2]);
        }
        if (this.d.size() > 0) {
            this.b = ASN.ObjectID;
        }
    }

    protected IetfAttrSyntax(ASN1Object aSN1Object) throws CodingException {
        this(true);
        this.decode(aSN1Object);
    }

    public boolean containsValue(Object object) {
        boolean bl = false;
        Object object2 = null;
        if (this.b != null) {
            if (this.b == ASN.OCTET_STRING) {
                if (object instanceof byte[]) {
                    object2 = new OCTET_STRING((byte[])object);
                }
            } else if (this.b == ASN.ObjectID) {
                if (object instanceof ObjectID) {
                    object2 = object;
                }
            } else if (this.b == ASN.UTF8String && object instanceof String) {
                object2 = new UTF8String((String)object);
            }
            if (object2 != null) {
                bl = this.d.contains(object2);
            }
        }
        return bl;
    }

    public ASN getASN1TypeOfValues() {
        return this.b;
    }

    public Enumeration getValues() {
        Enumeration enumeration = this.d.elements();
        if (this.d.size() == 0) {
            return enumeration;
        }
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof ObjectID) {
                vector.addElement(e2);
                continue;
            }
            vector.addElement(((ASN1Object)e2).getValue());
        }
        return vector.elements();
    }

    public int numberOfValues() {
        return this.d.size();
    }

    public GeneralNames getPolicyAuthority() {
        return this.a;
    }

    public void setPolicyAuthority(GeneralNames generalNames) {
        this.a = generalNames;
    }

    private void a(ASN1Object aSN1Object) throws IllegalArgumentException {
        ASN aSN = aSN1Object.getAsnType();
        if (this.b != null) {
            if (!aSN.equals(this.b)) {
                throw new IllegalArgumentException("Invalid ASN1 type: " + aSN.getName() + "Expected " + this.b.getName() + "!");
            }
        } else {
            if (!(aSN.equals(ASN.OCTET_STRING) || aSN.equals(ASN.ObjectID) || aSN.equals(ASN.UTF8String))) {
                throw new IllegalArgumentException("Invalid ASN1 type: " + aSN.getName() + "Expected OCTET_STRING, ObjectID or UTF8String!");
            }
            this.b = aSN;
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse null ASN1Object!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type: " + aSN1Object.getAsnType().getName() + ". Expected SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 == 0) {
            throw new CodingException("Invalid IetfAttrSyntax. Must not be empty!");
        }
        if (n2 > 2) {
            throw new CodingException("Invalid number of components: " + n2 + ". Only up to 2 allowed.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (aSN1Object2.isA(ASN.CON_SPEC)) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                this.a = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                continue;
            }
            if (aSN1Object2.isA(ASN.SEQUENCE)) {
                for (int i3 = 0; i3 < aSN1Object2.countComponents(); ++i3) {
                    ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(i3);
                    this.a(aSN1Object3);
                    this.d.addElement(aSN1Object3);
                }
                continue;
            }
            throw new CodingException("Invalid ASN.1 type: " + aSN1Object2.getAsnType().getName() + ". Expected CON_SPEC or SEQUENCE!");
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.a.toASN1Object(), true));
        }
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        Enumeration enumeration = this.d.elements();
        while (enumeration.hasMoreElements()) {
            sEQUENCE2.addComponent((ASN1Object)enumeration.nextElement());
        }
        sEQUENCE.addComponent(sEQUENCE2);
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("policyAuthority: {\n");
            Util.printIndented(this.a.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}\n");
        }
        if (this.d != null) {
            stringBuffer.append("values: {\n");
            Enumeration enumeration = this.d.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                if (++n2 > 1) {
                    stringBuffer.append("\n");
                }
                Util.printIndented(enumeration.nextElement().toString(), true, stringBuffer);
            }
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }
}

