/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class PolicyConstraints
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_PolicyConstraints;
    int a = -1;
    int b = -1;

    public ASN1Object toASN1Object() {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != -1) {
            sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a), bl));
        }
        if (this.b != -1) {
            sEQUENCE.addComponent(new CON_SPEC(1, new INTEGER(this.b), bl));
        }
        return sEQUENCE;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new X509ExtensionException("PolicyConstraints has to be a SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 > 2) {
                throw new X509ExtensionException("PolicyConstraints cannot have more than 2 components!");
            }
            block6: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
                if (cON_SPEC.isImplicitlyTagged()) {
                    cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
                }
                switch (cON_SPEC.getAsnType().getTag()) {
                    case 0: {
                        this.a = ((BigInteger)((ASN1Object)cON_SPEC.getValue()).getValue()).intValue();
                        continue block6;
                    }
                    case 1: {
                        this.b = ((BigInteger)((ASN1Object)cON_SPEC.getValue()).getValue()).intValue();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.toString());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void setRequireExplicitPolicy(int n2) {
        this.a = n2;
    }

    public void setInhibitPolicyMapping(int n2) {
        this.b = n2;
    }

    public void setInhibitExplicitPolicy(int n2) {
        this.setInhibitPolicyMapping(n2);
    }

    public int getRequireExplicitPolicy() {
        return this.a;
    }

    public int getInhibitPolicyMapping() {
        return this.b;
    }

    public int getInhibitExplicitPolicy() {
        return this.getInhibitPolicyMapping();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != -1) {
            stringBuffer.append("require explicit policy: " + this.a + "\n");
        }
        if (this.b != -1) {
            stringBuffer.append("inhibit policy mapping: " + this.b + "\n");
        }
        if (stringBuffer.length() >= 1) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

