/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class CertID {
    byte[] a;
    byte[] b;
    AlgorithmID c;
    BigInteger d;

    public CertID(AlgorithmID algorithmID, byte[] byArray, byte[] byArray2, BigInteger bigInteger) {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerNameHash!");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerKeyHash!");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing serialNumber!");
        }
        this.c = algorithmID;
        this.a = byArray;
        this.b = byArray2;
        this.d = bigInteger;
    }

    public CertID(AlgorithmID algorithmID, Name name, PublicKey publicKey, BigInteger bigInteger) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerName!");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerKey!");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing serialNumber!");
        }
        try {
            this.c = algorithmID;
            this.a = CertID.calculateIssuerNameHash(name, algorithmID);
            this.b = CertID.calculateIssuerKeyHash(publicKey, algorithmID);
            this.d = bigInteger;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create CertID. Invalid key encoding format: " + codingException.getMessage());
        }
    }

    public CertID(AlgorithmID algorithmID, X509Certificate x509Certificate, BigInteger bigInteger) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerCert!");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing serialNumber!");
        }
        try {
            this.c = algorithmID;
            this.a = CertID.calculateIssuerNameHash((Name)x509Certificate.getSubjectDN(), algorithmID);
            this.b = CertID.calculateIssuerKeyHash(x509Certificate.getPublicKey(), algorithmID);
            this.d = bigInteger;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create CertID. Invalid key encoding format: " + codingException.getMessage());
        }
    }

    public CertID(AlgorithmID algorithmID, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing hash algorithm!");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing issuerCert!");
        }
        if (x509Certificate2 == null) {
            throw new IllegalArgumentException("Cannot create CertID. Missing targetCert!");
        }
        try {
            this.c = algorithmID;
            this.a = CertID.calculateIssuerNameHash((Name)x509Certificate.getSubjectDN(), algorithmID);
            this.b = CertID.calculateIssuerKeyHash(x509Certificate.getPublicKey(), algorithmID);
            this.d = x509Certificate2.getSerialNumber();
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create CertID. Invalid key encoding format: " + codingException.getMessage());
        }
    }

    public CertID(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public AlgorithmID getHashAlgorithm() {
        return this.c;
    }

    public byte[] getIssuerNameHash() {
        return this.a;
    }

    public byte[] getIssuerKeyHash() {
        return this.b;
    }

    public BigInteger getSerialNumber() {
        return this.d;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.a));
        sEQUENCE.addComponent(new OCTET_STRING(this.b));
        sEQUENCE.addComponent(new INTEGER(this.d));
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        this.c = new AlgorithmID(aSN1Object.getComponentAt(0));
        if (this.c == null) {
            throw new CodingException("Cannot create CertID. Missing hash algorithm!");
        }
        this.a = (byte[])aSN1Object.getComponentAt(1).getValue();
        if (this.a == null) {
            throw new CodingException("Cannot create CertID. Missing issuerNameHash!");
        }
        this.b = (byte[])aSN1Object.getComponentAt(2).getValue();
        if (this.b == null) {
            throw new CodingException("Cannot create CertID. Missing issuerKeyHash!");
        }
        this.d = (BigInteger)aSN1Object.getComponentAt(3).getValue();
        if (this.d == null) {
            throw new CodingException("Cannot create CertID. Missing serialNumber!");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertID)) {
            return false;
        }
        CertID certID = (CertID)object;
        return this.c.equals(certID.c) && CryptoUtils.equalsBlock(this.a, certID.a) && CryptoUtils.equalsBlock(this.b, certID.b) && this.d.equals(certID.d);
    }

    public int hashCode() {
        return this.c.hashCode() + Util.calculateHashCode(this.a) + Util.calculateHashCode(this.b) + this.d.hashCode();
    }

    public boolean isCertIDFor(Name name, PublicKey publicKey, BigInteger bigInteger) throws NoSuchAlgorithmException {
        return this.equals(new CertID((AlgorithmID)this.c.clone(), name, publicKey, bigInteger));
    }

    public String toString() {
        return "hashAlgorithm: " + this.c + "\n" + "issuerNameHash: " + Util.toString(this.a) + "\n" + "issuerKeyHash: " + Util.toString(this.b) + "\n" + "serialNumber: " + this.d;
    }

    public static byte[] calculateIssuerNameHash(Name name, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        messageDigest.update(name.getEncoded());
        return messageDigest.digest();
    }

    public static byte[] calculateIssuerKeyHash(PublicKey publicKey, AlgorithmID algorithmID) throws NoSuchAlgorithmException, CodingException {
        byte[] byArray = publicKey.getEncoded();
        ASN1Object aSN1Object = DerCoder.decode(byArray);
        BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object.getComponentAt(1);
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        messageDigest.update((byte[])bIT_STRING.getValue());
        return messageDigest.digest();
    }
}

