/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.NULL;
import iaik.utils.InternalErrorException;
import iaik.x509.ocsp.RevokedInfo;
import iaik.x509.ocsp.UnknownInfo;

public class CertStatus {
    public static final int GOOD = 0;
    public static final int REVOKED = 1;
    public static final int UNKNOWN = 2;
    int a;
    RevokedInfo b;
    UnknownInfo c;

    public CertStatus() {
        this.a = 0;
    }

    public CertStatus(RevokedInfo revokedInfo) {
        if (revokedInfo == null) {
            throw new IllegalArgumentException("Cannot create revoked CertStatus. Missing RevokedInfo!");
        }
        this.a = 1;
        this.b = revokedInfo;
    }

    public CertStatus(UnknownInfo unknownInfo) {
        this.a = 2;
        if (unknownInfo == null) {
            unknownInfo = new UnknownInfo();
        }
        this.c = unknownInfo;
    }

    public CertStatus(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public int getCertStatus() {
        return this.a;
    }

    public String getCertStatusName() {
        String string;
        switch (this.a) {
            case 0: {
                string = "good";
                break;
            }
            case 1: {
                string = "revoked";
                break;
            }
            case 2: {
                string = "unknown";
                break;
            }
            default: {
                string = "undefined cert status: " + this.a;
            }
        }
        return string;
    }

    public RevokedInfo getRevokedInfo() {
        return this.b;
    }

    public UnknownInfo getUnknownInfo() {
        return this.c;
    }

    public ASN1Object toASN1Object() {
        switch (this.a) {
            case 0: {
                return new CON_SPEC(0, new NULL(), true);
            }
            case 1: {
                return new CON_SPEC(1, this.b.toASN1Object(), true);
            }
            case 2: {
                return new CON_SPEC(2, this.c.toASN1Object(), true);
            }
        }
        return null;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.a = cON_SPEC.getAsnType().getTag();
        switch (this.a) {
            case 0: {
                break;
            }
            case 1: {
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                this.b = new RevokedInfo((ASN1Object)cON_SPEC.getValue());
                break;
            }
            case 2: {
                boolean bl = false;
                if (cON_SPEC.countComponents() == 1) {
                    if (cON_SPEC.getComponentAt(0).getAsnType().equals(ASN.ENUMERATED)) {
                        bl = true;
                    }
                } else {
                    Object object = cON_SPEC.getValue();
                    if (object instanceof byte[] && ((byte[])object).length > 0) {
                        cON_SPEC.forceImplicitlyTagged(ASN.ENUMERATED);
                        bl = true;
                    }
                }
                if (!bl) {
                    cON_SPEC.forceImplicitlyTagged(ASN.NULL);
                }
                this.c = new UnknownInfo((ASN1Object)cON_SPEC.getValue());
                break;
            }
            default: {
                throw new CodingException("Unsupported cert status. Invalid tag:" + this.a);
            }
        }
    }

    public String toString() {
        switch (this.a) {
            case 0: {
                return "good";
            }
            case 1: {
                return "Revoked: " + this.b;
            }
            case 2: {
                return "unknown " + this.c;
            }
        }
        throw new InternalErrorException("Unsupported cert status: " + this.a);
    }
}

