/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.AuthorityInfoAccess;

public class ServiceLocator
extends V3Extension {
    public static final ObjectID oid = ObjectID.ocspExt_ServiceLocator;
    private Name a;
    private AuthorityInfoAccess b;

    public ServiceLocator() {
    }

    public ServiceLocator(Name name) {
        this.a = name;
    }

    public void setIssuer(Name name) {
        this.a = name;
    }

    public Name getIssuer() {
        return this.a;
    }

    public void setLocator(AuthorityInfoAccess authorityInfoAccess) {
        this.b = authorityInfoAccess;
    }

    public AuthorityInfoAccess getLocator() {
        return this.b;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            this.a = new Name(aSN1Object.getComponentAt(0));
            if (this.a == null) {
                throw new X509ExtensionException("Cannot create ServiceLocator. Missing issuer!");
            }
            if (aSN1Object.countComponents() == 2) {
                this.b = new AuthorityInfoAccess();
                this.b.init(aSN1Object.getComponentAt(1));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        if (this.a == null) {
            throw new X509ExtensionException("Cannot create ASN.1 object. Missing issuer!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a.toASN1Object());
        if (this.b != null) {
            sEQUENCE.addComponent(this.b.toASN1Object());
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("issuer: " + this.a);
        if (this.b != null) {
            stringBuffer.append("\nlocator: " + this.b);
        }
        return stringBuffer.toString();
    }
}

