/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.utils;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.IssuingDistributionPoint;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.ocsp.BasicOCSPResponse;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.CertStatus;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.Request;
import iaik.x509.ocsp.ResponderID;
import iaik.x509.ocsp.Response;
import iaik.x509.ocsp.RevokedInfo;
import iaik.x509.ocsp.SingleResponse;
import iaik.x509.ocsp.UnknownInfo;
import iaik.x509.ocsp.extensions.CrlID;
import iaik.x509.ocsp.extensions.Nonce;
import iaik.x509.ocsp.extensions.ServiceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ResponseGenerator {
    private PrintWriter a = null;
    private int b = 0;
    private PrivateKey c;
    private X509Certificate[] d;
    private Vector e = new Vector();
    private Vector f = new Vector();
    private boolean g = false;

    ResponseGenerator() {
    }

    public ResponseGenerator(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this();
        if (privateKey == null) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder key!");
        }
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder certs!");
        }
        this.c = privateKey;
        this.d = x509CertificateArray;
        this.g = this.a(x509CertificateArray[0]);
    }

    public ResponseGenerator(PKCS12 pKCS12, char[] cArray) throws PKCSException {
        this();
        if (!pKCS12.verify(cArray)) {
            throw new PKCSException("Verification error!");
        }
        pKCS12.decrypt(cArray);
        KeyBag keyBag = pKCS12.getKeyBag();
        this.c = keyBag.getPrivateKey();
        CertificateBag[] certificateBagArray = pKCS12.getCertificateBags();
        Certificate[] certificateArray = CertificateBag.getCertificates(certificateBagArray);
        try {
            this.d = Util.convertCertificateChain(certificateArray);
        }
        catch (Exception exception) {
            throw new PKCSException("Error reading certificates: " + exception.getMessage());
        }
        this.d = Util.arrangeCertificateChain(this.d, false);
        if (this.d == null) {
            throw new PKCSException("Cannot sort certificates included in PKCS#12 object!");
        }
        if (this.c == null) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder key!");
        }
        if (this.d == null || this.d.length < 1) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder certs!");
        }
        this.g = this.a(this.d[0]);
    }

    private boolean a(X509Certificate x509Certificate) {
        ExtendedKeyUsage extendedKeyUsage = null;
        try {
            extendedKeyUsage = (ExtendedKeyUsage)x509Certificate.getExtension(ExtendedKeyUsage.oid);
            if (extendedKeyUsage != null) {
                ObjectID[] objectIDArray = extendedKeyUsage.getKeyPurposeIDs();
                for (int i2 = 0; i2 < objectIDArray.length; ++i2) {
                    if (!objectIDArray[i2].equals(ExtendedKeyUsage.ocspSigning)) continue;
                    this.a("Responder cert is allowed to sign OCSP responses (ExtendenKeyUsage purpose ocspSigning is set).");
                    return true;
                }
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            // empty catch block
        }
        return false;
    }

    public PrivateKey getResponderKey() {
        return this.c;
    }

    public X509Certificate[] getResponderCertificates() {
        return this.d;
    }

    public void addResponseEntry(ReqCert reqCert, CertStatus certStatus, Date date, Date date2) {
        SingleResponse singleResponse = new SingleResponse(reqCert, certStatus, date);
        if (date2 != null) {
            singleResponse.setNextUpdate(date2);
        }
        this.addResponseEntry(singleResponse);
    }

    public void addResponseEntry(SingleResponse singleResponse) {
        int n2 = this.e.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SingleResponse singleResponse2 = (SingleResponse)this.e.elementAt(i2);
            if (!singleResponse2.isResponseFor(singleResponse.getReqCert())) continue;
            this.e.setElementAt(singleResponse, i2);
            return;
        }
        this.e.addElement(singleResponse);
    }

    public void addResponseEntries(X509CRL x509CRL, X509Certificate x509Certificate, int n2) throws OCSPException, SignatureException {
        this.addResponseEntries(x509CRL, x509Certificate, n2, null);
    }

    public void addResponseEntries(X509CRL x509CRL, X509Certificate x509Certificate, int n2, CrlID crlID) throws OCSPException, SignatureException {
        Object[] objectArray;
        if (n2 < 0 || n2 > 2) {
            throw new OCSPException("Invalid reqCertType (" + n2 + ")! Only can create " + "responses for ReqCert types certID or issuerSerial from crl!");
        }
        if (x509CRL == null) {
            throw new IllegalArgumentException("Cannot create entries from a null CRL!");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create entries from CRL; missing crl issuer cert!");
        }
        this.a("Verifying crl with issuer key!");
        try {
            x509CRL.verify(x509Certificate.getPublicKey());
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying crl: " + exception.getMessage());
        }
        this.addCertificateIssuer((Name)x509Certificate.getSubjectDN());
        boolean bl = false;
        try {
            objectArray = (Object[])x509CRL.getExtension(IssuingDistributionPoint.oid);
            if (objectArray != null && objectArray.getIndirectCRL()) {
                bl = true;
                this.a("Indirect CRL!");
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            // empty catch block
        }
        if (!bl && !((Object)this.d[0].getSubjectDN()).equals(x509CRL.getIssuerDN())) {
            this.a("No indirect crl but crl issuer different from ocsp response signer.");
            if (!this.g) {
                throw new OCSPException("Cannot create response entries for this crl. CRL issuer is different from response signer which is not allowed for OCSP signing!");
            }
            this.a("Responder is allowed to sign OCSP responses.");
            if (!((Object)this.d[0].getIssuerDN()).equals(x509CRL.getIssuerDN())) {
                throw new OCSPException("Cannot create response entries for this crl. Responder is allowed to sign OCSP responses, but not by the authorized by the CRL issuer!");
            }
            this.a("Responder is authorized from crl issuer.");
        }
        if (!bl) {
            this.a("Create response entries for non indirect crl...");
            objectArray = x509CRL.getRevokedCertificates().toArray();
            RevokedCertificate revokedCertificate = null;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    revokedCertificate = (RevokedCertificate)objectArray[i2];
                    SingleResponse singleResponse = ResponseGenerator.a(revokedCertificate, x509Certificate.getPublicKey(), (Name)x509Certificate.getSubjectDN(), x509CRL.getThisUpdate(), x509CRL.getNextUpdate(), n2);
                    if (crlID != null) {
                        singleResponse.setCrlID(crlID);
                    }
                    this.addResponseEntry(singleResponse);
                    continue;
                }
                catch (Exception exception) {
                    throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber() + ": " + exception.getMessage());
                }
            }
        } else {
            this.a("Create response entries for indirect crl...");
            objectArray = x509CRL.getRevokedCertificates().toArray();
            RevokedCertificate revokedCertificate = null;
            Name name = (Name)x509Certificate.getSubjectDN();
            boolean bl2 = true;
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                Object object;
                revokedCertificate = (RevokedCertificate)objectArray[i3];
                try {
                    object = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
                    if (object != null) {
                        this.a("Entry number " + i3 + " contains certificate issuer extension.");
                        GeneralNames generalNames = ((CertificateIssuer)object).getIssuer();
                        Enumeration enumeration = generalNames.getNames();
                        GeneralName generalName = (GeneralName)enumeration.nextElement();
                        if (generalName.getType() != 4) {
                            throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber() + ": " + "CertificateIssuer is not a directoryName!");
                        }
                        name = (Name)generalName.getName();
                        bl2 = true;
                    }
                }
                catch (X509ExtensionException x509ExtensionException) {
                    // empty catch block
                }
                if (bl2) {
                    if (!(name.equals(this.d[0].getSubjectDN()) || name.equals(this.d[0].getIssuerDN()) && this.g)) {
                        throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber() + ": " + "responder not authorized for signing this entry!");
                    }
                    this.addCertificateIssuer(name);
                    bl2 = false;
                }
                try {
                    object = ResponseGenerator.a(revokedCertificate, null, name, x509CRL.getThisUpdate(), x509CRL.getNextUpdate(), 1);
                    if (crlID != null) {
                        ((SingleResponse)object).setCrlID(crlID);
                    }
                    this.addResponseEntry((SingleResponse)object);
                    continue;
                }
                catch (Exception exception) {
                    throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber());
                }
            }
        }
    }

    private static SingleResponse a(RevokedCertificate revokedCertificate, PublicKey publicKey, Name name, Date date, Date date2, int n2) throws Exception {
        Object object;
        Object object2;
        RevokedInfo revokedInfo = new RevokedInfo(revokedCertificate.getRevocationDate());
        try {
            object2 = (ReasonCode)revokedCertificate.getExtension(ReasonCode.oid);
            if (object2 != null) {
                revokedInfo.setRevocationReason((ReasonCode)object2);
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            // empty catch block
        }
        object2 = new CertStatus(revokedInfo);
        ReqCert reqCert = null;
        if (n2 == 0) {
            object = new CertID(AlgorithmID.sha1, name, publicKey, revokedCertificate.getSerialNumber());
            reqCert = new ReqCert(0, object);
        } else {
            reqCert = new ReqCert(1, new IssuerAndSerialNumber(name, revokedCertificate.getSerialNumber()));
        }
        object = new SingleResponse(reqCert, (CertStatus)object2, date);
        if (date2 != null) {
            ((SingleResponse)object).setNextUpdate(date2);
        }
        return object;
    }

    public Enumeration getSingleResponses() {
        return this.e.elements();
    }

    public SingleResponse getSingleResponse(ReqCert reqCert) {
        Enumeration enumeration = this.e.elements();
        while (enumeration.hasMoreElements()) {
            SingleResponse singleResponse = (SingleResponse)enumeration.nextElement();
            if (!singleResponse.isResponseFor(reqCert)) continue;
            return singleResponse;
        }
        return null;
    }

    public SingleResponse removeSingleResponse(ReqCert reqCert) {
        Enumeration enumeration = this.e.elements();
        while (enumeration.hasMoreElements()) {
            SingleResponse singleResponse = (SingleResponse)enumeration.nextElement();
            if (!singleResponse.isResponseFor(reqCert) || !this.e.removeElement(singleResponse)) continue;
            return singleResponse;
        }
        return null;
    }

    public void removeAllSingleResponses() {
        this.e.removeAllElements();
    }

    public void addCertificateIssuer(Name name) {
        int n2 = this.f.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!name.equals(this.f.elementAt(i2))) continue;
            return;
        }
        this.f.addElement(name);
    }

    public boolean removeCertificateIssuer(Name name) {
        return this.f.removeElement(name);
    }

    public void removeAllCertIssuers() {
        this.f.removeAllElements();
    }

    public SingleResponse getSingleResponse(Request request) {
        return this.a(request, -1, -1);
    }

    private SingleResponse a(Request request, int n2, int n3) {
        CertStatus certStatus;
        Object object;
        Object object2;
        try {
            object2 = request.getServiceLocator();
            if (object2 != null) {
                this.a("Request contains the ServiceLocator extension with issuer " + ((ServiceLocator)object2).getIssuer() + ".", n2, n3);
                object = ((ServiceLocator)object2).getIssuer();
                if (!((Name)object).equals(this.d[0].getSubjectDN())) {
                    this.a("Service Locator does not reference this reponder: sending unknown response.", n2, n3);
                    return new SingleResponse(request.getReqCert(), new CertStatus(new UnknownInfo()), new Date());
                }
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            // empty catch block
        }
        object2 = this.e.elements();
        while (object2.hasMoreElements()) {
            object = (SingleResponse)object2.nextElement();
            if (!((SingleResponse)object).isResponseFor(request.getReqCert())) continue;
            this.a("Cached response detected.", n2, n3);
            this.a("Status of response is: " + ((SingleResponse)object).getCertStatus());
            return object;
        }
        this.a("No single response cached. Creating new...", n2, n3);
        this.a("Searching for authorized issuer...", n2, n3);
        object = request.getReqCert();
        if (this.a((ReqCert)object)) {
            certStatus = new CertStatus();
            this.a("Authorized issuer found. CertStatus good.", n2, n3);
        } else {
            certStatus = new CertStatus(new UnknownInfo());
            this.a("No authorized issuer found. CertStatus unknown.", n2, n3);
        }
        return new SingleResponse((ReqCert)object, certStatus, new Date());
    }

    private boolean a(ReqCert reqCert) {
        int n2 = reqCert.getType();
        Name name = null;
        Enumeration enumeration = null;
        try {
            block1 : switch (n2) {
                case 0: {
                    CertID certID = (CertID)reqCert.getReqCert();
                    byte[] byArray = certID.getIssuerNameHash();
                    Name name2 = (Name)this.d[0].getSubjectDN();
                    byte[] byArray2 = CertID.calculateIssuerNameHash(name2, certID.getHashAlgorithm());
                    if (CryptoUtils.equalsBlock(byArray, byArray2)) {
                        return true;
                    }
                    name2 = (Name)this.d[0].getIssuerDN();
                    byArray2 = CertID.calculateIssuerNameHash(name2, certID.getHashAlgorithm());
                    if (CryptoUtils.equalsBlock(byArray, byArray2) && this.g) {
                        return true;
                    }
                    enumeration = this.f.elements();
                    while (enumeration.hasMoreElements()) {
                        Name name3 = (Name)enumeration.nextElement();
                        byArray2 = CertID.calculateIssuerNameHash(name3, certID.getHashAlgorithm());
                        if (!CryptoUtils.equalsBlock(byArray, byArray2)) continue;
                        name = name3;
                        break block1;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    Name name4 = ResponseGenerator.a(reqCert.getReqCert());
                    if (name4.equals(this.d[0].getSubjectDN())) {
                        return true;
                    }
                    if (name4.equals(this.d[0].getIssuerDN()) && this.g) {
                        return true;
                    }
                    enumeration = this.f.elements();
                    while (enumeration.hasMoreElements()) {
                        Name name5 = (Name)enumeration.nextElement();
                        if (!name4.equals(name5)) continue;
                        name = name5;
                        break block1;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name != null) {
            if (name.equals(this.d[0].getSubjectDN())) {
                return true;
            }
            if (!name.equals(this.d[0].getIssuerDN())) {
                return false;
            }
            if (this.g) {
                return true;
            }
        }
        return false;
    }

    private static Name a(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            return ((IssuerAndSerialNumber)object).getIssuer();
        }
        if (object instanceof X509Certificate) {
            return (Name)((X509Certificate)object).getIssuerDN();
        }
        return null;
    }

    public OCSPResponse createOCSPResponse(InputStream inputStream, PublicKey publicKey, AlgorithmID algorithmID, V3Extension[] v3ExtensionArray) {
        Object object;
        Object object2;
        int n2;
        OCSPRequest oCSPRequest;
        OCSPResponse oCSPResponse;
        int n3;
        block34: {
            n3 = -1;
            if (this.a != null) {
                n3 = ++this.b;
            }
            oCSPResponse = null;
            oCSPRequest = null;
            n2 = 0;
            this.a("Parsing request...", n3);
            try {
                oCSPRequest = new OCSPRequest(inputStream);
                if (oCSPRequest.containsSignature()) {
                    this.a("Request is signed.", n3);
                    boolean bl = false;
                    if (publicKey != null) {
                        this.a("Verifying signature with using supplied requestor key.", n3);
                        try {
                            oCSPRequest.verify(publicKey);
                            bl = true;
                            this.a("Signature ok", n3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!bl && oCSPRequest.containsCertificates()) {
                        this.a("Verifying signature with included signer cert...", n3);
                        X509Certificate x509Certificate = oCSPRequest.verify();
                        this.a("Signature ok from request signer " + x509Certificate.getSubjectDN(), n3);
                        bl = true;
                    }
                    if (!bl) {
                        this.a("Request signed but cannot verify signature since missing signer key. Sending malformed request!", n3);
                        n2 = 1;
                    }
                    break block34;
                }
                this.a("Unsigned request!", n3);
            }
            catch (IOException iOException) {
                this.a("Encoding error; sending malformedRequest " + iOException.getMessage(), n3);
                n2 = 1;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.a("Cannot verify; sending internalError: " + noSuchAlgorithmException.getMessage(), n3);
                n2 = 2;
            }
            catch (OCSPException oCSPException) {
                this.a("Included certs do not belong to signer; sending malformedRequest : " + oCSPException.getMessage(), n3);
                n2 = 1;
            }
            catch (InvalidKeyException invalidKeyException) {
                this.a("Signer key invalid; sending malformedRequest : " + invalidKeyException.getMessage(), n3);
                n2 = 1;
            }
            catch (SignatureException signatureException) {
                this.a("Signature verification error; sending malformedRequest : " + signatureException.getMessage(), n3);
                n2 = 1;
            }
            catch (Exception exception) {
                if (this.a != null) {
                    exception.printStackTrace();
                }
                this.a("Some error occured during request parsing/verification; sending tryLater " + exception.getMessage(), n3);
                n2 = 3;
            }
        }
        if (n2 != 0) {
            oCSPResponse = new OCSPResponse(n2);
            return oCSPResponse;
        }
        try {
            object2 = oCSPRequest.getAccepatableResponseTypes();
            if (object2 != null && ((ObjectID[])object2).length > 0) {
                boolean bl = false;
                for (int i2 = 0; i2 < ((ObjectID[])object2).length; ++i2) {
                    if (!object2[i2].equals(BasicOCSPResponse.responseType)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.a("Warning! Client does not support basic response type. Using it anyway...", n3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a("Create successful response.", n3);
        oCSPResponse = new OCSPResponse(0);
        object2 = new BasicOCSPResponse();
        try {
            object = new ResponderID((Name)this.d[0].getSubjectDN());
            ((BasicOCSPResponse)object2).setResponderID((ResponderID)object);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Date date = gregorianCalendar.getTime();
            ((BasicOCSPResponse)object2).setProducedAt(date);
            this.a("Processing requests...", n3);
            Request[] requestArray = oCSPRequest.getRequestList();
            SingleResponse[] singleResponseArray = new SingleResponse[requestArray.length];
            for (int i3 = 0; i3 < requestArray.length; ++i3) {
                this.a("Processing Request No. " + (i3 + 1), n3);
                singleResponseArray[i3] = this.a(requestArray[i3], n3, i3 + 1);
            }
            ((BasicOCSPResponse)object2).setSingleResponses(singleResponseArray);
        }
        catch (Exception exception) {
            if (this.a != null) {
                exception.printStackTrace();
            }
            this.a("Some error occured; sending tryLater " + exception.getMessage(), n3);
            return new OCSPResponse(3);
        }
        try {
            object = (Nonce)oCSPRequest.getExtension(Nonce.oid);
            if (object != null) {
                this.a("Nonce included in request. Copy into response.", n3);
                ((BasicOCSPResponse)object2).addExtension((V3Extension)object);
            }
        }
        catch (Exception exception) {
            this.a("Error in setting Nonce for response (ignore this): " + exception.getMessage(), n3);
        }
        if (v3ExtensionArray != null) {
            for (int i4 = 0; i4 < v3ExtensionArray.length; ++i4) {
                this.a("Adding extension " + v3ExtensionArray[i4].getName(), n3);
                try {
                    ((BasicOCSPResponse)object2).addExtension(v3ExtensionArray[i4]);
                    continue;
                }
                catch (Exception exception) {
                    this.a("Cannot add extension " + v3ExtensionArray[i4].getName() + ", ignore this", n3);
                }
            }
        }
        this.a("Sign response.", n3);
        ((BasicOCSPResponse)object2).setCertificates(this.d);
        try {
            ((BasicOCSPResponse)object2).sign(algorithmID, this.c);
        }
        catch (Exception exception) {
            this.a("Error signing response: " + exception.getMessage(), n3);
            this.a("Send tryLater response", n3);
            return new OCSPResponse(3);
        }
        oCSPResponse.setResponse((Response)object2);
        return oCSPResponse;
    }

    public void init(InputStream inputStream) throws IOException {
        try {
            Cloneable cloneable;
            this.e.removeAllElements();
            this.f.removeAllElements();
            ASN1 aSN1 = new ASN1(inputStream);
            byte[] byArray = aSN1.getFirstObject();
            ASN1Object aSN1Object = aSN1.getComponentAt(0);
            ResponderID responderID = new ResponderID(aSN1Object.getComponentAt(0));
            if (!responderID.isResponderIdFor(this.d[0])) {
                throw new IOException("Initialization failed. Response not created by this generator!");
            }
            for (int i2 = 1; i2 < aSN1Object.countComponents(); ++i2) {
                cloneable = aSN1Object.getComponentAt(i2);
                if (!((ASN1Object)cloneable).isA(ASN.CON_SPEC)) {
                    for (int i3 = 0; i3 < ((ASN1Object)cloneable).countComponents(); ++i3) {
                        this.f.addElement(new Name(((ASN1Object)cloneable).getComponentAt(i3)));
                    }
                    continue;
                }
                SEQUENCE sEQUENCE = (SEQUENCE)((ASN1Object)cloneable).getValue();
                for (int i4 = 0; i4 < sEQUENCE.countComponents(); ++i4) {
                    this.e.addElement(new SingleResponse(sEQUENCE.getComponentAt(i4)));
                }
            }
            byte[] byArray2 = (byte[])aSN1.getComponentAt(1).getValue();
            cloneable = AlgorithmID.sha1WithRSAEncryption;
            if (!(this.c instanceof RSAPrivateKey)) {
                if (this.c instanceof DSAPrivateKey) {
                    cloneable = AlgorithmID.dsa;
                } else {
                    throw new IOException("Cannot verify basic response. Unknown key algorithm: " + this.c.getAlgorithm());
                }
            }
            Signature signature = ((AlgorithmID)cloneable).getSignatureInstance();
            signature.initVerify(this.d[0].getPublicKey());
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new IOException("Cannot init generator. Signture verification error!");
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            Cloneable cloneable;
            Object object;
            SEQUENCE sEQUENCE = new SEQUENCE();
            ResponderID responderID = new ResponderID((Name)this.d[0].getSubjectDN());
            sEQUENCE.addComponent(responderID.toASN1Object());
            if (this.f.size() > 0) {
                object = this.f.elements();
                cloneable = new SEQUENCE();
                while (object.hasMoreElements()) {
                    ((ConstructedType)cloneable).addComponent(((Name)object.nextElement()).toASN1Object());
                }
                sEQUENCE.addComponent((ASN1Object)cloneable);
            }
            if (this.e.size() > 0) {
                object = this.e.elements();
                cloneable = new SEQUENCE();
                while (object.hasMoreElements()) {
                    ((ConstructedType)cloneable).addComponent(((SingleResponse)object.nextElement()).toASN1Object());
                }
                sEQUENCE.addComponent(new CON_SPEC(0, (ASN1Object)cloneable));
            }
            object = new ASN1(sEQUENCE);
            cloneable = AlgorithmID.sha1WithRSAEncryption;
            if (!(this.c instanceof RSAPrivateKey)) {
                if (this.c instanceof DSAPrivateKey) {
                    cloneable = AlgorithmID.dsa;
                } else {
                    throw new IOException("Cannot sign basic response. Unknown key algorithm: " + this.c.getAlgorithm());
                }
            }
            Signature signature = ((AlgorithmID)cloneable).getSignatureInstance();
            signature.initSign(this.c);
            signature.update(((ASN1)object).toByteArray());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(((ASN1)object).toASN1Object());
            sEQUENCE2.addComponent(new BIT_STRING(signature.sign()));
            DerCoder.encodeTo(sEQUENCE2, outputStream);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void printDebug(boolean bl) {
        if (bl) {
            this.setDebugStream(System.out);
        } else {
            this.setDebugStream(null);
        }
    }

    public void setDebugStream(OutputStream outputStream) {
        this.a = outputStream == null ? null : new PrintWriter(outputStream, true);
    }

    private void a(String string) {
        this.a(string, -1, -1);
    }

    private void a(String string, int n2) {
        if (this.a != null) {
            this.a.println("(rg_debug" + (n2 > 0 ? " " + n2 + ") " : ") ") + string);
        }
    }

    private void a(String string, int n2, int n3) {
        if (this.a != null) {
            this.a.println("(rg_debug" + (n2 > 0 ? " " + n2 + "_" + n3 + ") " : ") ") + string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Responder: " + this.d[0].getSubjectDN() + "\n");
        stringBuffer.append("Cert Issuers: " + this.f.size() + "\n");
        stringBuffer.append("Cached responses: " + this.e.size());
        return stringBuffer.toString();
    }
}

