/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.stream;

import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.Name;
import iaik.x509.RevokedCertificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509Extensions;
import iaik.x509.stream.CRLListener;
import iaik.x509.stream.RevokedCertificatesCRLListener;
import iaik.x509.stream.a;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.util.Date;

public class X509CRLStream {
    private CRLListener a;
    private InputStream b;
    private byte[] c;
    private int d;

    public X509CRLStream(CRLListener cRLListener) {
        this.a = cRLListener;
    }

    public void parse(InputStream inputStream) throws IOException, CRLException {
        boolean bl;
        a a2 = new a(inputStream);
        a2.a(false);
        DerInputStream derInputStream = new DerInputStream(a2);
        if (derInputStream.nextTag() != 16) {
            throw new CRLException("Invalid CRL. CRL is not a SEQUENCE.");
        }
        DerInputStream derInputStream2 = derInputStream.readSequence();
        a2.a(true);
        if (derInputStream2.nextTag() != 16) {
            throw new CRLException("Invalid CRL. tbsCertList TBSCertList (SEQUENCE) expected.");
        }
        DerInputStream derInputStream3 = derInputStream2.readSequence();
        this.a(derInputStream3, a2);
        a2.a(false);
        AlgorithmID algorithmID = new AlgorithmID(derInputStream2);
        if (derInputStream2.nextTag() != 3) {
            throw new CRLException("Invalid CRL. signatureValue BIT STRING expected.");
        }
        byte[] byArray = (byte[])derInputStream2.readBitString().getValue();
        Signature signature = a2.a();
        if (signature != null) {
            try {
                bl = signature.verify(byArray);
            }
            catch (SignatureException signatureException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        this.a.signature(algorithmID, byArray, bl);
        inputStream.close();
    }

    public CRLListener getListener() {
        return this.a;
    }

    void a(DerInputStream derInputStream, a a2) throws IOException, CRLException {
        try {
            Object object;
            int n2 = derInputStream.nextTag() == 2 ? derInputStream.readInteger().intValue() : -1;
            AlgorithmID algorithmID = new AlgorithmID(derInputStream);
            Signature signature = this.a.getSignature(algorithmID);
            if (signature != null) {
                a2.a(signature);
            } else {
                a2.a(false);
            }
            Name name = new Name(DerCoder.decode(derInputStream));
            Date date = new ChoiceOfTime(DerCoder.decode(derInputStream)).getDate();
            int n3 = derInputStream.nextTag();
            Date date2 = n3 == 23 || n3 == 24 ? new ChoiceOfTime(DerCoder.decode(derInputStream)).getDate() : null;
            this.a.header(n2, name, date, date2);
            if (derInputStream.nextTag() == 16) {
                object = derInputStream.readSequence();
                this.a((DerInputStream)object);
            }
            if (derInputStream.nextIsContextSpecific()) {
                DerInputStream derInputStream2 = derInputStream.readContextSpecific();
                object = new X509Extensions(DerCoder.decode(derInputStream2));
            } else {
                object = null;
            }
            this.a.extensions((X509Extensions)object);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CRLException(noSuchAlgorithmException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CRLException(invalidKeyException.toString());
        }
        catch (SignatureException signatureException) {
            throw new CRLException(signatureException.toString());
        }
    }

    void a(DerInputStream derInputStream) throws IOException, CRLException {
        block13: {
            try {
                if (this.a instanceof RevokedCertificatesCRLListener) {
                    RevokedCertificatesCRLListener revokedCertificatesCRLListener = (RevokedCertificatesCRLListener)this.a;
                    this.a((InputStream)derInputStream);
                    while (true) {
                        this.a();
                        int n2 = this.f();
                        if (n2 == -1) {
                            break block13;
                        }
                        if (n2 != 48) {
                            throw new CRLException("Invalid CRL entry that is not a SEQUENCE.");
                        }
                        int n3 = this.g();
                        int n4 = this.b();
                        n2 = this.f();
                        if (n2 == -1) {
                            throw new EOFException("Unexpected EOF in entry! Expected an INTEGER.");
                        }
                        if (n2 != 2) {
                            throw new CRLException("Invalid CRL entry, which does not start with an INTEGER.");
                        }
                        int n5 = this.g();
                        int n6 = this.b();
                        this.a(n3 - (n6 - n4));
                        revokedCertificatesCRLListener.revokedCertificate(this.c(), 0, n4 + n3, n6, n5);
                    }
                }
                while (derInputStream.nextTag() != -1) {
                    RevokedCertificate revokedCertificate = new RevokedCertificate(DerCoder.decode(derInputStream));
                    this.a.revokedCertificate(revokedCertificate);
                }
            }
            catch (CodingException codingException) {
                throw new CRLException(codingException.toString());
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new CRLException(x509ExtensionException.toString());
            }
            finally {
                this.a((InputStream)null);
            }
        }
    }

    private void a(InputStream inputStream) {
        this.b = inputStream;
        this.c = inputStream != null ? new byte[128] : null;
    }

    private void a() {
        this.d = 0;
    }

    private int b() {
        return this.d;
    }

    private byte[] c() {
        return this.c;
    }

    private int d() throws IOException {
        int n2 = this.b.read();
        if (n2 != -1) {
            if (this.d >= this.c.length) {
                this.e();
            }
            this.c[this.d++] = (byte)n2;
        }
        return n2;
    }

    private void e() {
        byte[] byArray = new byte[2 * this.c.length];
        System.arraycopy(this.c, 0, byArray, 0, this.d);
        this.c = byArray;
    }

    private void a(int n2) throws EOFException, IOException {
        while (n2 > this.c.length - this.d) {
            this.e();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.b.read(this.c, this.d, n2 - n3);
            if (n4 < 0) {
                throw new EOFException("Unexpected EOF while reading data.");
            }
            n3 += n4;
            this.d += n4;
        }
    }

    private int f() throws IOException {
        return this.d();
    }

    private int g() throws EOFException, IOException, CodingException {
        int n2 = this.d();
        if (n2 == -1) {
            throw new EOFException("Unexpected EOF! Expected encoded length.");
        }
        if ((n2 &= 0xFF) < 128) {
            return n2;
        }
        if (n2 == 128) {
            throw new CodingException("Invalid DER encoding. Indefinite length encoding is not allowed.");
        }
        if ((n2 &= 0x7F) > 4) {
            throw new CodingException("Encoded length is too large. Takes " + n2 + " octets. Maximum is 4.");
        }
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = this.d();
            if (n4 == -1) {
                throw new EOFException("Unexpected EOF! Expected a length octet.");
            }
            n3 = n3 << 8 | n4 & 0xFF;
        }
        return n3;
    }
}

