/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.dom.DOMNodeSetData;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.dsig.DigestValueImpl;
import iaik.xml.crypto.dsig.ReferenceType;
import iaik.xml.crypto.dsig.TransformsImpl;
import iaik.xml.crypto.dsig.j;
import iaik.xml.crypto.dsig.k;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.Debug;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceImpl
extends ReferenceType
implements DOMURIReference,
Reference {
    protected DigestMethodImpl digestMethod_;
    protected DigestValueImpl digestValue_;
    protected byte[] calculatedDigestValue_;
    protected boolean valid_ = true;
    protected List distNS_ = null;

    public ReferenceImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.digestMethod_ == null || this.digestValue_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    protected ReferenceImpl(String string, TransformsImpl transformsImpl, String string2, String string3) {
        super(string, transformsImpl, string2, string3);
    }

    public ReferenceImpl(String string, DigestMethodImpl digestMethodImpl, List list, String string2, String string3) {
        super(string, list, string2, string3);
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null");
        }
        this.digestMethod_ = digestMethodImpl;
        this.digestValue_ = new DigestValueImpl();
    }

    public ReferenceImpl(String string, DigestMethodImpl digestMethodImpl, List list, String string2, String string3, byte[] byArray) {
        super(string, list, string2, string3);
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        this.digestMethod_ = digestMethodImpl;
        if (byArray == null) {
            throw new NullPointerException("Argument 'digestValue' must not be null.");
        }
        this.digestValue_ = new DigestValueImpl(byArray);
        this.calculatedDigestValue_ = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.calculatedDigestValue_, 0, byArray.length);
        this.valid_ = true;
    }

    public ReferenceImpl(String string, DigestMethodImpl digestMethodImpl, List list, Data data, List list2, String string2, String string3) {
        super(string, list, data, list2, string2, string3);
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        this.digestMethod_ = digestMethodImpl;
        this.digestValue_ = new DigestValueImpl();
        if (this.result_ instanceof NodeSetData) {
            Iterator iterator = ((NodeSetData)this.result_).iterator();
            if (!iterator.hasNext()) {
                throw new NullPointerException("The supplied result does not contain any Nodes");
            }
            Node node = (Node)iterator.next();
            Node node2 = node;
            if (node2.getNodeType() != 1) {
                node2 = node2.getParentNode();
            }
            this.distNS_ = DOMUtils.distributeNSDeclarations((Element)node2);
            this.result_ = new DOMNodeSetData(new j(this, node, iterator));
        }
        this.digestValue_ = new k(this);
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod_;
    }

    public byte[] getDigestValue() {
        return this.digestValue_ != null ? this.digestValue_.getDigestValue() : null;
    }

    public byte[] getCalculatedDigestValue() {
        return this.calculatedDigestValue_;
    }

    public InputStream getDigestInputStream() {
        return this.cachedDigestInput_ == null ? null : new ByteArrayInputStream(this.cachedDigestInput_.getCachedBytes());
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.digestMethod_ != null) {
            list.add(this.digestMethod_);
        }
        if (this.digestValue_ != null) {
            list.add(this.digestValue_);
        }
        return list;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof DigestMethod) {
            this.digestMethod_ = (DigestMethodImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof DigestValueImpl) {
            this.digestValue_ = (DigestValueImpl)dOMStructure;
            return;
        }
    }

    public void generateReference(DOMCryptoContext dOMCryptoContext) throws MarshalException, XMLSignatureException {
        if (Boolean.TRUE.equals(dOMCryptoContext.getProperty("iaik.xml.crypto.dsig.sign-over")) && dOMCryptoContext instanceof DOMSignContext) {
            this.digestValue_.value_ = null;
        }
        if (this.digestValue_.getDigestValue() == null) {
            InputStream inputStream;
            try {
                inputStream = this.dereferenceAndCanonicalize(dOMCryptoContext);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
            catch (TransformException transformException) {
                throw new XMLSignatureException(transformException);
            }
            catch (URIReferenceException uRIReferenceException) {
                throw new XMLSignatureException(uRIReferenceException);
            }
            try {
                byte[] byArray = this.digestMethod_.calculateDigestValue(inputStream);
                this.digestValue_.appendValue(dOMCryptoContext, byArray);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException(iOException);
            }
        }
    }

    public void setPreCalculatedDigestValue(DOMCryptoContext dOMCryptoContext, byte[] byArray) throws MarshalException, XMLSignatureException {
        if (dOMCryptoContext instanceof DOMValidateContext) {
            throw new XMLSignatureException("Setting pre calculated digest value is only allowed for signature creation");
        }
        if (this.digestValue_ == null) {
            throw new MarshalException("Unable add digest value to reference.");
        }
        this.digestValue_.appendValue(dOMCryptoContext, byArray);
    }

    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (xMLValidateContext == null) {
            throw new NullPointerException("Argument 'validateContext' must not be null");
        }
        List list = null;
        if (this.result_ == null && this.calculatedDigestValue_ == null) {
            list = DOMUtils.distributeNSDeclarations((Element)this.getNode());
        }
        this.validateReference(xMLValidateContext);
        if (list != null) {
            DOMUtils.withdrawDistributedNSDeclarations((Element)this.getNode(), list);
        } else if (this.distNS_ != null && !this.distNS_.isEmpty()) {
            DOMUtils.withdrawDistributedNSDeclarations((Element)this.getNode(), list);
            OutputStreamWriter outputStreamWriter = Debug.getOutputStreamWriterFrom(xMLValidateContext);
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.write("\n Had to apply the tree model workaround for supplied NodeSetData.\n");
                    outputStreamWriter.flush();
                }
                catch (IOException iOException) {
                    Debug.topLevelLog("Failed to write to debug output stream. " + iOException.getMessage());
                }
            }
        }
        return this.valid_;
    }

    public boolean validateReference(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        Closeable closeable;
        if (this.calculatedDigestValue_ == null) {
            try {
                closeable = this.dereferenceAndCanonicalize(xMLValidateContext);
                this.calculatedDigestValue_ = this.digestMethod_.calculateDigestValue((InputStream)closeable);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException(iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
            catch (TransformException transformException) {
                throw new XMLSignatureException(transformException);
            }
            catch (URIReferenceException uRIReferenceException) {
                throw new XMLSignatureException(uRIReferenceException);
            }
        }
        this.valid_ = Arrays.equals(this.digestValue_.getDigestValue(), this.calculatedDigestValue_);
        if (!this.valid_ && (closeable = Debug.getOutputStreamWriterFrom(xMLValidateContext)) != null) {
            try {
                ((Writer)closeable).write("Digest values do not match\n");
                ((Writer)closeable).write("DigestValue:\t " + DOMUtils.bytesToBase64String(this.getDigestValue(), null) + "\n");
                ((Writer)closeable).write("CalculatedValue: " + DOMUtils.bytesToBase64String(this.getCalculatedDigestValue(), null) + "\n\n");
                ((OutputStreamWriter)closeable).flush();
            }
            catch (IOException iOException) {
                Debug.topLevelLog("Failed to write to debug output stream. " + iOException.getMessage());
            }
        }
        return this.valid_;
    }
}

