/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSAKeyValueImpl
extends KeyValueType {
    public DSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.publicKey_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public DSAKeyValueImpl(DSAPublicKey dSAPublicKey) {
        super(dSAPublicKey);
    }

    public String getLocalName() {
        return "DSAKeyValue";
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Object object;
        BigInteger bigInteger;
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.publicKey_;
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams != null) {
            Element element;
            Object object2;
            bigInteger = dSAParams.getP();
            object = dSAParams.getQ();
            if (bigInteger != null && object != null) {
                object2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DSAKeyValueImpl.getQualifiedName(string, "P"));
                element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DSAKeyValueImpl.getQualifiedName(string, "Q"));
                DSAKeyValueImpl.addBytesToElement((Element)object2, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
                DSAKeyValueImpl.addBytesToElement(element, DOMUtils.bigInteger2byteArray((BigInteger)object), dOMCryptoContext);
                node3.appendChild((Node)object2);
                node3.appendChild(element);
            }
            if ((object2 = dSAParams.getG()) != null) {
                element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DSAKeyValueImpl.getQualifiedName(string, "G"));
                DSAKeyValueImpl.addBytesToElement(element, DOMUtils.bigInteger2byteArray((BigInteger)object2), dOMCryptoContext);
                node3.appendChild(element);
            }
        }
        bigInteger = dSAPublicKey.getY();
        object = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DSAKeyValueImpl.getQualifiedName(string, "Y"));
        DSAKeyValueImpl.addBytesToElement((Element)object, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
        node3.appendChild((Node)object);
        return node3;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (nodeList == null) {
            return;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            object = nodeList.item(i2);
            if (object.getNodeType() != 1 || !object.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            if (object.getLocalName().equals("P")) {
                bigInteger = new BigInteger(1, DSAKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (object.getLocalName().equals("Q")) {
                bigInteger2 = new BigInteger(1, DSAKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (object.getLocalName().equals("G")) {
                bigInteger3 = new BigInteger(1, DSAKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (!object.getLocalName().equals("Y")) continue;
            bigInteger4 = new BigInteger(1, DSAKeyValueImpl.getBytesFromElement((Element)object));
        }
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
        try {
            object = KeyFactory.getInstance("DSA");
            this.publicKey_ = (DSAPublicKey)((KeyFactory)object).generatePublic(dSAPublicKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to create DSA key.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MarshalException("Failed to create DSA key.");
        }
    }
}

