/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dom.XencDOMStructure;
import iaik.xml.crypto.enc.CipherDataImpl;
import iaik.xml.crypto.enc.CipherReferenceImpl;
import iaik.xml.crypto.enc.CipherValueImpl;
import iaik.xml.crypto.enc.EncryptionMethodImpl;
import iaik.xml.crypto.utils.DOMUtils;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import java.util.List;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.enc.CipherData;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class EncryptedTypeImpl
extends XencDOMStructure
implements EncryptedType {
    protected Provider provider_;
    protected EncryptionMethodImpl encryptionMethod_;
    protected KeyInfo keyInfo_;
    protected CipherDataImpl cipherData_;
    protected EncryptionProperties encryptionProperties_;
    protected String id_;
    protected String type_;
    protected String mimeType_;
    protected String encoding_;
    protected KeySelectorResult keySelectorResult_;
    protected ToBeEncrypted tbe_;

    protected EncryptedTypeImpl() {
    }

    protected EncryptedTypeImpl(Node node) throws MarshalException {
        super(node);
    }

    protected EncryptedTypeImpl(ToBeEncrypted toBeEncrypted, EncryptionMethodImpl encryptionMethodImpl, KeyInfo keyInfo, EncryptionProperties encryptionProperties, String string, CipherReferenceImpl cipherReferenceImpl) {
        if (toBeEncrypted == null) {
            throw new NullPointerException("The argument 'toBeEncrypted' must not be null.");
        }
        this.tbe_ = toBeEncrypted;
        this.encryptionMethod_ = encryptionMethodImpl;
        this.keyInfo_ = keyInfo;
        this.encryptionProperties_ = encryptionProperties;
        this.id_ = string;
        this.cipherData_ = cipherReferenceImpl != null ? new CipherDataImpl(cipherReferenceImpl) : new CipherDataImpl(new CipherValueImpl());
        this.type_ = this.tbe_.getType();
        this.mimeType_ = this.tbe_.getMimeType();
        this.encoding_ = this.tbe_.getEncoding();
    }

    public CipherData getCipherData() {
        return this.cipherData_.getCipherData();
    }

    public InputStream getCipherText() throws IllegalStateException {
        return this.cipherData_.getCipherText();
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod_;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.encryptionProperties_;
    }

    public String getId() {
        return this.id_;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo_;
    }

    public String getMimeType() {
        return this.mimeType_;
    }

    public ToBeEncrypted getToBeEncrypted() {
        return this.tbe_;
    }

    public String getType() {
        return this.type_;
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.encryptionMethod_ != null) {
            list.add(this.encryptionMethod_);
        }
        if (this.keyInfo_ != null) {
            list.add(this.keyInfo_);
        }
        if (this.cipherData_ != null) {
            list.add(this.cipherData_);
        }
        if (this.encryptionProperties_ != null) {
            list.add(this.encryptionProperties_);
        }
        return list;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        Attr attr;
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        if (this.type_ != null) {
            attr = document.createAttributeNS("", "Type");
            attr.setValue(this.type_);
            element.setAttributeNodeNS(attr);
        }
        if (this.mimeType_ != null) {
            attr = document.createAttributeNS("", "MimeType");
            attr.setValue(this.mimeType_);
            element.setAttributeNodeNS(attr);
        }
        if (this.encoding_ != null) {
            attr = document.createAttributeNS("", "Encoding");
            attr.setValue(this.encoding_);
            element.setAttributeNodeNS(attr);
        }
    }

    protected Attr marshalIDAttribute(DOMCryptoContext dOMCryptoContext, Element element) {
        Attr attr = super.marshalIDAttribute(dOMCryptoContext, element);
        if (this.id_ != null) {
            attr = element.getOwnerDocument().createAttributeNS("", "Id");
            attr.setValue(this.id_);
            return attr;
        }
        return null;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof EncryptionMethodImpl) {
            this.encryptionMethod_ = (EncryptionMethodImpl)dOMStructure;
        }
        if (dOMStructure instanceof KeyInfo) {
            this.keyInfo_ = (KeyInfo)((Object)dOMStructure);
        }
        if (dOMStructure instanceof CipherDataImpl) {
            this.cipherData_ = (CipherDataImpl)dOMStructure;
        }
        if (dOMStructure instanceof EncryptionProperties) {
            this.encryptionProperties_ = (EncryptionProperties)((Object)dOMStructure);
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Attr attr;
        Attr attr2;
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        this.id_ = this.unmarshalIDAttribute(namedNodeMap, dOMCryptoContext, "Id");
        Attr attr3 = (Attr)namedNodeMap.getNamedItemNS(null, "Type");
        if (attr3 != null) {
            this.type_ = attr3.getValue();
        }
        if ((attr2 = (Attr)namedNodeMap.getNamedItemNS(null, "MimeType")) != null) {
            this.mimeType_ = attr2.getValue();
        }
        if ((attr = (Attr)namedNodeMap.getNamedItemNS(null, "Encoding")) != null) {
            this.encoding_ = attr.getValue();
        }
    }

    public InputStream decrypt(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        Key key = this.selectKey(xMLDecryptContext, true);
        InputStream inputStream = this.cipherData_.getCipherData(xMLDecryptContext);
        return this.encryptionMethod_.decrypt(key, inputStream);
    }

    protected Key selectKey(XMLCryptoContext xMLCryptoContext, boolean bl) throws XMLEncryptionException {
        KeySelector keySelector = xMLCryptoContext.getKeySelector();
        if (keySelector == null) {
            throw new XMLEncryptionException("Failed to select key. No KeySelector provided in XMLCryptoContext.");
        }
        try {
            this.keySelectorResult_ = keySelector.select(this.keyInfo_, bl ? KeySelector.Purpose.ENCRYPT : KeySelector.Purpose.DECRYPT, this.encryptionMethod_, xMLCryptoContext);
        }
        catch (KeySelectorException keySelectorException) {
            throw new XMLEncryptionException("Failed to select key. " + keySelectorException.getMessage(), keySelectorException);
        }
        if (this.keySelectorResult_ == null) {
            throw new XMLEncryptionException("Failed to select key. KeySelector returned 'null'.");
        }
        Key key = this.keySelectorResult_.getKey();
        if (key == null) {
            throw new XMLEncryptionException("Failed to select key. KeySelector returned no valid key.");
        }
        return key;
    }
}

