/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dom.DOMNodeSetData;
import iaik.xml.crypto.utils.g;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import org.w3c.dom.Node;

public class Debug {
    public static final String SYS_ERR = "System.err".intern();
    public static final String SYS_OUT = "System.out".intern();
    public static final String TOP_LEVEL_LOG_PROP = "iaik.xml.crypto.utils.Debug.TOP_LEVEL_LOG".intern();
    public static String TOP_LEVEL_LOG = null;

    public static Data data(Data data, OutputStream outputStream) throws IOException {
        if (data instanceof OctetStreamData) {
            OctetStreamData octetStreamData = (OctetStreamData)data;
            return new OctetStreamData(Debug.inputStream(octetStreamData.getOctetStream(), outputStream), octetStreamData.getURI(), octetStreamData.getMimeType());
        }
        if (data instanceof NodeSetData) {
            return new DOMNodeSetData(Debug.nodeIterator(((NodeSetData)data).iterator(), outputStream));
        }
        return data;
    }

    public static Iterator nodeIterator(Iterator iterator, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write("------------------------------ NodeSetData -------------------------------\n");
        outputStreamWriter.flush();
        int n2 = 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            arrayList.add(node);
            outputStreamWriter.write("Node " + ++n2 + " : " + node.toString() + "\n");
        }
        outputStreamWriter.write("--------------------------------------------------------------------------\n");
        outputStreamWriter.flush();
        return arrayList.iterator();
    }

    public static InputStream inputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write("--------------------------- OctetStreamData ------------------------------\n");
        outputStreamWriter.flush();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            outputStream.write(byArray, 0, n2);
        }
        outputStreamWriter.write("\n--------------------------------------------------------------------------\n");
        outputStreamWriter.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static InputStream inputStreamCopyAdapter(InputStream inputStream, OutputStream outputStream) throws IOException {
        return new g(inputStream, outputStream);
    }

    public static OutputStream getOutputStreamFrom(XMLCryptoContext xMLCryptoContext) {
        Object object = xMLCryptoContext.getProperty("iaik.xml.crypto.debug.OutputStream");
        return object instanceof OutputStream ? (OutputStream)object : null;
    }

    public static OutputStreamWriter getOutputStreamWriterFrom(XMLCryptoContext xMLCryptoContext) {
        Object object = xMLCryptoContext.getProperty("iaik.xml.crypto.debug.OutputStream");
        if (object instanceof OutputStreamWriter) {
            return (OutputStreamWriter)object;
        }
        if (object instanceof OutputStream) {
            return new OutputStreamWriter((OutputStream)object);
        }
        return null;
    }

    public static void topLevelLog(Object object) {
        Debug.topLevelLog(new Object[]{object});
    }

    public static void topLevelLog(Object[] objectArray) {
        PrintStream printStream;
        String string = TOP_LEVEL_LOG = TOP_LEVEL_LOG != null ? TOP_LEVEL_LOG : XSecProvider.getSysProperty(TOP_LEVEL_LOG_PROP, SYS_ERR);
        if (SYS_ERR.equals(TOP_LEVEL_LOG)) {
            printStream = System.err;
        } else if (SYS_OUT.equals(TOP_LEVEL_LOG)) {
            printStream = System.out;
        } else {
            if ("".equals(TOP_LEVEL_LOG)) {
                return;
            }
            try {
                printStream = (PrintStream)Class.forName(TOP_LEVEL_LOG).getConstructor(null).newInstance(null);
            }
            catch (Throwable throwable) {
                System.err.println("Problem with " + TOP_LEVEL_LOG);
                throwable.printStackTrace();
                printStream = null;
                System.exit(1);
            }
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            printStream.print(objectArray[i2].toString());
        }
        printStream.println();
    }
}

