/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSDValidate {
    private static void showHelp() {
        System.out.println("Uso:    java -jar validar-xsd.jar [xsd] [--list/--xml] [documento/lista] [output-msg] [output-warning] [output-error]");
        System.out.println("                                 [--help/--licencia]");
        System.out.println();
        System.out.println("        --help      -h                         Muestra \u00e9sta ayuda");
        System.out.println("        --licencia  -l                         Muestra la licencia del programa");
        System.out.println("        --list      -l    lista                Lista con los documentos a validar, uno debajo de otro");
        System.out.println("        --xml       -x    documento            Documento a validar");
        System.out.println();
        System.out.println("        xsd                                    Esquema a utilizar, \"DEFAULT\" har\u00e1 que se utilice el del documento");
        System.out.println("        output-msg      OPCIONAL               Documento de salida de mensajes, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("        output-warning  OPCIONAL*              Documento de salida de alertas, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("                                               *Opcional s\u00f3lo si output-msg est\u00e1 establecido");
        System.out.println("        output-error    OPCIONAL*              Documento de salida de errores, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("                                               *Opcional s\u00f3lo si output-warning est\u00e1 establecido");
    }

    public static void main(String[] args) throws Exception, CustomException {
        Path file;
        String outputMsg = null;
        String outputWarn = null;
        String startup = "DS-COD versi\u00f3n 1.2.2\nDerechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\nCopyright \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\nDS-COD carece totalmente de garant\u00eda. Este es Software Libre y\nest\u00e1 permitido redistribuirlo bajo ciertas condiciones.\nAgregue \"--licencia\" al comando para m\u00e1s detalles.\n";
        System.out.println(startup);
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        if (Integer.parseInt(version) != 8) {
            System.out.println("Error: Por favor ejecute con java 8");
        }
        String licencia = " Derechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n Este es un Software Libre; como tal redistribuirlo y/o modificarlo est\u00e1\n permitido, siempre y cuando se haga bajo los t\u00e9rminos y condiciones de la\n Licencia P\u00fablica General GNU publicada por la Free Software Foundation,\n ya sea en su versi\u00f3n 2 \u00f3 cualquier otra de las posteriores a la misma.\n\n Este \"Programa\" se distribuye con la intenci\u00f3n de que sea \u00fatil, sin\n embargo carece de garant\u00eda, ni siquiera tiene la garant\u00eda impl\u00edcita de\n tipo comercial o inherente al prop\u00f3sito del mismo \"Programa\". Ver la\n Licencia P\u00fablica General GNU para m\u00e1s detalles.\n\n Se debe haber recibido una copia de la Licencia P\u00fablica General GNU con\n este \"Programa\", si este no fue el caso, favor de escribir a la Free\n Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,\n MA 02110-1301 USA.\n\n Autor: Mart\u00edn Iv\u00e1n R\u00edos\n Correo electr\u00f3nico: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Empresa: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n\n                                  --------------------------------------------------------------\n\n Copyright \u00a9 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n This program is free software; you can redistribute it and/or modify\n it under the terms of the GNU General Public License as published by\n the Free Software Foundation; either version 2 of the License, or\n (at your option) any later version.\n\n This program is distributed in the hope that it will be useful,\n but WITHOUT ANY WARRANTY; without even the implied warranty of\n MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n GNU General Public License for more details.\n\n You should have received a copy of the GNU General Public License along\n with this program; if not, write to the Free Software Foundation, Inc.,\n 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.\n\n Author: Mart\u00edn Iv\u00e1n R\u00edos\n E-mail: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Company: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n";
        if (args.length == 0) {
            XSDValidate.showHelp();
            System.exit(0);
        }
        switch (args[0]) {
            case "--licencia": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-l": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-h": {
                XSDValidate.showHelp();
                System.exit(0);
                break;
            }
            case "--help": {
                XSDValidate.showHelp();
                System.exit(0);
            }
        }
        if (args.length > 5) {
            file = Paths.get(args[5], new String[0]);
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            PrintStream err = new PrintStream(new FileOutputStream(args[5]));
            System.setErr(err);
            List<String> linesTmp = Collections.singletonList("####");
            Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            System.out.println("Errores en " + args[5]);
        }
        if (args.length > 3) {
            outputMsg = args[3];
            file = Paths.get(outputMsg, new String[0]);
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            List<String> linesTmp = Collections.singletonList("####");
            Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            System.out.println("Salida en " + args[3]);
        }
        if (args.length > 4) {
            outputWarn = args[4];
            file = Paths.get(outputWarn, new String[0]);
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            System.out.println("Alertas en " + args[4]);
        }
        String xmlPath = args[2];
        String xsd = args[0];
        switch (args[1]) {
            case "--list": {
                String[] arr;
                if (!xmlPath.contains(".txt")) {
                    throw new CustomException("#### \n" + xmlPath + " no es una lista valida");
                }
                Scanner sc = new Scanner(new File(xmlPath));
                ArrayList<String> docLines = new ArrayList<String>();
                while (sc.hasNextLine()) {
                    docLines.add(sc.nextLine());
                }
                for (String doc : arr = docLines.toArray(new String[0])) {
                    File f = new File(doc);
                    String docName = f.getName();
                    XSDValidate.validate(xsd, doc, docName, outputMsg, outputWarn);
                }
                break;
            }
            case "--xml": {
                if (!xmlPath.contains(".xml")) {
                    throw new CustomException("#### \n" + xmlPath + " no es un xml valido");
                }
                File f = new File(xmlPath);
                String docName = f.getName();
                XSDValidate.validate(xsd, xmlPath, docName, outputMsg, outputWarn);
                break;
            }
            default: {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList("Por favor, use las opciones \"--list\" o \"--xml\" solamente");
                    Path file2 = Paths.get(outputMsg, new String[0]);
                    Files.write(file2, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    break;
                }
                System.out.println("Por favor, use las opciones \"--list\" o \"--xml\" solamente");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void validate(String xsd, String xmlPath, String docName, String outputMsg, String outputWarn) throws Exception, CustomException {
        Path file;
        List<String> lines;
        String xsdPath;
        NodeList nl;
        Document doc;
        DocumentBuilderFactory dbf;
        boolean isDefault;
        block13: {
            isDefault = false;
            if (xsd.equals("DEFAULT")) {
                isDefault = true;
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                doc = dbf.newDocumentBuilder().parse(new FileInputStream(xmlPath));
                nl = doc.getElementsByTagName("ns1:Envelope");
                Element xsdElement = (Element)nl.item(0);
                if (nl.getLength() != 0 || xsdElement != null) {
                    String schemaLocation = xsdElement.getAttributes().getNamedItem("xsi:schemaLocation").getNodeValue();
                    String[] xsdSplited = schemaLocation.split("\\s+");
                    xsdPath = xsdSplited[1];
                    break block13;
                } else {
                    if (outputMsg != null) {
                        List<String> lines2 = Collections.singletonList(docName + ": Esquema no encontrado");
                        Path file2 = Paths.get(outputMsg, new String[0]);
                        Files.write(file2, lines2, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        return;
                    }
                    System.out.println(docName + ": Esquema no encontrado");
                    return;
                }
            }
            xsdPath = xsd;
        }
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        doc = dbf.newDocumentBuilder().parse(new FileInputStream(xmlPath));
        nl = doc.getElementsByTagName("CODVer");
        Element codVer = (Element)nl.item(0);
        if (nl.getLength() == 0) {
            if (codVer == null) throw new CustomException("#### \n" + docName + ": Tag \"CODVer\" no encontrado");
        }
        String codVerStr = codVer.getFirstChild().getNodeValue();
        if (xsdPath != null && !xsdPath.contains(codVerStr)) {
            if (outputWarn != null) {
                List<String> lines3 = Collections.singletonList(docName + ": El esquema dado y el especificado por el documento no concuerdan");
                Path file3 = Paths.get(outputWarn, new String[0]);
                Files.write(file3, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": El esquema dado y el especificado por el documento no concuerdan");
            }
        }
        if (XSDValidate.validateXMLSchema(xsdPath, xmlPath, docName, isDefault, outputMsg)) {
            if (outputMsg != null) {
                lines = isDefault ? Arrays.asList(docName + ": Esquema del documento: " + xsdPath, docName + ": El XML ha pasado la verificaci\u00f3n de esquema") : Arrays.asList(docName + ": Esquema local: " + xsdPath, docName + ": El XML ha pasado la verificaci\u00f3n de esquema");
                file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                return;
            }
            if (isDefault) {
                System.out.println(docName + ": Esquema del documento: " + xsdPath);
                System.out.println(docName + ": El XML ha pasado la verificaci\u00f3n de esquema");
                return;
            }
            System.out.println(docName + ": Esquema local: " + xsdPath);
            System.out.println(docName + ": El XML ha pasado la verificaci\u00f3n de esquema");
            return;
        }
        if (XSDValidate.validateXMLSchema(xsdPath, xmlPath, docName, isDefault, outputMsg)) return;
        if (outputMsg != null) {
            lines = isDefault ? Arrays.asList(docName + ": Esquema del documento: " + xsdPath, docName + ": El XML ha fallando la verificaci\u00f3n de esquema") : Arrays.asList(docName + ": Esquema local: " + xsdPath, docName + ": El XML ha fallando la verificaci\u00f3n de esquema");
            file = Paths.get(outputMsg, new String[0]);
            Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            return;
        }
        if (isDefault) {
            System.out.println(docName + ": Esquema del documento: " + xsdPath);
            System.out.println(docName + ": El XML ha fallando la verificaci\u00f3n de esquema");
            return;
        }
        System.out.println(docName + ": Esquema local: " + xsdPath);
        System.out.println(docName + ": El XML ha fallando la verificaci\u00f3n de esquema");
    }

    private static boolean validateXMLSchema(String xsdPath, String xmlPath, String docName, boolean isDefault, String outputMsg) throws Exception {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = isDefault ? factory.newSchema(new URL(xsdPath)) : factory.newSchema(new File(xsdPath));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new File(xmlPath)));
            return true;
        }
        catch (SAXException e) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": " + e.getMessage());
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(e.getMessage());
            }
            return false;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static class CustomException
    extends Throwable {
        @Override
        public String toString() {
            String s = this.getClass().getName();
            String message = this.getLocalizedMessage();
            return message != null ? message : s;
        }

        CustomException(String message) {
            super(message, null, true, false);
        }
    }
}

