/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RC2CbcParameters;
import iaik.pkcs.pkcs11.parameters.RC2Parameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.RC2ParameterSpec;

public class Rc2Cipher
extends BlockCipher {
    protected static final Mechanism a = Mechanism.get((long)257L);
    protected static Hashtable b;
    protected RC2ParameterSpec D;
    protected boolean E;

    protected Mechanism[] a() {
        if (this.z == null) {
            this.z = new Mechanism[]{Mechanism.get((long)261L), Mechanism.get((long)257L), Mechanism.get((long)258L)};
        }
        return this.z;
    }

    protected void a(Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof RC2SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type RC2SecretKey");
        }
    }

    protected String b() {
        return "RC2";
    }

    protected Hashtable c() {
        if (b == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.get((long)257L));
            hashtable.put("cbc/nopadding", Mechanism.get((long)258L));
            hashtable.put("cbc/pkcs5padding", Mechanism.get((long)261L));
            b = hashtable;
        }
        return b;
    }

    protected Mechanism d() {
        return a;
    }

    protected Mechanism k() {
        if (this.x || this.y || this.E) {
            Mechanism mechanism = null;
            try {
                mechanism = this.l();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (mechanism != null && this.u.equalsIgnoreCase("ecb") && this.D != null) {
                int n = this.D.getEffectiveKeyBits();
                RC2Parameters rC2Parameters = new RC2Parameters((long)n);
                mechanism.setParameters((Parameters)rC2Parameters);
            } else if (mechanism != null && this.u.equalsIgnoreCase("cbc") && this.D != null) {
                int n = this.D.getEffectiveKeyBits();
                byte[] byArray = this.D.getIV();
                RC2CbcParameters rC2CbcParameters = new RC2CbcParameters((long)n, byArray);
                mechanism.setParameters((Parameters)rC2CbcParameters);
            }
            this.o = mechanism;
            this.x = false;
            this.y = false;
            this.E = false;
        }
        return this.o;
    }

    protected int a(int n) {
        int n2 = -1;
        if (n >= 0) {
            n2 = n + 15;
        }
        return n2;
    }

    protected int a(java.security.Key key) {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n = -1;
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof RC2SecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a RC2 secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + key.toString());
        }
        RC2SecretKey rC2SecretKey = (RC2SecretKey)secretKey;
        n = rC2SecretKey.getValueLen().getLongValue().intValue() << 3;
        return n;
    }

    protected int e() {
        return 8;
    }

    protected void a(int n, java.security.Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (n != 1 && n != 2 && n != 4 && n != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n);
        }
        this.n = n;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.l = (IAIKPKCS11SecretKey)key;
        this.m = this.l.getKeyObject();
        this.a(this.m);
        if (this.u.equalsIgnoreCase("ecb")) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof RC2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2ParameterSpec required, but parameterSpecs is: " + algorithmParameterSpec);
            }
            this.D = (RC2ParameterSpec)algorithmParameterSpec;
            this.E = true;
        } else if (this.u.equalsIgnoreCase("cbc")) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof RC2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2ParameterSpec required, but parameterSpecs is: " + algorithmParameterSpec);
            }
            this.D = (RC2ParameterSpec)algorithmParameterSpec;
            this.E = true;
            if (this.D.getIV() == null) {
                throw new InvalidAlgorithmParameterException("Initialization vector required in RC2ParameterSpec in CBC mode, in the given RC2ParameterSpec it is null.");
            }
        }
        this.o = this.k();
        if (this.o == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.u + "/" + this.v);
        }
        this.r();
    }
}

