/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.MacGeneralParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.macs.PKCS11MacSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;

public abstract class PKCS11Mac
extends MacSpi
implements PKCS11EngineClass {
    protected Session b;
    protected TokenManager c;
    protected IAIKPKCS11SecretKey d;
    protected SecretKey e;
    protected boolean f;
    protected boolean g;
    protected boolean h;
    protected byte[] i;
    protected boolean j;
    protected Mac k;
    protected Mechanism[] l;
    protected MechanismInfo[][] m;
    protected PKCS11MacSpec n;
    protected int o;

    protected PKCS11Mac(Mechanism mechanism, int n) {
        this.o = n;
        this.l = new Mechanism[]{mechanism};
    }

    protected PKCS11Mac(Mechanism mechanism, Mechanism mechanism2, int n) {
        this.o = n;
        this.l = new Mechanism[]{mechanism, mechanism2};
    }

    private Mechanism[] m() {
        return this.l;
    }

    protected MechanismInfo[][] b() {
        if (this.m == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setSign(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setVerify(true);
            this.m = new MechanismInfo[this.m().length][2];
            for (int i2 = 0; i2 < this.m().length; ++i2) {
                this.m[i2][0] = mechanismInfo;
                this.m[i2][1] = mechanismInfo2;
            }
        }
        return this.m;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.m();
            MechanismInfo[][] mechanismInfoArray = this.b();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected void a(iaik.pkcs.pkcs11.objects.Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type SecretKey");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal() {
        if (!this.j) return this.c();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.k.doFinal();
    }

    protected byte[] c() {
        this.g();
        byte[] byArray = null;
        try {
            if (!this.h && this.i != null) {
                byArray = this.b.sign(this.i);
            } else {
                byArray = this.b.signFinal();
                this.g = false;
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        finally {
            this.k();
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetMacLength() {
        if (!this.j) return this.d();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.k.getMacLength();
    }

    protected int d() {
        if (null != this.n && 0 <= this.n.a) {
            return this.n.a;
        }
        return this.o;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleMacKey(this.a(), key);
        if (null != algorithmParameterSpec && !(algorithmParameterSpec instanceof PKCS11MacSpec)) {
            throw new InvalidAlgorithmParameterException("Type PKCS11MacSpec is required.");
        }
        if (key instanceof IAIKPKCS11Key) {
            this.a(key, (PKCS11MacSpec)algorithmParameterSpec);
            this.j = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.k == null) {
                this.e();
            }
            this.k.init(key, algorithmParameterSpec);
            this.j = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void e() {
        DelegateProvider delegateProvider = this.c != null ? this.c.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.a();
        this.k = delegateProvider.getMac(string);
        if (this.k == null) {
            throw new IAIKPkcs11Exception("Could not get delegate MAC engine for " + string);
        }
    }

    protected abstract String a();

    protected void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.d = (IAIKPKCS11SecretKey)key;
        this.e = (SecretKey)this.d.getKeyObject();
        this.a((iaik.pkcs.pkcs11.objects.Key)this.e);
        try {
            this.n = (PKCS11MacSpec)algorithmParameterSpec;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidAlgorithmParameterException("must be of type PKCS11MacSpec");
        }
        finally {
            this.l();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineReset() {
        if (this.j) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.k.reset();
            return;
        } else {
            this.f();
        }
    }

    protected void f() {
        if (this.b != null) {
            this.k();
        }
        this.f = true;
        this.h = false;
        this.i = null;
    }

    protected void g() {
        if (!this.f) {
            throw new IllegalStateException("MAC not initialized!");
        }
        if (!this.g) {
            try {
                this.j();
            }
            catch (TokenException tokenException) {
                this.k();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + tokenException.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte by) {
        if (this.j) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.k.update(by);
            return;
        } else {
            this.a(by);
        }
    }

    protected void a(byte by) {
        this.g();
        byte[] byArray = new byte[]{by};
        if (!this.h && this.i == null) {
            this.i = byArray;
        } else {
            try {
                if (this.i != null) {
                    this.b.signUpdate(this.i);
                    this.i = null;
                }
                this.b.signUpdate(byArray);
                this.h = true;
            }
            catch (TokenException tokenException) {
                this.k();
                throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.j) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.k.update(byArray, n, n2);
            return;
        } else {
            this.a(byArray, n, n2);
        }
    }

    protected void a(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        this.g();
        byte[] byArray2 = null;
        if (n == 0 && n2 == byArray.length) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        if (!this.h && this.i == null) {
            this.i = byArray2;
        } else {
            try {
                if (this.i != null) {
                    this.b.signUpdate(this.i);
                    this.i = null;
                }
                this.b.signUpdate(byArray2);
                this.h = true;
            }
            catch (TokenException tokenException) {
                this.k();
                throw new IAIKPkcs11Exception("Error updating MAC: " + (Object)((Object)tokenException));
            }
        }
    }

    protected Mechanism h() {
        if (this.o == this.d()) {
            return (Mechanism)this.l[0].clone();
        }
        Mechanism mechanism = (Mechanism)this.l[1].clone();
        mechanism.setParameters((Parameters)new MacGeneralParameters((long)this.d()));
        return mechanism;
    }

    protected void i() {
        this.c = this.d.getTokenManager();
        try {
            if (this.b == null) {
                this.b = this.c.getSession(false);
            }
            this.c.makeAuthorizedSession(this.b, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void j() {
        this.i();
        this.b.signInit(this.h(), this.d.getKeyObject());
        this.g = true;
        this.h = false;
        this.i = null;
    }

    protected void k() {
        if (this.g) {
            this.g = false;
            this.c.closeSession(this.b);
            this.b = null;
        } else {
            this.g = false;
            this.c.disposeSession(this.b);
            this.b = null;
        }
    }

    protected void l() {
        try {
            this.j();
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException(this.getClass().getName() + ": " + tokenException.toString());
        }
        this.f = true;
        this.h = false;
        this.i = null;
    }

    protected void finalize() {
        if (this.b != null) {
            this.k();
        }
        super.finalize();
    }
}

