/*
 * Decompiled with CFR 0.152.
 */
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.TokenKeyStore;
import iaik.security.provider.IAIK;
import iaik.xml.crypto.XSecProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.xml.bind.DatatypeConverter;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DsCOD {
    static X509Certificate signingCertificate_;
    private static IAIKPkcs11 pkcs11Provider_;
    private static PrivateKey signatureKey_;
    private static String URICOD;
    private static String URICODEH;
    private final int codID = 0;
    private final int codehID = 1;

    public DsCOD(String data, int token, String outputMsg) throws CustomException, IOException {
        if (token == 1) {
            Module module;
            Security.addProvider((Provider)new IAIK());
            Properties pkcs11config = new Properties();
            pkcs11config.put("PKCS11_NATIVE_MODULE", data);
            try {
                module = IAIKPkcs11.getModule((Properties)pkcs11config);
            }
            catch (Exception ignored) {
                throw new CustomException("#### \nNo se puede encontrar el m\u00f3dulo especificado, verifique el archivo de configuraci\u00f3n");
            }
            Slot[] slots = new Slot[]{};
            try {
                slots = module.getSlotList(true);
            }
            catch (TokenException e) {
                e.printStackTrace();
            }
            if (slots.length == 0) {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList("Token no disponible");
                    Path file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println("Token no disponible");
                }
                return;
            }
            Slot selectedSlot = slots[0];
            pkcs11config.put("SLOT_ID", Long.toString(selectedSlot.getSlotID()));
            pkcs11Provider_ = new IAIKPkcs11(pkcs11config);
            Security.addProvider((Provider)pkcs11Provider_);
            XSecProvider xsecProvider = new XSecProvider();
            XSecProvider.setDelegationProvider((String)"Signature.SHA1withRSA", (String)pkcs11Provider_.getName());
            Security.addProvider((Provider)xsecProvider);
        } else if (token == 0) {
            try {
                this.getSignatureFromFile(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void showHelp() {
        System.out.println("Uso:    java -jar firmar.jar [--soft/--token/--help/--licencia]");
        System.out.println("                            [--soft]    [path-al-cert]         [COD/CODEH] [documento] [output] [output-msg] [output-error]");
        System.out.println("                            [--token]   [config-con-dll] [pin] [COD/CODEH] [documento] [output] [output-msg] [output-error]");
        System.out.println();
        System.out.println("        --help     -h                        Muestra \u00e9sta ayuda");
        System.out.println("        --licencia -l                        Muestra la licencia del programa");
        System.out.println("        --soft     -s    path-al-cert        Ubicaci\u00f3n del certificado x509 en formato PEM");
        System.out.println("        --token    -t    conf-con-dll        Ubicaci\u00f3n del programa PKCS#11 (.dll) del Token utilizado");
        System.out.println();
        System.out.println("        COD/CODEH                            Elegir como firmar");
        System.out.println("        pin                                  Contrase\u00f1a del token");
        System.out.println("        documento                            Documento a firmar");
        System.out.println("        output                               Documento de salida");
        System.out.println();
        System.out.println("        output-msg    OPCIONAL               Documento de salida de mensajes, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("        output-error  OPCIONAL*              Documento de salida de errores, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("                                             *Opcional s\u00f3lo si output-msg est\u00e1 establecido");
    }

    public static void main(String[] args) throws Exception, CustomException {
        List<String> lines;
        Path file;
        int isToken = -1;
        String outputMsg = null;
        String startup = "DS-COD versi\u00f3n 1.2.2\nDerechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\nCopyright \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\nDS-COD carece totalmente de garant\u00eda. Este es Software Libre y\nest\u00e1 permitido redistribuirlo bajo ciertas condiciones.\nAgregue \"--licencia\" al comando para m\u00e1s detalles.\n";
        System.out.println(startup);
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        if (Integer.parseInt(version) != 8) {
            System.out.println("Error: Por favor ejecute con java 8");
        }
        String licencia = " Derechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n Este es un Software Libre; como tal redistribuirlo y/o modificarlo est\u00e1\n permitido, siempre y cuando se haga bajo los t\u00e9rminos y condiciones de la\n Licencia P\u00fablica General GNU publicada por la Free Software Foundation,\n ya sea en su versi\u00f3n 2 \u00f3 cualquier otra de las posteriores a la misma.\n\n Este \"Programa\" se distribuye con la intenci\u00f3n de que sea \u00fatil, sin\n embargo carece de garant\u00eda, ni siquiera tiene la garant\u00eda impl\u00edcita de\n tipo comercial o inherente al prop\u00f3sito del mismo \"Programa\". Ver la\n Licencia P\u00fablica General GNU para m\u00e1s detalles.\n\n Se debe haber recibido una copia de la Licencia P\u00fablica General GNU con\n este \"Programa\", si este no fue el caso, favor de escribir a la Free\n Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,\n MA 02110-1301 USA.\n\n Autor: Mart\u00edn Iv\u00e1n R\u00edos\n Correo electr\u00f3nico: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Empresa: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n\n                                  --------------------------------------------------------------\n\n Copyright \u00a9 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n This program is free software; you can redistribute it and/or modify\n it under the terms of the GNU General Public License as published by\n the Free Software Foundation; either version 2 of the License, or\n (at your option) any later version.\n\n This program is distributed in the hope that it will be useful,\n but WITHOUT ANY WARRANTY; without even the implied warranty of\n MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n GNU General Public License for more details.\n\n You should have received a copy of the GNU General Public License along\n with this program; if not, write to the Free Software Foundation, Inc.,\n 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.\n\n Author: Mart\u00edn Iv\u00e1n R\u00edos\n E-mail: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Company: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n";
        if (args.length == 0) {
            DsCOD.showHelp();
            System.exit(0);
        }
        switch (args[0]) {
            case "-s": {
                isToken = 0;
                break;
            }
            case "--soft": {
                isToken = 0;
                break;
            }
            case "-t": {
                isToken = 1;
                break;
            }
            case "--token": {
                isToken = 1;
                break;
            }
            case "--licencia": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-l": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-h": {
                DsCOD.showHelp();
                System.exit(0);
                break;
            }
            case "--help": {
                DsCOD.showHelp();
                System.exit(0);
                break;
            }
            default: {
                DsCOD.showHelp();
                System.exit(0);
            }
        }
        if (isToken == 1) {
            if (args.length < 4) {
                DsCOD.showHelp();
                System.exit(0);
            }
            if (args.length > 7) {
                file = Paths.get(args[7], new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                List<String> linesTmp = Collections.singletonList("####");
                Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                PrintStream err = new PrintStream(new FileOutputStream(args[7]));
                System.setErr(err);
                System.out.println("Errores en " + args[7]);
            }
            if (args.length > 6) {
                outputMsg = args[6];
                file = Paths.get(outputMsg, new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                List<String> linesTmp = Collections.singletonList("####");
                Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                System.out.println("Salida en " + args[6]);
            }
            boolean cod = args[3].equals("COD");
            boolean codeh = args[3].equals("CODEH");
            if (!(!cod && codeh || cod && !codeh)) {
                if (outputMsg != null) {
                    lines = Arrays.asList("No es posible firmar el nodo: " + args[3], "Por favor, use COD o CODEH solamente");
                    Path file2 = Paths.get(outputMsg, new String[0]);
                    Files.write(file2, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    return;
                }
                System.out.println("No es posible firmar el nodo: " + args[3]);
                System.out.println("Por favor, use COD o CODEH solamente");
                return;
            }
            File out = new File(args[5]);
            String dll = new Scanner(new File(args[1])).useDelimiter("\\Z").next();
            if (!args[1].contains(".txt")) {
                throw new CustomException("#### \n" + dll + " no es un archivo de configuraci\u00f3n valido");
            }
            DsCOD.createDir(out);
            File f = new File(args[4]);
            String docName = f.getName();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(args[4]));
            DsCOD genEnvel = new DsCOD(dll, isToken, outputMsg);
            genEnvel.selectSignatureKey(args[2]);
            boolean ERROR = genEnvel.createXmlSignature(args[3], doc, cod, codeh, docName, outputMsg);
            if (!ERROR) {
                genEnvel.writeResult(args, isToken, cod, codeh, doc, docName, outputMsg);
            } else if (outputMsg != null) {
                List<String> lines2 = Collections.singletonList(docName + ": Se ha producido un error al crear la firma");
                Path file3 = Paths.get(outputMsg, new String[0]);
                Files.write(file3, lines2, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": Se ha producido un error al crear la firma");
            }
        } else if (isToken == 0) {
            if (args.length < 3) {
                DsCOD.showHelp();
                System.exit(0);
            }
            if (args.length > 6) {
                file = Paths.get(args[6], new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                List<String> linesTmp = Collections.singletonList("####");
                Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                PrintStream err = new PrintStream(new FileOutputStream(args[6]));
                System.setErr(err);
                System.out.println("Errores en " + args[6]);
            }
            if (args.length > 5) {
                outputMsg = args[5];
                file = Paths.get(outputMsg, new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                List<String> linesTmp = Collections.singletonList("####");
                Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                System.out.println("Salida en " + args[5]);
            }
            boolean cod = args[2].equals("COD");
            boolean codeh = args[2].equals("CODEH");
            if (!(!cod && codeh || cod && !codeh)) {
                if (outputMsg != null) {
                    lines = Arrays.asList("No es posible firmar el nodo: " + args[2], "Por favor, use COD o CODEH solamente");
                    Path file4 = Paths.get(outputMsg, new String[0]);
                    Files.write(file4, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    return;
                }
                System.out.println("No es posible firmar el nodo: " + args[2]);
                System.out.println("Por favor, use COD o CODEH solamente");
                return;
            }
            String fileName = args[1];
            File out = new File(args[4]);
            if (!fileName.contains(".pem")) {
                throw new CustomException("#### \n" + fileName + " no es un certificado valido");
            }
            DsCOD genEnvel = new DsCOD(fileName, isToken, outputMsg);
            DsCOD.createDir(out);
            File f = new File(args[3]);
            String docName = f.getName();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(args[3]));
            boolean ERROR = genEnvel.createXmlSignature(args[2], doc, cod, codeh, docName, outputMsg);
            if (!ERROR) {
                genEnvel.writeResult(args, isToken, cod, codeh, doc, docName, outputMsg);
            } else if (outputMsg != null) {
                List<String> lines3 = Collections.singletonList(docName + ": Se ha producido un error al crear la firma");
                Path file5 = Paths.get(outputMsg, new String[0]);
                Files.write(file5, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": Se ha producido un error al crear la firma");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate loadPublicX509(String fileName) throws IOException, GeneralSecurityException {
        X509Certificate crt;
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            boolean inKey = false;
            String line = br.readLine();
            while (line != null) {
                if (!inKey) {
                    if (line.startsWith("-----BEGIN") && line.endsWith(" CERTIFICATE-----")) {
                        inKey = true;
                    }
                } else {
                    if (line.startsWith("-----END") && line.endsWith(" CERTIFICATE-----")) break;
                    builder.append(line);
                }
                line = br.readLine();
            }
            byte[] encoded = DatatypeConverter.parseBase64Binary((String)builder.toString());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(encoded);
            crt = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (Throwable throwable) {
            DsCOD.closeSilent(is);
            throw throwable;
        }
        DsCOD.closeSilent(is);
        return crt;
    }

    private static void closeSilent(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createDir(File file) throws CustomException {
        boolean result;
        if (!(file.exists() || file.getName().contains(".xml") || (result = file.mkdirs()))) {
            throw new CustomException("No se pudo crear el directorio: " + file.getName());
        }
    }

    private static boolean verifySignature(Document doc, String docName, int id, String outputMsg) throws Exception {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": No se puede encontrar la firmaURICOD: " + URICOD + ", URICODEH: " + URICODEH);
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": No se puede encontrar la firma");
            }
            return false;
        }
        if (id == 1 && nl.getLength() < 2) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": CODEH no firmado");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": CODEH no firmado");
            }
            return false;
        }
        Element nodeElement = (Element)nl.item(id);
        NodeList sigInfo = nodeElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        Element sigElement = (Element)sigInfo.item(0);
        NodeList referenceURI = sigElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        Element referenceElement = (Element)referenceURI.item(0);
        String URI2 = referenceElement.getAttributes().getNamedItem("URI").getNodeValue();
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (URI2 != null && URI2.equals("#COD")) {
            XPathExpression exprCOD = xpath.compile(String.format("//*[@id='%s']", "COD"));
            NodeList nodesCOD = (NodeList)exprCOD.evaluate(doc, XPathConstants.NODESET);
            Node nodeCOD = nodesCOD.item(0);
            ((Element)nodeCOD).setIdAttribute("id", true);
        } else if (URI2 != null && URI2.equals("#CODEH")) {
            XPathExpression exprCODEH = xpath.compile(String.format("//*[@id='%s']", "CODEH"));
            NodeList nodesCODEH = (NodeList)exprCODEH.evaluate(doc, XPathConstants.NODESET);
            Node nodeCODEH = nodesCODEH.item(0);
            ((Element)nodeCODEH).setIdAttribute("id", true);
        }
        DOMValidateContext valContext = new DOMValidateContext(new KeyValueKeySelector(), nl.item(id));
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            if (id == 0) {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": La firma en COD ha fallado la verificaci\u00f3n base");
                    Path file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": La firma en COD ha fallado la verificaci\u00f3n base");
                }
                boolean sv = signature.getSignatureValue().validate(valContext);
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": Estado de validez del COD: " + sv);
                    Path path = Paths.get(outputMsg, new String[0]);
                    Files.write(path, (Iterable<? extends CharSequence>)lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": Estado de validez : " + sv);
                }
                for (Object e : signature.getSignedInfo().getReferences()) {
                    boolean refValid = ((Reference)e).validate(valContext);
                    if (outputMsg != null) {
                        List<String> lines = Collections.singletonList(docName + ": Estado de validez del COD: " + refValid);
                        Path file = Paths.get(outputMsg, new String[0]);
                        Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        continue;
                    }
                    System.out.println(docName + ": Estado de validez del COD: " + refValid);
                }
            } else if (id == 1) {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": La firma en CODEH ha fallado la verificaci\u00f3n base");
                    Path file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": La firma en CODEH ha fallado la verificaci\u00f3n base");
                }
                boolean sv = signature.getSignatureValue().validate(valContext);
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": Estado de validez del CODEH: " + sv);
                    Path path = Paths.get(outputMsg, new String[0]);
                    Files.write(path, (Iterable<? extends CharSequence>)lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": Estado de validez : " + sv);
                }
                for (Object e : signature.getSignedInfo().getReferences()) {
                    boolean refValid = ((Reference)e).validate(valContext);
                    if (outputMsg != null) {
                        List<String> lines = Collections.singletonList(docName + ": Estado de validez del CODEH: " + refValid);
                        Path file = Paths.get(outputMsg, new String[0]);
                        Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        continue;
                    }
                    System.out.println(docName + ": Estado de validez del CODEH: " + refValid);
                }
            }
            return false;
        }
        if (id == 0) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": La firma en COD ha pasado la verificaci\u00f3n base");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": La firma en COD ha pasado la verificaci\u00f3n base");
            }
        } else if (id == 1) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": La firma en CODEH ha pasado la verificaci\u00f3n base");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": La firma en CODEH ha pasado la verificaci\u00f3n base");
            }
        }
        return true;
    }

    void selectSignatureKey(String pin) throws Exception, CustomException {
        if (pkcs11Provider_.getTokenManager().getKeyStore() == null) {
            throw new CustomException("#### \nNo es posible acceder al token, verifique el archivo de configuracion");
        }
        TokenKeyStore tokenKeyStore = pkcs11Provider_.getTokenManager().getKeyStore();
        try {
            tokenKeyStore.load(null, pin.toCharArray());
        }
        catch (Exception ignored) {
            throw new CustomException("#### \nContrase\u00f1a invalida");
        }
        Enumeration<String> aliases = tokenKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate[] certificateChain;
            X509Certificate signerCertificate;
            boolean[] keyUsage;
            String keyAlias = aliases.nextElement();
            Key key = tokenKeyStore.getKey(keyAlias, null);
            if (!(key instanceof RSAPrivateKey) || (keyUsage = (signerCertificate = (X509Certificate)(certificateChain = tokenKeyStore.getCertificateChain(keyAlias))[0]).getKeyUsage()) != null && !keyUsage[0] && !keyUsage[1]) continue;
            signatureKey_ = (PrivateKey)key;
            signingCertificate_ = signerCertificate;
            break;
        }
        if (signatureKey_ == null) {
            throw new GeneralSecurityException("#### \nLlave de firma no encontrada. Asegurese que un token valido esta insertado.");
        }
    }

    private void getSignatureFromFile(String fileName) throws IOException, GeneralSecurityException {
        signingCertificate_ = DsCOD.loadPublicX509(fileName);
        try {
            signatureKey_ = this.loadPrivateKey(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createXmlSignature(String dataURL, Document doc, boolean cod, boolean codeh, String docName, String outputMsg) throws Exception {
        block26: {
            Path file;
            List<String> lines;
            boolean verifiedCODEH;
            block24: {
                block27: {
                    block25: {
                        this.getURI(doc);
                        if (!cod) break block25;
                        if (URICOD != null && URICOD.equals("#CODEH")) {
                            if (outputMsg != null) {
                                List<String> lines2 = Collections.singletonList(docName + ": Tag CODEH ya firmado, no es posible firmar tag COD, verifique el xml");
                                Path file2 = Paths.get(outputMsg, new String[0]);
                                Files.write(file2, lines2, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                                return true;
                            }
                            System.out.println(docName + ": Tag CODEH ya firmado, no es posible firmar tag COD, verifique el xml");
                            return true;
                        }
                        if (URICOD != null && URICOD.equals("#COD")) {
                            boolean verifiedCOD = DsCOD.verifySignature(doc, docName, 0, outputMsg);
                            if (verifiedCOD) {
                                if (outputMsg != null) {
                                    List<String> lines3 = Collections.singletonList(docName + ": Tag COD ya firmado de manera v\u00e1lida");
                                    Path file3 = Paths.get(outputMsg, new String[0]);
                                    Files.write(file3, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                                    return true;
                                }
                                System.out.println(docName + ": Tag COD ya firmado de manera v\u00e1lida");
                                return true;
                            }
                            if (outputMsg != null) {
                                List<String> lines4 = Collections.singletonList(docName + ": Tag COD ya firmado de manera inv\u00e1lida, verifique el xml");
                                Path file4 = Paths.get(outputMsg, new String[0]);
                                Files.write(file4, lines4, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                                return true;
                            }
                            System.out.println(docName + ": Tag COD ya firmado de manera inv\u00e1lida, verifique el xml");
                            return true;
                        }
                        if (URICODEH != null && URICODEH.equals("#CODEH") && (verifiedCODEH = DsCOD.verifySignature(doc, docName, 1, outputMsg))) {
                            if (outputMsg != null) {
                                List<String> lines5 = Collections.singletonList(docName + ": Tag CODEH ya firmado de manera v\u00e1lida, no es posible firmar tag COD");
                                Path file5 = Paths.get(outputMsg, new String[0]);
                                Files.write(file5, lines5, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                                return true;
                            }
                            System.out.println(docName + ": Tag CODEH ya firmado de manera v\u00e1lida, no es posible firmar tag COD");
                            return true;
                        }
                        break block26;
                    }
                    if (!codeh) break block26;
                    if (URICOD == null || !URICOD.equals("#COD")) break block27;
                    boolean verifiedCOD = DsCOD.verifySignature(doc, docName, 0, outputMsg);
                    if (verifiedCOD) {
                        if (outputMsg != null) {
                            lines = Collections.singletonList(docName + ": Tag COD firmado de manera v\u00e1lida");
                            file = Paths.get(outputMsg, new String[0]);
                            Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                            break block24;
                        } else {
                            System.out.println(docName + ": Tag COD firmado de manera valid\u00e1");
                        }
                        break block24;
                    } else {
                        if (outputMsg != null) {
                            List<String> lines6 = Collections.singletonList(docName + ": Tag COD firmado de manera inv\u00e1lida, verifique el xml");
                            Path file6 = Paths.get(outputMsg, new String[0]);
                            Files.write(file6, lines6, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                            return true;
                        }
                        System.out.println(docName + ": Tag COD firmado de manera inv\u00e1lida, verifique el xml");
                        return true;
                    }
                }
                if (outputMsg != null) {
                    List<String> lines7 = Collections.singletonList(docName + ": Tag COD no firmado, verifique el xml");
                    Path file7 = Paths.get(outputMsg, new String[0]);
                    Files.write(file7, lines7, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    return true;
                }
                System.out.println(docName + ": Tag COD no firmado, verifique el xml");
                return true;
            }
            if (URICODEH != null && URICODEH.equals("#CODEH")) {
                verifiedCODEH = DsCOD.verifySignature(doc, docName, 1, outputMsg);
                if (verifiedCODEH) {
                    if (outputMsg != null) {
                        lines = Collections.singletonList(docName + ": Tag CODEH ya firmado de manera v\u00e1lida, no es posible volver a realizar la firma");
                        file = Paths.get(outputMsg, new String[0]);
                        Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        return true;
                    }
                    System.out.println(docName + ": Tag CODEH ya firmado de manera v\u00e1lida, no es posible volver a realizar la firma");
                    return true;
                }
                if (outputMsg != null) {
                    lines = Collections.singletonList(docName + ": Tag CODEH ya firmado de manera inv\u00e1lida, verifique el xml");
                    file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    return true;
                }
                System.out.println(docName + ": Tag CODEH ya firmado de manera inv\u00e1lida, verifique el xml");
                return true;
            }
        }
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(String.format("//*[@id='%s']", dataURL));
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (nodes.getLength() == 0) {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": No es posible encontrar el nodo: " + dataURL);
                    Path file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    return true;
                }
                System.out.println(docName + ": No es posible encontrar el nodo: " + dataURL);
                return true;
            }
            Node nodeToSign = nodes.item(0);
            ((Element)nodeToSign).setIdAttribute("id", true);
            Node sigParent = nodeToSign.getParentNode();
            String referenceURI = "#" + dataURL;
            ArrayList<Transform> transformList = new ArrayList<Transform>(1);
            transformList.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            transformList.add(fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null));
            Reference ref = fac.newReference(referenceURI, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
            List<Reference> referenceList = Collections.singletonList(ref);
            CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (XMLStructure)null);
            SignatureMethod signatureMethod = fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            SignedInfo si = fac.newSignedInfo(canonicalizationMethod, signatureMethod, referenceList);
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            ArrayList<Object> x509Content = new ArrayList<Object>();
            x509Content.add(signingCertificate_.getSubjectX500Principal().getName());
            x509Content.add(signingCertificate_);
            X509Data x509data = kif.newX509Data(x509Content);
            ArrayList<XMLStructure> list = new ArrayList<XMLStructure>();
            KeyValue kv = kif.newKeyValue(signingCertificate_.getPublicKey());
            list.add(kv);
            list.add(x509data);
            KeyInfo ki = kif.newKeyInfo(list);
            XMLSignature signature = fac.newXMLSignature(si, ki);
            DOMSignContext signContext = new DOMSignContext(signatureKey_, sigParent);
            signContext.setDefaultNamespacePrefix("ds");
            try {
                signature.sign(signContext);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private void getURI(Document doc) {
        try {
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() != 0) {
                Element nodeElementCOD = (Element)nl.item(0);
                NodeList sigInfoCOD = nodeElementCOD.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
                Element sigElementCOD = (Element)sigInfoCOD.item(0);
                NodeList referenceURICOD = sigElementCOD.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
                Element referenceElementCOD = (Element)referenceURICOD.item(0);
                URICOD = referenceElementCOD.getAttributes().getNamedItem("URI").getNodeValue();
                if (URICOD.equals("#CODEH")) {
                    URICODEH = URICOD;
                    return;
                }
                Element nodeElementCODEH = (Element)nl.item(1);
                NodeList sigInfoCODEH = nodeElementCODEH.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
                Element sigElementCODEH = (Element)sigInfoCODEH.item(0);
                NodeList referenceURICODEH = sigElementCODEH.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
                Element referenceElementCODEH = (Element)referenceURICODEH.item(0);
                URICODEH = referenceElementCODEH.getAttributes().getNamedItem("URI").getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey loadPrivateKey(String fileName) throws IOException, GeneralSecurityException {
        PrivateKey key;
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            boolean inKey = false;
            String line = br.readLine();
            while (line != null) {
                if (!inKey) {
                    if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) {
                        inKey = true;
                    }
                } else {
                    if (line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----")) break;
                    builder.append(line);
                }
                line = br.readLine();
            }
            byte[] encoded = DatatypeConverter.parseBase64Binary((String)builder.toString());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            key = kf.generatePrivate(keySpec);
        }
        catch (Throwable throwable) {
            DsCOD.closeSilent(is);
            throw throwable;
        }
        DsCOD.closeSilent(is);
        return key;
    }

    private void writeResult(String[] args, int isToken, boolean cod, boolean codeh, Document doc, String docName, String outputMsg) throws Exception {
        File file;
        OutputStream os = System.out;
        if (isToken == 1) {
            file = new File(args[5]);
            os = file.isDirectory() ? (args.length > 5 ? new FileOutputStream(file.getAbsolutePath() + File.separator + docName) : System.out) : (args.length > 5 ? new FileOutputStream(args[5]) : System.out);
        } else if (isToken == 0) {
            file = new File(args[4]);
            os = file.isDirectory() ? (args.length > 4 ? new FileOutputStream(file.getAbsolutePath() + File.separator + docName) : System.out) : (args.length > 4 ? new FileOutputStream(args[4]) : System.out);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        if (cod) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": COD firmado correctamente");
                Path file2 = Paths.get(outputMsg, new String[0]);
                Files.write(file2, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": COD firmado correctamente");
            }
        } else if (codeh) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": CODEH firmado correctamente");
                Path file3 = Paths.get(outputMsg, new String[0]);
                Files.write(file3, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": CODEH firmado correctamente");
            }
        }
    }

    static {
        URICOD = null;
        URICODEH = null;
    }

    public static class CustomException
    extends Throwable {
        CustomException(String message) {
            super(message, null, true, false);
        }

        @Override
        public String toString() {
            String s = this.getClass().getName();
            String message = this.getLocalizedMessage();
            return message != null ? message : s;
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("#### \nEl objeto KeyInfo no existe!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (XMLStructure aList : list) {
                PublicKey pk;
                List<?> l;
                XMLStructure xmlStructure = aList;
                if (xmlStructure instanceof X509Data && (l = ((X509Data)xmlStructure).getContent()).size() > 0) {
                    X509Certificate cert = (X509Certificate)l.get(0);
                    pk = cert.getPublicKey();
                    if (this.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) {
                        return new SimpleKeySelectorResult(pk);
                    }
                }
                if (!(xmlStructure instanceof KeyValue)) continue;
                pk = null;
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException keyException) {
                    // empty catch block
                }
                assert (pk != null);
                if (!this.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("#### \nKeyValue no encontrado!");
        }

        boolean algEquals(String algURI, String algName) {
            return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

