/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.cipher.f;
import iaik.xml.crypto.alg.cipher.g;
import iaik.xml.crypto.alg.cipher.h;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class ProxyCipher
extends CipherSpi {
    protected Cipher cipher_;

    public ProxyCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (!XSecProvider.lateAlgorithmProxyInstantiation()) {
            this.getAlgorithmInstanceUncaught(null);
        }
    }

    protected void getAlgorithmInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        String string = this.getCipherName();
        Provider provider = XSecProvider.getDelegationProvider("Cipher." + string, purpose);
        if (provider != null) {
            try {
                this.cipher_ = Cipher.getInstance(string, provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.cipher_ = Cipher.getInstance(string, provider.getName());
            }
        }
        if (this.cipher_ == null) {
            this.cipher_ = Cipher.getInstance(string);
        }
    }

    protected void getAlgorithmInstance(XSecProvider.Purpose purpose) {
        if (this.cipher_ != null) {
            return;
        }
        try {
            this.getAlgorithmInstanceUncaught(purpose);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new f(this, "Delegation provider not registered, any more.", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new g(this, noSuchPaddingException.getMessage(), noSuchPaddingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new h(this, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    protected void getInstance(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.ENCRYPT);
                break;
            }
            case 2: 
            case 4: {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.DECRYPT);
                break;
            }
        }
    }

    protected abstract String getCipherName();

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected int engineGetBlockSize() {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.getBlockSize();
    }

    protected int engineGetOutputSize(int n2) {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.getOutputSize(n2);
    }

    protected byte[] engineGetIV() {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.getIV();
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.getParameters();
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (this.cipher_ == null) {
            this.getInstance(n2);
        }
        this.cipher_.init(n2, key, secureRandom);
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher_ == null) {
            this.getInstance(n2);
        }
        this.cipher_.init(n2, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher_ == null) {
            this.getInstance(n2);
        }
        this.cipher_.init(n2, key, algorithmParameters, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.update(byArray, n2, n3);
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.update(byArray, n2, n3, byArray2);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            return this.cipher_.doFinal();
        }
        return this.cipher_.doFinal(byArray, n2, n3);
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            return this.cipher_.doFinal(byArray2, n4);
        }
        return this.cipher_.doFinal(byArray, n2, n3, byArray2, n4);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.unwrap(byArray, string, n2);
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.cipher_ == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.cipher_.wrap(key);
    }
}

