/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.signature;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.signature.a;
import iaik.xml.crypto.alg.signature.b;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class ProxySignature
extends SignatureSpi {
    protected Signature signature_;

    public ProxySignature() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (!XSecProvider.lateAlgorithmProxyInstantiation()) {
            this.getInstanceUncaught(null);
        }
    }

    protected void getInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException, NoSuchProviderException {
        String string = this.getSignatureName();
        Provider provider = XSecProvider.getDelegationProvider("Signature." + string, purpose);
        if (provider != null) {
            try {
                this.signature_ = Signature.getInstance(string, provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.signature_ = Signature.getInstance(string, provider.getName());
            }
        }
        if (this.signature_ == null) {
            this.signature_ = Signature.getInstance(string);
        }
    }

    protected void getInstance(XSecProvider.Purpose purpose) {
        if (this.signature_ != null) {
            return;
        }
        try {
            this.getInstanceUncaught(purpose);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new a(this, "Delegation provider not registered, any more.", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new b(this, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    protected abstract String getSignatureName();

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (this.signature_ == null) {
            this.getInstance(XSecProvider.Purpose.SignaturePurpose.SIGN);
        }
        this.signature_.initSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (this.signature_ == null) {
            this.getInstance(XSecProvider.Purpose.SignaturePurpose.SIGN);
        }
        this.signature_.initSign(privateKey, secureRandom);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        return this.signature_.sign();
    }

    protected int engineSign(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        return this.signature_.sign(byArray, n2, n3);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        this.signature_.update(by);
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        try {
            this.signature_.update(byteBuffer);
        }
        catch (SignatureException signatureException) {
            throw new ProviderException("update() failed", signatureException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        this.signature_.update(byArray, n2, n3);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (this.signature_ == null) {
            this.getInstance(XSecProvider.Purpose.SignaturePurpose.VERIFY);
        }
        this.signature_.initVerify(publicKey);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        return this.signature_.verify(byArray);
    }

    protected boolean engineVerify(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        return this.signature_.verify(byArray, n2, n3);
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        return this.signature_.getParameters();
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        return this.signature_.getParameter(string);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        this.signature_.setParameter(string, object);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (this.signature_ == null) {
            throw new IllegalStateException("Signature not initialized");
        }
        this.signature_.setParameter(algorithmParameterSpec);
    }
}

