/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.signature;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.xml.crypto.alg.signature.ProxySignature;
import iaik.xml.crypto.alg.signature.i;
import iaik.xml.crypto.dsig.spec.RSASSAPSSParameterImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.dsig.DigestMethod;

public class RSASSAPSSProxySignature
extends ProxySignature {
    protected String getSignatureName() {
        return "RSASSA-PSS";
    }

    protected byte[] engineSign() throws SignatureException {
        return super.engineSign();
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof RSASSAPSSParameterImpl) {
            try {
                int n2;
                Object object;
                RSASSAPSSParameterImpl rSASSAPSSParameterImpl = (RSASSAPSSParameterImpl)algorithmParameterSpec;
                DigestMethod digestMethod = rSASSAPSSParameterImpl.getDigestMethod();
                AlgorithmID algorithmID = null;
                if (digestMethod != null) {
                    MessageDigest messageDigest = MessageDigest.getInstance(digestMethod.getAlgorithm());
                    algorithmID = this.a(messageDigest);
                } else {
                    algorithmID = (AlgorithmID)AlgorithmID.sha256.clone();
                }
                int n3 = -1;
                DigestMethod digestMethod2 = rSASSAPSSParameterImpl.getMGFDigestMethod();
                AlgorithmID algorithmID2 = null;
                if (digestMethod2 != null) {
                    object = MessageDigest.getInstance(digestMethod2.getAlgorithm());
                    algorithmID2 = this.a((MessageDigest)object);
                    n3 = ((MessageDigest)object).getDigestLength();
                } else {
                    algorithmID2 = (AlgorithmID)AlgorithmID.sha256.clone();
                    n3 = 32;
                }
                object = rSASSAPSSParameterImpl.getMGF();
                AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.mgf1.clone();
                if (object != null && !"http://www.w3.org/2007/05/xmldsig-more#MGF1".equals(object)) {
                    throw new InvalidAlgorithmParameterException((String)object + " not supported.");
                }
                algorithmID3.setParameter(algorithmID2.toASN1Object());
                Integer n4 = rSASSAPSSParameterImpl.getSaltLength();
                if (n4 != null) {
                    n3 = rSASSAPSSParameterImpl.getSaltLength();
                }
                if ((n2 = rSASSAPSSParameterImpl.getTrailerField().intValue()) != 1) {
                    throw new InvalidAlgorithmParameterException("TrailerField: " + n2 + " not supported.");
                }
                RSAPssParameterSpec rSAPssParameterSpec = new RSAPssParameterSpec(algorithmID2, algorithmID3, n3);
                MessageDigest messageDigest = algorithmID.getMessageDigestInstance("IAIK");
                rSAPssParameterSpec.setHashEngine(messageDigest);
                MessageDigest messageDigest2 = algorithmID2.getMessageDigestInstance("IAIK");
                MaskGenerationAlgorithm maskGenerationAlgorithm = algorithmID3.getMaskGenerationAlgorithmInstance("IAIK");
                MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(algorithmID2);
                mGF1ParameterSpec.setHashEngine(messageDigest2);
                maskGenerationAlgorithm.setParameters((AlgorithmParameterSpec)mGF1ParameterSpec);
                rSAPssParameterSpec.setMGFEngine(maskGenerationAlgorithm);
                super.engineSetParameter((AlgorithmParameterSpec)rSAPssParameterSpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new i(this, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
        } else {
            super.engineSetParameter(algorithmParameterSpec);
        }
    }

    private AlgorithmID a(MessageDigest messageDigest) throws InvalidAlgorithmParameterException {
        AlgorithmID algorithmID;
        String string = messageDigest.getAlgorithm();
        try {
            string = string.substring(string.indexOf(35) + 1).toUpperCase();
            algorithmID = AlgorithmID.getAlgorithmID((String)string);
        }
        catch (Exception exception) {
            string = "Could not be derived from URL";
            algorithmID = null;
        }
        if (algorithmID == null) {
            throw new InvalidAlgorithmParameterException("Could not derive Message Digest AlgorithmID from: " + messageDigest.getAlgorithm());
        }
        return algorithmID;
    }
}

