/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.transform;

import iaik.utils.Base64InputStream;
import iaik.xml.crypto.alg.transform.TransformServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import org.w3c.dom.Node;

public class Base64TransformService
extends TransformServiceImpl {
    protected void setParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("TransformParameterSpec '" + algorithmParameterSpec.getClass().getName() + "' not supported by " + this.getClass().getName() + ".");
        }
    }

    protected void setParameterSpec(List list) throws InvalidAlgorithmParameterException {
        if (list.size() != 0) {
            throw new InvalidAlgorithmParameterException("TransformParameterSpec '" + list.getClass().getName() + "' not supported by " + this.getClass().getName() + ".");
        }
    }

    public List getAlgorithmParameters() {
        return new ArrayList();
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        Object object;
        if (data instanceof OctetStreamData) {
            OctetStreamData octetStreamData = (OctetStreamData)data;
            return new OctetStreamData((InputStream)new Base64InputStream(octetStreamData.getOctetStream(), true), octetStreamData.getURI(), octetStreamData.getMimeType());
        }
        Iterator iterator = ((NodeSetData)data).iterator();
        Vector<ByteArrayInputStream> vector = new Vector<ByteArrayInputStream>();
        try {
            while (iterator.hasNext()) {
                String string;
                object = (Node)iterator.next();
                if (object.getNodeType() != 3 || (string = object.getNodeValue()) == null) continue;
                vector.add(new ByteArrayInputStream(string.getBytes("ASCII")));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TransformException(unsupportedEncodingException);
        }
        object = new SequenceInputStream(vector.elements());
        return new OctetStreamData((InputStream)new Base64InputStream((InputStream)object, true));
    }
}

