/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dom;

import iaik.utils.Base64Exception;
import iaik.xml.crypto.dom.DOMCryptoContext;
import iaik.xml.crypto.dom.DuplicateIdException;
import iaik.xml.crypto.utils.DOMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class DOMStructure
extends javax.xml.crypto.dom.DOMStructure
implements XMLStructure {
    private b h;
    protected static final Map implMap_ = new HashMap();
    public static final int STATE_UNINITIALIZED = -1;
    public static final int STATE_CREATED = 0;
    public static final int STATE_MARSHALED = 1;
    public static final int STATE_UNMARSHALED = 3;
    protected int state_ = 0;
    private Node i;
    private DOMStructure j;
    static final Method a;
    static final Method b;
    private static boolean k;
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;

    protected static b newIDforLookUp(String string) {
        return new b(string);
    }

    protected static final void putImplClass(String string, String string2, String string3) {
        implMap_.put(string + " " + string2, string3);
    }

    protected static final String getImplClass(String string, String string2) {
        return (String)implMap_.get(string + " " + string2);
    }

    public static DOMStructure getInstance(Node node, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (node == null) {
            throw new NullPointerException("Argument 'node' must not be null");
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Given node '" + node + "' must be of type '" + (c == null ? (c = DOMStructure.a("org.w3c.dom.Element")) : c).getName() + "'.");
        }
        String string = node.getLocalName();
        String string2 = node.getNamespaceURI();
        String string3 = DOMStructure.getImplClass(string2, string);
        return DOMStructure.getInstance(node, dOMCryptoContext, string3);
    }

    protected static DOMStructure getInstance(Node node, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, String string) throws MarshalException {
        if (string != null) {
            DOMStructure dOMStructure;
            Class<?> clazz;
            ClassLoader classLoader = (d == null ? (d = DOMStructure.a("iaik.xml.crypto.dom.DOMStructure")) : d).getClassLoader();
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MarshalException("Implementation class '" + string + "' of element '" + node.getNamespaceURI() + ":" + node.getLocalName() + "' not found. " + classNotFoundException.getMessage());
                }
            }
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MarshalException("Implementation class '" + string + "' of element '" + node.getNamespaceURI() + ":" + node.getLocalName() + "' not found. " + classNotFoundException.getMessage());
            }
            Class[] classArray = new Class[]{e == null ? (e = DOMStructure.a("javax.xml.crypto.dom.DOMCryptoContext")) : e, f == null ? (f = DOMStructure.a("org.w3c.dom.Node")) : f};
            try {
                Constructor<?> constructor = clazz.getConstructor(classArray);
                dOMStructure = (DOMStructure)constructor.newInstance(dOMCryptoContext, node);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof MarshalException) {
                    throw (MarshalException)throwable;
                }
                throw new MarshalException("Invocation failed when creating an instance of class '" + string + "' for element '" + node.getNamespaceURI() + ":" + node.getLocalName() + "'. " + invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (Exception exception) {
                throw new MarshalException("Failed to create instance of class '" + string + "' for element '" + node.getNamespaceURI() + ":" + node.getLocalName() + "'. " + exception.getMessage(), exception);
            }
            return dOMStructure;
        }
        return null;
    }

    protected DOMStructure() {
        super(new a(null));
        this.state_ = 0;
    }

    protected DOMStructure(Node node) {
        super(new a(null));
        if (node == null) {
            throw new NullPointerException("Argument 'node' must not be null");
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Given node '" + node + "' must be of type '" + (c == null ? (c = DOMStructure.a("org.w3c.dom.Element")) : c).getName() + "'.");
        }
        this.i = node;
        this.state_ = 0;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public final Node getNode() {
        return this.i;
    }

    protected final void setNode(Node node) throws MarshalException {
        if (this.i != null && node != null && this.getParentStructure() != null && this.getParentStructure().getNode() != node.getParentNode()) {
            throw new MarshalException("Inconsistent Data Structure, please contact IAIK");
        }
        this.i = node;
    }

    public abstract String getLocalName();

    public abstract String getNamespace();

    public static String getQualifiedName(String string, String string2) {
        if (string != null && string.length() > 0) {
            return string + ":" + string2;
        }
        return string2;
    }

    protected static void addBytesToElement(Element element, byte[] byArray, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext) throws MarshalException {
        try {
            DOMUtils.addBytesToElement(element, byArray, (byte[])dOMCryptoContext.getProperty("iaik.xml.crypto.base64.linebreak"));
        }
        catch (IOException iOException) {
            throw new MarshalException("Failed to marshal property", iOException);
        }
    }

    protected static void addBytesToElement(Element element, InputStream inputStream, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext) throws MarshalException {
        try {
            DOMUtils.addBytesToElement(element, inputStream, (byte[])dOMCryptoContext.getProperty("iaik.xml.crypto.base64.linebreak"));
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
    }

    protected static InputStream getBytesFromElementStream(Element element) throws MarshalException {
        try {
            return DOMUtils.getBytesFromElementChildrensStream(element);
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
    }

    protected static byte[] getBytesFromElement(Element element) throws MarshalException {
        try {
            return DOMUtils.getBytesFromElementChildrens(element);
        }
        catch (Base64Exception base64Exception) {
            throw new MarshalException("Unmarshaling failed", base64Exception);
        }
        catch (IOException iOException) {
            throw new MarshalException("Unmarshaling failed", iOException);
        }
    }

    public String getQualifiedName(String string) {
        return DOMStructure.getQualifiedName(string, this.getLocalName());
    }

    public Node marshal(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Object object;
        if (this.getParentStructure() != null && node != this.getParentStructure().getNode()) {
            throw new MarshalException("Inconsistent Data Structure, please contact IAIK");
        }
        if (this.state_ < 1 || this.getNode() == null || node.getOwnerDocument() != this.getNode().getOwnerDocument()) {
            this.setNode(this.marshalElement(dOMCryptoContext, node, node2));
            this.marshalAttributes(dOMCryptoContext, (Element)this.getNode());
            if (this.getNode().getNodeType() == 1 && (object = this.marshalIDAttribute(dOMCryptoContext, (Element)this.getNode())) != null) {
                ((Element)this.getNode()).setAttributeNodeNS((Attr)object);
                dOMCryptoContext.setIdAttributeNS((Element)this.i, null, object.getLocalName());
            }
            this.state_ = 1;
        }
        if ((object = this.getChildStructures()) != null && !object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                XMLStructure xMLStructure = (XMLStructure)iterator.next();
                if (xMLStructure instanceof DOMStructure) {
                    object2 = (DOMStructure)xMLStructure;
                    ((DOMStructure)object2).setParentStructure(this);
                    ((DOMStructure)object2).marshal(dOMCryptoContext, this.getNode(), null);
                    continue;
                }
                if (xMLStructure instanceof javax.xml.crypto.dom.DOMStructure) {
                    object2 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
                    Node node3 = this.getNode();
                    if (object2.getOwnerDocument() != node3.getOwnerDocument()) {
                        object2 = node3.getOwnerDocument().importNode((Node)object2, true);
                    }
                    node3.appendChild((Node)object2);
                    continue;
                }
                throw new MarshalException(this.getClass().getName() + " supports the DOM marshaling mechanism only");
            }
        }
        return this.getNode();
    }

    protected Element marshalElement(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        String string = this.getQualifiedName(dOMCryptoContext.getNamespacePrefix(this.getNamespace(), dOMCryptoContext.getDefaultNamespacePrefix()));
        return (Element)node.insertBefore(document.createElementNS(this.getNamespace(), string), node2);
    }

    protected void marshalAttributes(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        String string = this.getNamespace();
        String string2 = dOMCryptoContext.getNamespacePrefix(string, dOMCryptoContext.getDefaultNamespacePrefix());
        DOMStructure dOMStructure = this.getParentStructure();
        if (dOMStructure == null || !dOMStructure.isNSDeclInScope(string2, string)) {
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, this.getNamespace());
        }
    }

    protected boolean isNSDeclInScope(String string, String string2) throws MarshalException {
        try {
            Node node = this.getNode();
            if ((string == null || string.equals("")) && b != null) {
                return b.invoke((Object)node, (Object[])new String[]{string2}).equals(Boolean.TRUE);
            }
            if (a != null) {
                return string2.equals((String)a.invoke((Object)node, (Object[])new String[]{string}));
            }
            if (b == null && a == null) {
                return this.hasNSDeclAttrInScope(string, string2);
            }
            throw new MarshalException("Either both isDefaultNamespace and lookupNamespaceURI or none MUST be available" + node.getClass());
        }
        catch (Throwable throwable) {
            throw new MarshalException(throwable);
        }
    }

    protected boolean hasNSDeclAttrInScope(String string, String string2) {
        for (Node node = this.getNode(); node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Node node2 = namedNodeMap.item(i2);
                String string3 = node2.getPrefix();
                String string4 = node2.getLocalName();
                String string5 = node2.getNodeValue();
                if ((string == null || string.equals("")) && DOMUtils.NamespaceSpecNSPrefix.equals(string4)) {
                    return string5.equals(string2);
                }
                if (!DOMUtils.NamespaceSpecNSPrefix.equals(string3) || !string4.equals(string)) continue;
                return string5.equals(string2);
            }
        }
        return false;
    }

    protected Attr marshalIDAttribute(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, Element element) {
        return null;
    }

    public void unmarshal(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (this.state_ < 3) {
            this.unmarshalElement(dOMCryptoContext, (Element)this.getNode());
            object = this.getNode().getAttributes();
            if (object != null && object.getLength() > 0) {
                this.unmarshalAttributes((NamedNodeMap)object, dOMCryptoContext);
            }
            this.state_ = 3;
        }
        if ((object = this.getNode().getChildNodes()) != null && object.getLength() > 0) {
            this.unmarshalStructures((NodeList)object, dOMCryptoContext);
        }
    }

    protected void unmarshalElement(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            String string;
            Node node = namedNodeMap.item(i2);
            if (!DOMUtils.NamespaceSpecNSPrefix.equals(node.getPrefix()) || dOMCryptoContext.getNamespacePrefix(string = node.getNodeValue(), null) != null) continue;
            if (string == null || string.equals("")) {
                throw new MarshalException("Invalid Namespace Declaration");
            }
            dOMCryptoContext.putNamespacePrefix(string, node.getLocalName());
        }
        if (element.getNamespaceURI() != null && dOMCryptoContext.getNamespacePrefix(element.getNamespaceURI(), null) == null && element.getPrefix() != null) {
            dOMCryptoContext.putNamespacePrefix(element.getNamespaceURI(), element.getPrefix());
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext) throws MarshalException {
    }

    protected String unmarshalIDAttribute(NamedNodeMap namedNodeMap, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, String string) throws MarshalException {
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, string);
        if (attr != null) {
            this.h = new b(attr.getValue());
            DOMStructure dOMStructure = null;
            if (dOMCryptoContext instanceof DOMCryptoContext) {
                dOMStructure = (DOMStructure)dOMCryptoContext.put(this.h, this);
            } else {
                String string2 = attr.getLocalName();
                String string3 = attr.getNamespaceURI();
                dOMCryptoContext.setIdAttributeNS((Element)this.getNode(), string3, string2);
                dOMStructure = (DOMStructure)dOMCryptoContext.put(this.h, this);
            }
            if (dOMStructure != null) {
                throw new DuplicateIdException(dOMStructure, this);
            }
            return attr.getValue().intern();
        }
        return null;
    }

    protected void unmarshalStructures(NodeList nodeList, javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            DOMStructure dOMStructure;
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 1 || (dOMStructure = DOMStructure.getInstance(node, dOMCryptoContext)) == null) continue;
            this.putChildStructure(dOMStructure);
        }
    }

    protected List getChildStructures() {
        return new ArrayList();
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        if (dOMStructure != null) {
            dOMStructure.setParentStructure(this);
        }
    }

    protected void setParentStructure(DOMStructure dOMStructure) throws MarshalException {
        if (this.j != null && this.j == dOMStructure) {
            throw new MarshalException("ParentStructure of " + this.getLocalName() + " cannot be set twice to the same value " + this.j.getLocalName());
        }
        if (this.j != null && dOMStructure != null) {
            throw new MarshalException("ParentStructure of " + this.getLocalName() + " cannot be set twice. " + " Currently value " + this.j.getLocalName() + " cannot be set to " + dOMStructure.getLocalName());
        }
        this.j = dOMStructure;
    }

    protected static DOMStructure getParentStructureOf(DOMStructure dOMStructure) {
        return dOMStructure.getParentStructure();
    }

    protected DOMStructure getParentStructure() {
        return this.j;
    }

    public static DOMStructure wrapNode(Node node) {
        return new NodeWrapper(node);
    }

    protected static void clearMarshalling(DOMStructure dOMStructure) {
        dOMStructure.clearMarshalling();
    }

    protected void clearMarshalling() {
        Object object;
        List list = this.getChildStructures();
        if (list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                DOMStructure dOMStructure = (DOMStructure)object.next();
                dOMStructure.clearMarshalling();
            }
        }
        if (this.i != null && (object = this.getNode().getParentNode()) != null) {
            object.removeChild(this.i);
        }
        this.i = null;
        this.j = null;
        this.state_ = 0;
    }

    public static void setBackToCompatibilityPrior1_14(boolean bl) {
        k = bl;
    }

    protected Node getHere() {
        Node node;
        NamedNodeMap namedNodeMap;
        Node node2 = this.getNode();
        if (node2 != null && !k && (namedNodeMap = node2.getAttributes()) != null && (node = namedNodeMap.getNamedItemNS(null, "URI")) != null) {
            node2 = node;
        }
        return node2;
    }

    protected String getChildStructureVersion() {
        return "";
    }

    public String toString() {
        String string = this.getClass().getName() + "(";
        switch (this.state_) {
            case -1: {
                string = string + "STATE_UNINITIALIZED";
                break;
            }
            case 0: {
                string = string + "STATE_CREATED";
                break;
            }
            case 1: {
                string = string + "STATE_MARSHALED";
                break;
            }
            case 3: {
                string = string + "STATE_UNMARSHALED";
                break;
            }
            default: {
                string = string + "STATE_UNKNOWN " + this.state_;
            }
        }
        string = string + ")";
        if (this.i != null && !(this.i instanceof a)) {
            string = string + " : " + DOMUtils.nodeToString(this.i);
        }
        return string;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Method method = null;
        Method method2 = null;
        try {
            method = (c == null ? (c = DOMStructure.a("org.w3c.dom.Element")) : c).getMethod("lookupNamespaceURI", g == null ? (g = DOMStructure.a("java.lang.String")) : g);
            method2 = (c == null ? (c = DOMStructure.a("org.w3c.dom.Element")) : c).getMethod("isDefaultNamespace", g == null ? (g = DOMStructure.a("java.lang.String")) : g);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        a = method;
        b = method2;
        k = false;
    }

    private static class a
    implements Node {
        private a() {
        }

        public Node appendChild(Node node) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node cloneNode(boolean bl) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public NamedNodeMap getAttributes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public NodeList getChildNodes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getFirstChild() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getLastChild() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getLocalName() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getNamespaceURI() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getNextSibling() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getNodeName() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public short getNodeType() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getNodeValue() throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Document getOwnerDocument() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getParentNode() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getPrefix() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getPreviousSibling() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean hasAttributes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean hasChildNodes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node insertBefore(Node node, Node node2) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isSupported(String string, String string2) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void normalize() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node removeChild(Node node) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node replaceChild(Node node, Node node2) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void setNodeValue(String string) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void setPrefix(String string) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getBaseURI() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public short compareDocumentPosition(Node node) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getTextContent() throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void setTextContent(String string) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isSameNode(Node node) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String lookupPrefix(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isDefaultNamespace(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String lookupNamespaceURI(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isEqualNode(Node node) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Object getFeature(String string, String string2) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Object getUserData(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        a(iaik.xml.crypto.dom.a a2) {
            this();
        }
    }

    protected static final class NodeWrapper
    extends DOMStructure {
        protected NodeWrapper(Node node) {
            try {
                this.setNode(node);
            }
            catch (MarshalException marshalException) {
                marshalException.printStackTrace();
                throw new RuntimeException(marshalException.getMessage());
            }
        }

        public String getLocalName() {
            return this.getNode().getLocalName();
        }

        public String getNamespace() {
            return this.getNode().getNamespaceURI();
        }

        protected void clearMarshalling() {
            List list = this.getChildStructures();
            if (list != null && list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DOMStructure dOMStructure = (DOMStructure)iterator.next();
                    dOMStructure.clearMarshalling();
                }
            }
            try {
                this.setParentStructure(null);
            }
            catch (MarshalException marshalException) {
                // empty catch block
            }
        }

        public Node marshal(javax.xml.crypto.dom.DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
            Document document = node.getOwnerDocument();
            Node node3 = this.getNode();
            if (node3.getOwnerDocument() != document) {
                this.setNode(node.appendChild(document.importNode(this.getNode(), true)));
            } else if (node != node3.getParentNode()) {
                this.setNode(node.appendChild(node3.cloneNode(true)));
            } else {
                throw new MarshalException("A wrapped Node either has to be in another document so it can be imported, but it should not be marhalled twice into the same parent.");
            }
            return this.getNode();
        }
    }

    static final class b {
        final String a;

        protected b(String string) {
            this.a = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof b) {
                return this.a.equals(((b)object).a);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String toString() {
            return this.a.toString();
        }
    }
}

